/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnitExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionReturnTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunctionReturnTypeMismatchChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirFunctionReturnTypeMismatchChecker INSTANCE = new FirFunctionReturnTypeMismatchChecker();

    private FirFunctionReturnTypeMismatchChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirReturnExpression expression, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType returnExpressionType;
        ConeInferenceContext typeContext2;
        ConeKotlinType functionReturnType;
        FirExpression resultExpression;
        FirFunction targetElement;
        block15: {
            block16: {
                KtSourceElementKind sourceKind;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                KtSourceElement ktSourceElement = expression.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                    return;
                }
                targetElement = expression.getTarget().getLabeledElement();
                if (targetElement instanceof FirErrorFunction) {
                    return;
                }
                KtSourceElement ktSourceElement2 = expression.getSource();
                Object object = sourceKind = ktSourceElement2 != null ? ktSourceElement2.getKind() : null;
                if (!(DeclarationUtilsKt.getHasExplicitReturnType((FirCallableSymbol)targetElement.getSymbol()) || Intrinsics.areEqual((Object)sourceKind, (Object)KtRealSourceElementKind.INSTANCE) || targetElement instanceof FirPropertyAccessor)) {
                    return;
                }
                resultExpression = expression.getResult();
                if (resultExpression instanceof FirWhenExpression && !ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)resultExpression)) {
                    return;
                }
                ConeKotlinType coneKotlinType = functionReturnType = targetElement instanceof FirConstructor ? (ConeKotlinType)context2.getSession().getBuiltinTypes().getUnitType().getConeType() : TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(targetElement.getReturnTypeRef()), context2.getSession(), null, 2, null);
                if (!(targetElement instanceof FirAnonymousFunction)) break block15;
                if (sourceKind instanceof KtFakeSourceElementKind.ImplicitReturn.FromLastStatement && ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) {
                    return;
                }
                if (!((FirAnonymousFunction)targetElement).isLambda()) break block15;
                if (ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) break block15;
                if (!(resultExpression instanceof FirUnitExpression)) break block16;
                KtSourceElement ktSourceElement3 = ((FirUnitExpression)resultExpression).getSource();
                if ((ktSourceElement3 != null ? ktSourceElement3.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitUnit) break block15;
            }
            return;
        }
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession()), returnExpressionType = FirTypeUtilsKt.getResolvedType(resultExpression), functionReturnType)) {
            if (FirTypeUtilsKt.isNullLiteral(resultExpression) && !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(functionReturnType)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)resultExpression.getSource()), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (Object)functionReturnType, (DiagnosticContext)context2, null, (int)16, null);
            } else {
                boolean isDueToNullability = InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), returnExpressionType, functionReturnType);
                if (resultExpression instanceof FirSmartCastExpression && !((FirSmartCastExpression)resultExpression).isStable() && FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, FirTypeUtilsKt.getConeType(((FirSmartCastExpression)resultExpression).getSmartcastType()), functionReturnType)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirSmartCastExpression)resultExpression).getSource()), FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE(), (Object)functionReturnType, (Object)resultExpression, (Object)((FirSmartCastExpression)resultExpression).getSmartcastStability().getDescription(), (Object)isDueToNullability, (DiagnosticContext)context2, null, (int)128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)resultExpression.getSource()), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)isDueToNullability, (DiagnosticContext)context2, null, (int)128, null);
                }
            }
        } else {
            KtSourceElement ktSourceElement = resultExpression.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitUnit && !ConeBuiltinTypeUtilsKt.isUnit(ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default(functionReturnType, context2.getSession(), null, 2, null)))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)resultExpression.getSource()), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)false, (DiagnosticContext)context2, null, (int)128, null);
            }
        }
    }
}

