/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAugmentedAssignment;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ0\u0010\u001e\u001a\u00020\u00132\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u001a2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0001H\u0002J \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00072\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J&\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001a2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0015J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0015J\u0014\u0010/\u001a\u00020\u00152\f\u00100\u001a\b\u0012\u0004\u0012\u00020201J\u000e\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0013J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020'0\u001a2\u0006\u00106\u001a\u000207J\f\u00108\u001a\b\u0012\u0004\u0012\u00020'0\u001aJ\u0016\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "<init>", "()V", "rootFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "assignedLocalVariablesByDeclaration", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "variableAssignments", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "scopes", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "postponedLambdas", "", "", "reset", "", "isUnstableInCurrentScope", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "types", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "allAssignmentsPreserveType", "assignments", "getInfoForDeclaration", "symbol", "buildInfoForRoot", "root", "enterScope", "evaluatedInPlace", "enterFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "exitFunction", "enterClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "exitClass", "enterFunctionCall", "lambdaArgs", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "exitFunctionCall", "callCompleted", "enterLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "exitLoop", "visitAssignment", "property", "type", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n1755#2,2:530\n1757#2:535\n1734#2,3:536\n1734#2,3:539\n1611#2,9:543\n1863#2:552\n1864#2:554\n1620#2:555\n1293#2,4:556\n1293#2,4:560\n295#2,2:564\n188#3,3:532\n1#4:542\n1#4:553\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n*L\n64#1:530,2\n64#1:535\n78#1:536,3\n79#1:539,3\n181#1:543,9\n181#1:552\n181#1:554\n181#1:555\n181#1:556,4\n202#1:560,4\n227#1:564,2\n68#1:532,3\n181#1:553\n*E\n"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunctionSymbol<?> rootFunction;
    @Nullable
    private Map<Object, Companion.Fork> assignedLocalVariablesByDeclaration;
    @Nullable
    private Map<FirProperty, ? extends List<Companion.Assignment>> variableAssignments;
    @NotNull
    private final Stack<Pair<Companion.Fork, Companion.VariableAssignments>> scopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.Fork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByDeclaration = null;
        this.variableAssignments = null;
        this.postponedLambdas.reset();
        this.scopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnstableInCurrentScope(@NotNull FirDeclaration declaration, @Nullable Set<? extends ConeKotlinType> types, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        if (this.assignedLocalVariablesByDeclaration == null) {
            return false;
        }
        if (!(declaration instanceof FirProperty)) return false;
        if (!((FirProperty)declaration).isLocal()) return false;
        if (!((FirProperty)declaration).isVar()) {
            return false;
        }
        if (!this.allAssignmentsPreserveType(((Companion.VariableAssignments)this.scopes.top().getSecond()).get((FirProperty)declaration), types, session)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.Fork lambda2 = (Companion.Fork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda2.getAssignedInside().contains((FirProperty)declaration)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean allAssignmentsPreserveType(Set<Companion.Assignment> assignments, Set<? extends ConeKotlinType> types, FirSession session) {
        boolean bl;
        boolean bl2;
        Collection collection = assignments;
        if (collection == null) return true;
        if (collection.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (types == null) return false;
        Iterable $this$all$iv = assignments;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl4 = false;
                if (it.getType() == null) return false;
                boolean bl5 = true;
                if (bl5) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = assignments;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            Companion.Assignment assignment2 = (Companion.Assignment)element$iv;
            boolean bl6 = false;
            Iterable $this$all$iv2 = types;
            boolean $i$f$all2 = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                bl = true;
                continue;
            }
            for (Object element$iv2 : $this$all$iv2) {
                ConeKotlinType it = (ConeKotlinType)element$iv2;
                boolean bl7 = false;
                TypeCheckerProviderContext typeCheckerProviderContext = TypeComponentsKt.getTypeContext(session);
                ConeKotlinType coneKotlinType = assignment2.getType();
                Intrinsics.checkNotNull((Object)coneKotlinType);
                if (AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)typeCheckerProviderContext, (KotlinTypeMarker)coneKotlinType, (KotlinTypeMarker)it, (boolean)false, (int)8, null)) continue;
                return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final Companion.Fork getInfoForDeclaration(Object symbol) {
        FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
        if (firFunctionSymbol == null) {
            return null;
        }
        FirFunctionSymbol<?> root = firFunctionSymbol;
        if (Intrinsics.areEqual(root, (Object)symbol)) {
            return null;
        }
        Map<Object, Companion.Fork> cachedMap = this.buildInfoForRoot(root);
        return cachedMap.get(symbol);
    }

    private final Map<Object, Companion.Fork> buildInfoForRoot(FirFunctionSymbol<?> root) {
        Map<Object, Companion.Fork> map = this.assignedLocalVariablesByDeclaration;
        if (map != null) {
            Map<Object, Companion.Fork> it = map;
            boolean bl = false;
            return it;
        }
        Companion.MiniCfgBuilder.MiniCfgData data = new Companion.MiniCfgBuilder.MiniCfgData();
        new Companion.MiniCfgBuilder().visitElement((FirElement)root.getFir(), data);
        this.assignedLocalVariablesByDeclaration = data.getForks();
        this.variableAssignments = data.getAssignments();
        return data.getForks();
    }

    private final Pair<Companion.Fork, Companion.VariableAssignments> enterScope(Object symbol, boolean evaluatedInPlace) {
        Companion.Fork currentInfo = this.getInfoForDeclaration(symbol);
        Companion.VariableAssignments prohibitInThisScope = ((Companion.VariableAssignments)this.scopes.top().getSecond()).copy();
        this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to((Object)currentInfo, (Object)prohibitInThisScope));
        if (!evaluatedInPlace) {
            for (Pair<Companion.Fork, Companion.VariableAssignments> pair : this.scopes.all()) {
                Companion.Fork outerInfo = (Companion.Fork)pair.component1();
                Companion.VariableAssignments prohibitInOuterScope = (Companion.VariableAssignments)pair.component2();
                Companion.Fork fork = currentInfo;
                prohibitInOuterScope.merge(fork != null ? fork.getAssignedInside() : null);
                Companion.Fork fork2 = outerInfo;
                prohibitInThisScope.merge(fork2 != null ? fork2.getAssignedLater() : null);
            }
        }
        return this.scopes.top();
    }

    @NotNull
    public final Set<FirPropertySymbol> enterFunction(@NotNull FirFunction function) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.rootFunction == null) {
            this.rootFunction = function.getSymbol();
            this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to(null, (Object)new Companion.VariableAssignments()));
            return SetsKt.emptySet();
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(function.getSymbol(), function instanceof FirAnonymousFunction && EventOccurrencesRangeKt.isInPlace((EventOccurrencesRange)((FirAnonymousFunction)function).getInvocationKind()));
        Companion.Fork info2 = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        for (Map<Companion.Fork, Boolean> concurrentLambdas : this.postponedLambdas.all()) {
            for (Map.Entry<Companion.Fork, Boolean> entry : concurrentLambdas.entrySet()) {
                Companion.Fork otherLambda = entry.getKey();
                boolean dataFlowOnly = entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual((Object)otherLambda, (Object)info2)) continue;
                prohibitSmartCasts.merge(otherLambda.getAssignedInside());
            }
        }
        Object object = (Companion.Fork)this.scopes.top().getFirst();
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void exitFunction() {
        this.scopes.pop();
        if (StackKt.isEmpty(this.scopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByDeclaration = null;
            this.variableAssignments = null;
        }
    }

    public final void enterClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.rootFunction == null) {
            return;
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(klass.getSymbol(), klass instanceof FirAnonymousObject);
        Companion.Fork info2 = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        if (klass instanceof FirAnonymousObject && info2 != null) {
            prohibitSmartCasts.merge(info2.getAssignedInside());
        }
    }

    public final void exitClass() {
        if (this.rootFunction == null) {
            return;
        }
        this.scopes.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.Fork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.Fork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.Fork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForDeclaration(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.Fork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.Fork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.Fork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.Fork, Boolean> map = StackKt.topOrNull(this.postponedLambdas);
            if (map == null) {
                return;
            }
            Map<Companion.Fork, Boolean> destination$iv = map;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.Fork fork = (Companion.Fork)element$iv;
                Object t = element$iv;
                Map<Companion.Fork, Boolean> map2 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map2.put((Companion.Fork)t, bl2);
            }
        }
    }

    @NotNull
    public final Set<FirPropertySymbol> enterLoop(@NotNull FirLoop loop) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info2 = (Companion.Fork)this.enterScope(loop, true).component1();
        Object object = info2;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<FirPropertySymbol> exitLoop() {
        Set set;
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info2 = (Companion.Fork)this.scopes.pop().component1();
        Object object = info2;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void visitAssignment(@NotNull FirProperty property, @NotNull ConeKotlinType type2) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
            if (firFunctionSymbol == null) {
                return;
            }
            this.buildInfoForRoot(firFunctionSymbol);
            Map<FirProperty, ? extends List<Companion.Assignment>> map = this.variableAssignments;
            if (map == null || (map = map.get(property)) == null) {
                return;
            }
            Map<FirProperty, ? extends List<Companion.Assignment>> assignments = map;
            Iterable $this$firstOrNull$iv = (Iterable)((Object)assignments);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl = false;
                if (!(it.getType() == null)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Companion.Assignment assignment2 = v2;
        if (assignment2 == null) {
            return;
        }
        Companion.Assignment assignment3 = assignment2;
        assignment3.setType(type2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "<init>", "()V", "Fork", "Assignment", "VariableAssignments", "MiniFlow", "MiniCfgBuilder", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "", "operatorAssignment", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "(ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getOperatorAssignment", "()Z", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "resolve"})
        private static final class Assignment {
            private final boolean operatorAssignment;
            @Nullable
            private ConeKotlinType type;

            public Assignment(boolean operatorAssignment, @Nullable ConeKotlinType type2) {
                this.operatorAssignment = operatorAssignment;
                this.type = type2;
            }

            public /* synthetic */ Assignment(boolean bl, ConeKotlinType coneKotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    coneKotlinType = null;
                }
                this(bl, coneKotlinType);
            }

            public final boolean getOperatorAssignment() {
                return this.operatorAssignment;
            }

            @Nullable
            public final ConeKotlinType getType() {
                return this.type;
            }

            public final void setType(@Nullable ConeKotlinType coneKotlinType) {
                this.type = coneKotlinType;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "assignedInside", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)V", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedInside", "resolve"})
        private static final class Fork {
            @NotNull
            private final VariableAssignments assignedLater;
            @NotNull
            private final VariableAssignments assignedInside;

            public Fork(@NotNull VariableAssignments assignedLater, @NotNull VariableAssignments assignedInside) {
                Intrinsics.checkNotNullParameter((Object)assignedLater, (String)"assignedLater");
                Intrinsics.checkNotNullParameter((Object)assignedInside, (String)"assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final VariableAssignments getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\"0#H\u0002J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u0002052\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001c\u0010<\u001a\u00020\u0002*\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u001c\u0010<\u001a\u00020\u0002*\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u0010A\u001a\u00020BH\u0002J\u0014\u0010C\u001a\u00020\u0002*\u00020\"2\u0006\u0010D\u001a\u00020\u000bH\u0002\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "<init>", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitElementWithLexicalScope", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitLocalDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "join", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitAugmentedAssignment", "augmentedAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirAugmentedAssignment;", "recordAssignment", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "operatorAssignment", "", "assignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "recordAssignments", "properties", "MiniCfgData", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,529:1\n1454#2,5:530\n1628#2,3:536\n1628#2,3:539\n1863#2,2:542\n3193#2,10:544\n1863#2,2:554\n1863#2,2:556\n543#2,6:558\n1863#2,2:571\n1863#2,2:573\n1#3:535\n381#4,7:564\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n*L\n380#1:530,5\n412#1:536,3\n423#1:539,3\n461#1:542,2\n465#1:544,10\n466#1:554,2\n467#1:556,2\n503#1:558,6\n512#1:571,2\n517#1:573,2\n506#1:564,7\n*E\n"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                element.acceptChildren(this, data);
            }

            /*
             * WARNING - void declaration
             */
            private final VariableAssignments visitElementWithLexicalScope(FirElement element, MiniCfgData data) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Object object = (Iterable)data.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data.setFlow(flow);
                element.acceptChildren(this, data);
                Object $this$visitElementWithLexicalScope_u24lambda_u241 = object = flow.getAssignedLater();
                boolean bl = false;
                ((VariableAssignments)$this$visitElementWithLexicalScope_u24lambda_u241).retain(freeVariables);
                return object;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(anonymousFunction, data);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(simpleFunction, data);
            }

            @Override
            public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(regularClass, data);
            }

            @Override
            public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(anonymousObject, data);
            }

            private final void visitLocalDeclaration(FirDeclaration declaration, MiniCfgData data) {
                MiniFlow flow = data.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(declaration, data);
                this.recordAssignments(flow, assignedInside);
                data.setFlow(flow.fork());
                data.getForks().put(declaration.getSymbol(), new Fork(data.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data);
                }
                MiniFlow flow = data.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf((Object[])object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data.setFlow(flow);
                    it.accept(this, data);
                    var13_13.add(data.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    tryExpression.getTryBlock().accept(this, data);
                    MiniFlow flow = data.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf((Object[])object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data.setFlow(flow);
                        it.accept(this, data);
                        var13_13.add(data.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniFlow entry = data.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(loop, data);
                this.recordAssignments(entry, assignedInside);
                this.recordAssignments(data.getFlow(), assignedInside);
                data.setFlow(entry.fork());
                data.getForks().put(loop, new Fork(data.getFlow().getAssignedLater(), assignedInside));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLoop((FirLoop)whileLoop, data);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLoop((FirLoop)doWhileLoop, data);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = it instanceof FirAnonymousFunctionExpression ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl6 = false;
                    it.accept(visitor2, data);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                this.visitElement((FirElement)block, data);
                data.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)property, data);
                if (property.isLocal()) {
                    ((Map)data.getVariableDeclarations().last()).put(property.getName(), property);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    this.visitElement((FirElement)variableAssignment, data);
                    if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                        return;
                    }
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                    if (firReference == null) break block1;
                    FirReference it = firReference;
                    boolean bl = false;
                    KtSourceElement ktSourceElement = variableAssignment.getSource();
                    boolean operatorAssignment = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement;
                    this.recordAssignment(data, it, operatorAssignment);
                }
            }

            @Override
            public void visitAugmentedAssignment(@NotNull FirAugmentedAssignment augmentedAssignment, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)augmentedAssignment, (String)"augmentedAssignment");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)augmentedAssignment, data);
                FirExpression firExpression = augmentedAssignment.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data, lhs.getCalleeReference(), true);
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference2, boolean operatorAssignment) {
                List list2;
                Object object;
                Object v1;
                FirNamedReference name2;
                block5: {
                    FirNamedReference firNamedReference = reference2 instanceof FirNamedReference ? (FirNamedReference)reference2 : null;
                    if (firNamedReference == null || (firNamedReference = firNamedReference.getName()) == null) {
                        return;
                    }
                    name2 = firNamedReference;
                    List $this$lastOrNull$iv = (List)$this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name2)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name2)) == null) {
                    return;
                }
                Object property = object;
                Assignment assignment2 = new Assignment(operatorAssignment, null, 2, null);
                Map<FirProperty, List<Assignment>> $this$getOrPut$iv = $this$recordAssignment.getAssignments();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((FirProperty)property, answer$iv);
                    list2 = answer$iv;
                } else {
                    list2 = value$iv;
                }
                list2.add((Assignment)assignment2);
                this.recordAssignment($this$recordAssignment.getFlow(), (FirProperty)property, assignment2);
            }

            private final void recordAssignment(MiniFlow $this$recordAssignment, FirProperty property, Assignment assignment2) {
                if (!$this$recordAssignment.getAssignedLater().add(property, assignment2)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignment.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignment(it, property, assignment2);
                }
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, VariableAssignments properties) {
                if (!$this$recordAssignments.getAssignedLater().merge(properties)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties);
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "<init>", "()V", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "assignments", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "getAssignments", "()Ljava/util/Map;", "forks", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "getForks", "resolve"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                @NotNull
                private final Map<FirProperty, List<Assignment>> assignments = new LinkedHashMap();
                @NotNull
                private final Map<Object, Fork> forks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter((Object)miniFlow, (String)"<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirProperty, List<Assignment>> getAssignments() {
                    return this.assignments;
                }

                @NotNull
                public final Map<Object, Fork> getForks() {
                    return this.forks;
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "<init>", "(Ljava/util/Set;)V", "getParents", "()Ljava/util/Set;", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final VariableAssignments assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents) {
                Intrinsics.checkNotNullParameter(parents, (String)"parents");
                this.parents = parents;
                this.assignedLater = new VariableAssignments();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "<init>", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0000J\u0010\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "", "<init>", "()V", "assignments", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "get", "", "property", "contains", "", "add", "assignment", "copy", "merge", "other", "retain", "", "properties", "getAssignedProperties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,529:1\n381#2,7:530\n381#2,7:537\n774#3:544\n865#3:545\n1755#3,3:546\n866#3:549\n1628#3,3:550\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n*L\n331#1:530,7\n345#1:537,7\n357#1:544\n357#1:545\n357#1:546,3\n357#1:549\n358#1:550,3\n*E\n"})
        private static final class VariableAssignments {
            @NotNull
            private final Map<FirProperty, Set<Assignment>> assignments = new LinkedHashMap();

            @Nullable
            public final Set<Assignment> get(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return this.assignments.get(property);
            }

            public final boolean contains(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return this.assignments.containsKey(property);
            }

            public final boolean add(@NotNull FirProperty property, @NotNull Assignment assignment2) {
                Set set;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)assignment2, (String)"assignment");
                Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(property, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                return set.add((Assignment)assignment2);
            }

            @NotNull
            public final VariableAssignments copy() {
                VariableAssignments copy = new VariableAssignments();
                copy.assignments.putAll(this.assignments);
                return copy;
            }

            public final boolean merge(@Nullable VariableAssignments other) {
                if (other == null || other.assignments.isEmpty()) {
                    return false;
                }
                boolean modified = false;
                for (Map.Entry<FirProperty, Set<Assignment>> entry : other.assignments.entrySet()) {
                    Set set;
                    FirProperty property = entry.getKey();
                    Set<Assignment> values2 = entry.getValue();
                    boolean bl = modified;
                    Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                    boolean $i$f$getOrPut = false;
                    Set value$iv = $this$getOrPut$iv.get(property);
                    if (value$iv == null) {
                        boolean bl2 = bl;
                        boolean bl3 = false;
                        Set set2 = new LinkedHashSet();
                        bl = bl2;
                        Set answer$iv = set2;
                        $this$getOrPut$iv.put(property, answer$iv);
                        set = answer$iv;
                    } else {
                        set = value$iv;
                    }
                    modified = bl | set.addAll((Collection<Assignment>)values2);
                }
                return modified;
            }

            public final void retain(@NotNull Set<? extends FirProperty> properties) {
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                this.assignments.keySet().retainAll((Collection)properties);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<FirPropertySymbol> getAssignedProperties() {
                void var2_3;
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.assignments.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block5: {
                        Map.Entry entry = (Map.Entry)element$iv$iv;
                        boolean bl2 = false;
                        Set v = (Set)entry.getValue();
                        Iterable $this$any$iv = v;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Assignment it = (Assignment)element$iv;
                                boolean bl3 = false;
                                if (!(!it.getOperatorAssignment())) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    Map.Entry entry = (Map.Entry)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    FirProperty k = (FirProperty)entry.getKey();
                    collection.add(k.getSymbol());
                }
                return (Set)var2_3;
            }
        }
    }
}

