/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.session.MetadataLibraryBasedSymbolProvider;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.metadata.KlibDeserializedContainerSource;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0002H\u0014J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u001fH\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R-\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001a0\u00128TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001b\u0010\u0015R!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0017\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/session/KlibBasedSymbolProvider;", "Lorg/jetbrains/kotlin/fir/session/MetadataLibraryBasedSymbolProvider;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "resolvedLibraries", "", "defaultDeserializationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "flexibleTypeFactory", "Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;)V", "moduleHeaders", "", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "getModuleHeaders", "()Ljava/util/Map;", "moduleHeaders$delegate", "Lkotlin/Lazy;", "fragmentNamesInLibraries", "", "", "getFragmentNamesInLibraries", "fragmentNamesInLibraries$delegate", "knownPackagesInLibraries", "", "Lorg/jetbrains/kotlin/name/FqName;", "getKnownPackagesInLibraries", "()Ljava/util/Set;", "knownPackagesInLibraries$delegate", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "library", "createDeserializedContainerSource", "Lorg/jetbrains/kotlin/library/metadata/KlibDeserializedContainerSource;", "resolvedLibrary", "packageFqName", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nKlibBasedSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibBasedSymbolProvider.kt\norg/jetbrains/kotlin/fir/session/KlibBasedSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,77:1\n1187#2,2:78\n1261#2,4:80\n381#3,7:84\n*S KotlinDebug\n*F\n+ 1 KlibBasedSymbolProvider.kt\norg/jetbrains/kotlin/fir/session/KlibBasedSymbolProvider\n*L\n34#1:78,2\n34#1:80,4\n41#1:84,7\n*E\n"})
public final class KlibBasedSymbolProvider
extends MetadataLibraryBasedSymbolProvider<KotlinLibrary> {
    @NotNull
    private final Collection<KotlinLibrary> resolvedLibraries;
    @NotNull
    private final Lazy moduleHeaders$delegate;
    @NotNull
    private final Lazy fragmentNamesInLibraries$delegate;
    @NotNull
    private final Lazy knownPackagesInLibraries$delegate;

    public KlibBasedSymbolProvider(@NotNull FirSession session, @NotNull ModuleDataProvider moduleDataProvider, @NotNull FirKotlinScopeProvider kotlinScopeProvider2, @NotNull Collection<? extends KotlinLibrary> resolvedLibraries, @NotNull FirDeclarationOrigin defaultDeserializationOrigin, @NotNull FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleDataProvider, (String)"moduleDataProvider");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        Intrinsics.checkNotNullParameter(resolvedLibraries, (String)"resolvedLibraries");
        Intrinsics.checkNotNullParameter((Object)defaultDeserializationOrigin, (String)"defaultDeserializationOrigin");
        Intrinsics.checkNotNullParameter((Object)flexibleTypeFactory, (String)"flexibleTypeFactory");
        super(session, moduleDataProvider, kotlinScopeProvider2, flexibleTypeFactory, defaultDeserializationOrigin);
        this.resolvedLibraries = resolvedLibraries;
        this.moduleHeaders$delegate = LazyKt.lazy(() -> KlibBasedSymbolProvider.moduleHeaders_delegate$lambda$1(this));
        this.fragmentNamesInLibraries$delegate = LazyKt.lazy(() -> KlibBasedSymbolProvider.fragmentNamesInLibraries_delegate$lambda$4(this));
        this.knownPackagesInLibraries$delegate = LazyKt.lazy(() -> KlibBasedSymbolProvider.knownPackagesInLibraries_delegate$lambda$6(this));
    }

    public /* synthetic */ KlibBasedSymbolProvider(FirSession firSession, ModuleDataProvider moduleDataProvider, FirKotlinScopeProvider firKotlinScopeProvider, Collection collection, FirDeclarationOrigin firDeclarationOrigin, FirTypeDeserializer.FlexibleTypeFactory flexibleTypeFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            firDeclarationOrigin = FirDeclarationOrigin.Library.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            flexibleTypeFactory = FirTypeDeserializer.FlexibleTypeFactory.Default.INSTANCE;
        }
        this(firSession, moduleDataProvider, firKotlinScopeProvider, collection, firDeclarationOrigin, flexibleTypeFactory);
    }

    private final Map<KotlinLibrary, KlibMetadataProtoBuf.Header> getModuleHeaders() {
        Lazy lazy = this.moduleHeaders$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    protected Map<String, List<KotlinLibrary>> getFragmentNamesInLibraries() {
        Lazy lazy = this.fragmentNamesInLibraries$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    protected Set<FqName> getKnownPackagesInLibraries() {
        Lazy lazy = this.knownPackagesInLibraries$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @Nullable
    protected FirModuleData moduleData(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Path libraryPath = Paths.get(library.getLibraryFile().getPath(), new String[0]);
        return this.getModuleDataProvider().getModuleData(libraryPath);
    }

    @NotNull
    protected KlibDeserializedContainerSource createDeserializedContainerSource(@NotNull KotlinLibrary resolvedLibrary, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)resolvedLibrary, (String)"resolvedLibrary");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        KlibMetadataProtoBuf.Header header = this.getModuleHeaders().get(resolvedLibrary);
        Intrinsics.checkNotNull((Object)header);
        return new KlibDeserializedContainerSource(resolvedLibrary, header, (DeserializationConfiguration)this.getDeserializationConfiguration(), packageFqName);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map moduleHeaders_delegate$lambda$1(KlibBasedSymbolProvider this$0) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this$0.resolvedLibraries;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)KlibMetadataDeserializationUtilsKt.parseModuleHeader((byte[])it.getModuleHeaderData()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Map fragmentNamesInLibraries_delegate$lambda$4(KlibBasedSymbolProvider this$0) {
        Map map;
        Map $this$fragmentNamesInLibraries_delegate_u24lambda_u244_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map.Entry<KotlinLibrary, KlibMetadataProtoBuf.Header> entry : this$0.getModuleHeaders().entrySet()) {
            KotlinLibrary library = entry.getKey();
            KlibMetadataProtoBuf.Header header = entry.getValue();
            for (String fragmentName : header.getPackageFragmentNameList()) {
                Object object;
                Map $this$getOrPut$iv = $this$fragmentNamesInLibraries_delegate_u24lambda_u244_u24lambda_u243;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(fragmentName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    SmartList answer$iv = new SmartList();
                    $this$getOrPut$iv.put(fragmentName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((SmartList)object).add((Object)library);
            }
        }
        return MapsKt.build((Map)map);
    }

    private static final Set knownPackagesInLibraries_delegate$lambda$6(KlibBasedSymbolProvider this$0) {
        Set set;
        Set $this$knownPackagesInLibraries_delegate_u24lambda_u246_u24lambda_u245 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterator<Map.Entry<KotlinLibrary, KlibMetadataProtoBuf.Header>> iterator2 = this$0.getModuleHeaders().entrySet().iterator();
        while (iterator2.hasNext()) {
            KlibMetadataProtoBuf.Header header = iterator2.next().getValue();
            for (String fragmentName : header.getPackageFragmentNameList()) {
                Intrinsics.checkNotNull((Object)fragmentName);
                FqName curPackage = new FqName(fragmentName);
                while (!curPackage.isRoot()) {
                    $this$knownPackagesInLibraries_delegate_u24lambda_u246_u24lambda_u245.add(curPackage);
                    curPackage = curPackage.parent();
                }
            }
        }
        return SetsKt.build((Set)set);
    }
}

