/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.lightClasses;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.LightClassInheritanceHelper;
import org.jetbrains.kotlin.asJava.classes.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolver;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/IdeLightClassInheritanceHelper;", "Lorg/jetbrains/kotlin/asJava/classes/LightClassInheritanceHelper;", "<init>", "()V", "isInheritor", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "lightClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "baseClass", "Lcom/intellij/psi/PsiClass;", "checkDeep", "", "isAmongEntries", "entries", "", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nIdeLightClassInheritanceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeLightClassInheritanceHelper.kt\norg/jetbrains/kotlin/idea/caches/lightClasses/IdeLightClassInheritanceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n2632#2,3:61\n*S KotlinDebug\n*F\n+ 1 IdeLightClassInheritanceHelper.kt\norg/jetbrains/kotlin/idea/caches/lightClasses/IdeLightClassInheritanceHelper\n*L\n34#1:61,3\n*E\n"})
public final class IdeLightClassInheritanceHelper
implements LightClassInheritanceHelper {
    @NotNull
    public ImpreciseResolveResult isInheritor(@NotNull KtLightClass lightClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        List entries;
        block12: {
            block13: {
                boolean bl;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)lightClass, (String)"lightClass");
                    Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
                    Project project = baseClass.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (DumbModeUtils.isInDumbMode(project)) {
                        return ImpreciseResolveResult.NO_MATCH;
                    }
                    if (lightClass.getManager().areElementsEquivalent((PsiElement)baseClass, (PsiElement)lightClass)) {
                        return ImpreciseResolveResult.NO_MATCH;
                    }
                    KtClassOrObject ktClassOrObject = (KtClassOrObject)lightClass.getKotlinOrigin();
                    if (ktClassOrObject == null) {
                        return ImpreciseResolveResult.UNSURE;
                    }
                    KtClassOrObject classOrObject = ktClassOrObject;
                    if (checkDeep && Intrinsics.areEqual((Object)baseClass.getQualifiedName(), (Object)"java.lang.Object")) {
                        return ImpreciseResolveResult.MATCH;
                    }
                    entries = classOrObject.getSuperTypeListEntries();
                    if (!Intrinsics.areEqual((Object)baseClass.getQualifiedName(), (Object)LightClassUtilsKt.defaultJavaAncestorQualifiedName((KtClassOrObject)classOrObject))) break block12;
                    if (checkDeep) break block13;
                    Iterable $this$none$iv = entries;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof KtSuperTypeCallEntry)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block12;
            }
            return ImpreciseResolveResult.MATCH;
        }
        ImpreciseResolveResult amongEntries = this.isAmongEntries(baseClass, entries);
        return !checkDeep ? amongEntries : (amongEntries == ImpreciseResolveResult.MATCH ? ImpreciseResolveResult.MATCH : ImpreciseResolveResult.UNSURE);
    }

    private final ImpreciseResolveResult isAmongEntries(PsiClass baseClass, List<? extends KtSuperTypeListEntry> entries) {
        PsiBasedClassResolver psiBasedResolver = PsiBasedClassResolver.Companion.getInstance(baseClass);
        block5: for (KtSuperTypeListEntry ktSuperTypeListEntry : entries) {
            KtUserType ktUserType = ktSuperTypeListEntry.getTypeAsUserType();
            if (ktUserType == null || (ktUserType = ktUserType.getReferenceExpression()) == null) continue;
            KtUserType reference2 = ktUserType;
            switch (WhenMappings.$EnumSwitchMapping$0[psiBasedResolver.canBeTargetReference((KtSimpleNameExpression)reference2).ordinal()]) {
                case 1: {
                    return ImpreciseResolveResult.MATCH;
                }
                case 2: {
                    continue block5;
                }
                case 3: {
                    return ImpreciseResolveResult.UNSURE;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return ImpreciseResolveResult.NO_MATCH;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImpreciseResolveResult.values().length];
            try {
                nArray[ImpreciseResolveResult.MATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImpreciseResolveResult.NO_MATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImpreciseResolveResult.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

