/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptySecondaryConstructorBodyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "isApplicable", "", "element", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "kotlin.code-insight.inspections.shared"})
public final class RemoveEmptySecondaryConstructorBodyInspection
extends AbstractApplicabilityBasedInspection<KtBlockExpression>
implements CleanupLocalInspectionTool {
    public RemoveEmptySecondaryConstructorBodyInspection() {
        super(KtBlockExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtBlockExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element.getParent() instanceof KtSecondaryConstructor)) {
            return false;
        }
        List list2 = element.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        if (!((Collection)list2).isEmpty()) {
            return false;
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null));
    }

    @Override
    public void applyTo(@NotNull KtBlockExpression element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        element.delete();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBlockExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"remove.empty.constructor.body", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"remove.empty.constructor.body", (Object[])new Object[0]);
    }
}

