/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocation;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.UtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016R\u00020\u0012\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0019R\u00020\u0012\u00a2\u0006\u0002\u0010\u001aJ\n\u0010\u001b\u001a\u00020\u0016*\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/ImportStrategyDetector;", "", "originalKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/project/Project;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "defaultImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "excludedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "detectImportStrategyForCallableSymbol", "Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "isFunctionalVariableCall", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;Z)Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "detectImportStrategyForClassifierSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol;)Lorg/jetbrains/kotlin/idea/completion/lookups/ImportStrategy;", "isAlreadyImported", "kotlin.completion.impl.k2"})
@ApiStatus.Internal
public final class ImportStrategyDetector {
    @NotNull
    private final PlatformDependentAnalyzerServices analyzerServices;
    @NotNull
    private final Set<ImportPath> defaultImports;
    @NotNull
    private final List<FqName> excludedImports;

    public ImportStrategyDetector(@NotNull KtFile originalKtFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)originalKtFile, (String)"originalKtFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.analyzerServices = PlatformAnalyzerServicesUtils.findAnalyzerServices(TargetPlatformDetectorUtils.getPlatform((KtElement)originalKtFile), project);
        this.defaultImports = CollectionsKt.toSet((Iterable)this.analyzerServices.getDefaultImports(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)originalKtFile), true));
        this.excludedImports = this.analyzerServices.getExcludedImports();
    }

    @NotNull
    public final ImportStrategy detectImportStrategyForCallableSymbol(@NotNull KaSession $context_receiver_0, @NotNull KaCallableSymbol symbol, boolean isFunctionalVariableCall) {
        boolean containingClassIsObject;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaSymbol kaSymbol = $context_receiver_0.getContainingSymbol($context_receiver_0.getFakeOverrideOriginal(symbol));
        Object object = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        boolean bl = object != null && (object = ((KaClassSymbol)object).getClassKind()) != null ? ((KaClassKind)((Object)object)).isObject() : (containingClassIsObject = false);
        if (symbol.getLocation() == KaSymbolLocation.CLASS && !containingClassIsObject) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        CallableId callableId = symbol.getCallableId();
        if (callableId == null || (callableId = callableId.asSingleFqName()) == null) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        CallableId callableId2 = callableId;
        return UtilsKt.isExtensionCall($context_receiver_0, symbol, isFunctionalVariableCall) ? (ImportStrategy)new ImportStrategy.AddImport((FqName)callableId2) : (ImportStrategy)new ImportStrategy.InsertFqNameAndShorten((FqName)callableId2);
    }

    public static /* synthetic */ ImportStrategy detectImportStrategyForCallableSymbol$default(ImportStrategyDetector importStrategyDetector, KaSession kaSession, KaCallableSymbol kaCallableSymbol, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return importStrategyDetector.detectImportStrategyForCallableSymbol(kaSession, kaCallableSymbol, bl);
    }

    @NotNull
    public final ImportStrategy detectImportStrategyForClassifierSymbol(@NotNull KaSession $context_receiver_0, @NotNull KaClassifierSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!(symbol instanceof KaClassLikeSymbol)) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        ClassId classId = ((KaClassLikeSymbol)symbol).getClassId();
        if (classId == null || (classId = classId.asSingleFqName()) == null) {
            return ImportStrategy.DoNothing.INSTANCE;
        }
        ClassId classId2 = classId;
        return new ImportStrategy.InsertFqNameAndShorten((FqName)classId2);
    }

    public final boolean isAlreadyImported(@NotNull FqName $this$isAlreadyImported) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlreadyImported, (String)"<this>");
        ImportPath importPath = new ImportPath($this$isAlreadyImported, false, null, 4, null);
        return FqNameUtilsKt.isImported(importPath, (Iterable<ImportPath>)this.defaultImports, (Iterable<FqName>)this.excludedImports);
    }
}

