/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.FileUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinUpdateNotificationListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/project/DumbService$DumbModeListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "exitDumbMode", "rootsChanged", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "editorNotifications", "Lcom/intellij/ui/EditorNotifications;", "getEditorNotifications", "()Lcom/intellij/ui/EditorNotifications;", "kotlin.project-configuration"})
public final class KotlinUpdateNotificationListener
implements ModuleRootListener,
DumbService.DumbModeListener,
BulkFileListener {
    @NotNull
    private final Project project;

    public KotlinUpdateNotificationListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            if (!FileUtils.isJavaFileType(virtualFile)) continue;
            this.getEditorNotifications().updateNotifications(((VFileMoveEvent)vFileEvent).getFile());
        }
    }

    public void exitDumbMode() {
        this.getEditorNotifications().updateAllNotifications();
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getEditorNotifications().updateAllNotifications();
    }

    private final EditorNotifications getEditorNotifications() {
        EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)editorNotifications, (String)"getInstance(...)");
        return editorNotifications;
    }
}

