/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000bR(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\b*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter;", "", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileType", "Ljava/nio/file/Path;", "getFileType", "(Ljava/nio/file/Path;)Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "clearCaches", "", "classpathEntryToVfs", "path", "FileType", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptConfigurationManager.kt\norg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,207:1\n73#2:208\n*S KotlinDebug\n*F\n+ 1 ScriptConfigurationManager.kt\norg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter\n*L\n179#1:208\n*E\n"})
public final class ClasspathToVfsConverter {
    @NotNull
    public static final ClasspathToVfsConverter INSTANCE = new ClasspathToVfsConverter();
    @NotNull
    private static final ConcurrentHashMap<String, Pair<FileType, VirtualFile>> cache = new ConcurrentHashMap();

    private ClasspathToVfsConverter() {
    }

    private final FileType getFileType(Path $this$fileType) {
        FileType fileType;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists($this$fileType, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            fileType = FileType.NOT_EXISTS;
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory($this$fileType, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                fileType = FileType.DIRECTORY;
            } else {
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                fileType = Files.isRegularFile($this$fileType, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? FileType.REGULAR_FILE : FileType.UNKNOWN;
            }
        }
        return fileType;
    }

    public final void clearCaches() {
        cache.clear();
    }

    @Nullable
    public final VirtualFile classpathEntryToVfs(@NotNull Path path2) {
        VirtualFile oldVFile;
        block4: {
            FileType newType;
            String key;
            block3: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                key = ((Object)path2).toString();
                newType = this.getFileType(path2);
                Pair pair = cache.computeIfAbsent(key, arg_0 -> ClasspathToVfsConverter.classpathEntryToVfs$lambda$0((Function1)new Function1<String, Pair<? extends FileType, ? extends VirtualFile>>(newType){
                    final /* synthetic */ FileType $newType;
                    {
                        this.$newType = $newType;
                        super(1, Intrinsics.Kotlin.class, "compute", "classpathEntryToVfs$compute(Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;Ljava/lang/String;)Lkotlin/Pair;", 0);
                    }

                    public final Pair<FileType, VirtualFile> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ClasspathToVfsConverter.access$classpathEntryToVfs$compute(this.$newType, p0);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"computeIfAbsent(...)");
                Pair pair2 = pair;
                FileType oldType = (FileType)((Object)pair2.component1());
                oldVFile = (VirtualFile)pair2.component2();
                if (oldType != newType) break block3;
                VirtualFile virtualFile = oldVFile;
                boolean bl = virtualFile != null ? !virtualFile.isValid() : false;
                if (!bl && (oldVFile != null || oldType != FileType.DIRECTORY && oldType != FileType.REGULAR_FILE)) break block4;
            }
            Pair pair = cache.compute(key, (arg_0, arg_1) -> ClasspathToVfsConverter.classpathEntryToVfs$lambda$2((arg_0, arg_1) -> ClasspathToVfsConverter.classpathEntryToVfs$lambda$1(newType, arg_0, arg_1), arg_0, arg_1));
            return pair != null ? (VirtualFile)pair.getSecond() : null;
        }
        return oldVFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final VirtualFile classpathEntryToVfs$findLocalFileByPath(VirtualFileSystem $this$classpathEntryToVfs_u24findLocalFileByPath, String filePath) {
        VirtualFile virtualFile;
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                virtualFile = $this$classpathEntryToVfs_u24findLocalFileByPath.refreshAndFindFileByPath(filePath);
                return virtualFile;
            }
        }
        virtualFile = $this$classpathEntryToVfs_u24findLocalFileByPath.findFileByPath(filePath);
        return virtualFile;
    }

    private static final Pair<FileType, VirtualFile> classpathEntryToVfs$compute(FileType newType, String filePath) {
        return TuplesKt.to((Object)((Object)newType), switch (WhenMappings.$EnumSwitchMapping$0[newType.ordinal()]) {
            case 1, 2 -> null;
            case 3 -> {
                VirtualFileSystem v1 = StandardFileSystems.local();
                if (v1 != null) {
                    yield ClasspathToVfsConverter.classpathEntryToVfs$findLocalFileByPath(v1, filePath);
                }
                yield null;
            }
            case 4 -> {
                VirtualFileSystem v2 = StandardFileSystems.jar();
                if (v2 != null) {
                    yield ClasspathToVfsConverter.classpathEntryToVfs$findLocalFileByPath(v2, filePath + "!/");
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final Pair classpathEntryToVfs$lambda$0(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final Pair classpathEntryToVfs$lambda$1(FileType $newType, String k, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        return ClasspathToVfsConverter.classpathEntryToVfs$compute($newType, k);
    }

    private static final Pair classpathEntryToVfs$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Pair access$classpathEntryToVfs$compute(FileType newType, String filePath) {
        return ClasspathToVfsConverter.classpathEntryToVfs$compute(newType, filePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_EXISTS", "DIRECTORY", "REGULAR_FILE", "UNKNOWN", "kotlin.base.scripting"})
    private static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType NOT_EXISTS = new FileType();
        public static final /* enum */ FileType DIRECTORY = new FileType();
        public static final /* enum */ FileType REGULAR_FILE = new FileType();
        public static final /* enum */ FileType UNKNOWN = new FileType();
        private static final /* synthetic */ FileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value) {
            return Enum.valueOf(FileType.class, value);
        }

        @NotNull
        public static EnumEntries<FileType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileTypeArray = new FileType[]{FileType.NOT_EXISTS, FileType.DIRECTORY, FileType.REGULAR_FILE, FileType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileType.values().length];
            try {
                nArray[FileType.NOT_EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.DIRECTORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.REGULAR_FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

