/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.core.script.ClasspathToVfsConverter;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\t\u001a\u00020\nH&J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0004\u001a\u00020\rH&J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH&J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fH&J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependencyAware;", "getConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasConfiguration", "", "isConfigurationLoadingInProgress", "updateScriptDefinitionReferences", "", "getScriptDependenciesSourceFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllScriptsSdkDependenciesClassFiles", "getAllScriptSdkDependenciesSources", "getScriptDependingOn", "dependencies", "", "Companion", "kotlin.base.scripting"})
public interface ScriptConfigurationManager
extends ScriptDependencyAware {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager$Companion.$$INSTANCE;

    @Nullable
    public ScriptCompilationConfigurationWrapper getConfiguration(@NotNull KtFile var1);

    public boolean hasConfiguration(@NotNull KtFile var1);

    public boolean isConfigurationLoadingInProgress(@NotNull KtFile var1);

    public void updateScriptDefinitionReferences();

    @NotNull
    public Collection<VirtualFile> getScriptDependenciesSourceFiles(@NotNull VirtualFile var1);

    @NotNull
    public Collection<VirtualFile> getAllScriptsSdkDependenciesClassFiles();

    @NotNull
    public Collection<VirtualFile> getAllScriptSdkDependenciesSources();

    @Nullable
    public VirtualFile getScriptDependingOn(@NotNull Collection<String> var1);

    @JvmStatic
    @NotNull
    public static ScriptConfigurationManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static CompositeScriptConfigurationManager compositeScriptConfigurationManager(@NotNull Project project) {
        return Companion.compositeScriptConfigurationManager(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager$Companion;", "", "<init>", "()V", "getServiceIfCreated", "Lorg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "compositeScriptConfigurationManager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "toVfsRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "Ljava/io/File;", "updateScriptDependenciesSynchronously", "", "file", "Lcom/intellij/psi/PsiFile;", "defaultScriptingSupport", "Lorg/jetbrains/kotlin/idea/core/script/configuration/DefaultScriptingSupport;", "clearCaches", "kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptConfigurationManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n59#2:208\n31#2,2:209\n122#3:211\n1611#4,9:212\n1863#4:221\n1864#4:223\n1620#4:224\n1#5:222\n*S KotlinDebug\n*F\n+ 1 ScriptConfigurationManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptConfigurationManager$Companion\n*L\n102#1:208\n105#1:209,2\n109#1:211\n111#1:212,9\n111#1:221\n111#1:223\n111#1:224\n111#1:222\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final ScriptConfigurationManager getServiceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (ScriptConfigurationManager)$this$serviceIfCreated$iv.getServiceIfCreated(ScriptConfigurationManager.class);
        }

        @JvmStatic
        @NotNull
        public final ScriptConfigurationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ScriptConfigurationManager> serviceClass$iv = ScriptConfigurationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ScriptConfigurationManager)object;
        }

        @JvmStatic
        @NotNull
        public final CompositeScriptConfigurationManager compositeScriptConfigurationManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ScriptConfigurationManager $this$cast$iv = this.getInstance(project);
            boolean $i$f$cast = false;
            ScriptConfigurationManager scriptConfigurationManager = $this$cast$iv;
            if (scriptConfigurationManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager");
            }
            return (CompositeScriptConfigurationManager)scriptConfigurationManager;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> toVfsRoots(@NotNull Iterable<? extends File> roots) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Iterable<? extends File> $this$mapNotNull$iv = roots;
            boolean $i$f$mapNotNull = false;
            Iterable<? extends File> iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                Path path2 = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                if (ClasspathToVfsConverter.INSTANCE.classpathEntryToVfs(path2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @TestOnly
        public final void updateScriptDependenciesSynchronously(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DefaultScriptingSupport defaultScriptingSupport = this.defaultScriptingSupport(project);
            if (file instanceof KtFile) {
                defaultScriptingSupport.updateScriptDependenciesSynchronously$kotlin_base_scripting(file);
            } else {
                Project project2 = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Project project3 = project2;
                InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project3);
                new PsiRecursiveElementVisitor(injectedLanguageManager, defaultScriptingSupport){
                    final /* synthetic */ InjectedLanguageManager $injectedLanguageManager;
                    final /* synthetic */ DefaultScriptingSupport $defaultScriptingSupport;
                    {
                        this.$injectedLanguageManager = $injectedLanguageManager;
                        this.$defaultScriptingSupport = $defaultScriptingSupport;
                    }

                    public void visitElement(PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        this.$injectedLanguageManager.enumerate(element, (arg_0, arg_1) -> updateScriptDependenciesSynchronously.1.visitElement$lambda$0(this.$defaultScriptingSupport, arg_0, arg_1));
                        super.visitElement(element);
                    }

                    private static final void visitElement$lambda$0(DefaultScriptingSupport $defaultScriptingSupport, PsiFile psi, List list2) {
                        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
                        Intrinsics.checkNotNullParameter((Object)list2, (String)"<unused var>");
                        $defaultScriptingSupport.updateScriptDependenciesSynchronously$kotlin_base_scripting(psi);
                    }
                }.visitFile(file);
            }
        }

        private final DefaultScriptingSupport defaultScriptingSupport(Project project) {
            return this.compositeScriptConfigurationManager(project).getDefault();
        }

        @TestOnly
        public final void clearCaches(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ClasspathToVfsConverter.INSTANCE.clearCaches();
            this.defaultScriptingSupport(project).updateScriptDefinitionsReferences();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

