/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter;", "Lcom/intellij/debugger/engine/ExtraSteppingFilter;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "getStepRequestDepth", "", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinExtraSteppingFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtraSteppingFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1557#2:54\n1628#2,3:55\n*S KotlinDebug\n*F\n+ 1 KotlinExtraSteppingFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter\n*L\n34#1:54\n34#1:55,3\n*E\n"})
public final class KotlinExtraSteppingFilter
implements ExtraSteppingFilter {
    public boolean isApplicable(@Nullable SuspendContext context2) {
        SuspendContext suspendContext = context2;
        if (suspendContext == null || (suspendContext = suspendContext.getDebugProcess()) == null) {
            return false;
        }
        SuspendContext debugProcess = suspendContext;
        Object object = context2.getFrameProxy();
        if (object == null || (object = SafeUtilKt.safeLocation(object)) == null) {
            return false;
        }
        Object location = object;
        if (!DebuggerUtil.isInKotlinSources((Location)location)) {
            return false;
        }
        return (Boolean)ActionsKt.runReadAction(() -> KotlinExtraSteppingFilter.isApplicable$lambda$1((DebugProcess)debugProcess, (Location)location));
    }

    public int getStepRequestDepth(@Nullable SuspendContext context2) {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isApplicable$lambda$1(DebugProcess $debugProcess, Location $location) {
        KotlinPositionManager positionManager = new KotlinPositionManager($debugProcess);
        SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition((PositionManager)positionManager, $location);
        if (sourcePosition == null) {
            return false;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        DebuggerSettings settings2 = DebuggerSettings.getInstance();
        if (settings2.TRACING_FILTERS_ENABLED) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = new ClassNameProvider(null, 1, null).getCandidates(sourcePosition2);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JvmNameUtilsKt.internalNameToFqn((String)it));
            }
            List classNames = (List)destination$iv$iv;
            for (String className : classNames) {
                iterator2 = ArrayIteratorKt.iterator((Object[])settings2.getSteppingFilters());
                while (iterator2.hasNext()) {
                    ClassFilter filter2 = (ClassFilter)iterator2.next();
                    if (!filter2.isEnabled() || !filter2.matches(className)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

