/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.diagnostic;

import com.intellij.diagnostic.KotlinCompilerCrash;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\nH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"BUILD_ERROR_REPORTS_FOLDER", "", "BUILD_ERROR_REPORTS_FILE_PREFIX", "ERROR_MESSAGE_PREFIX", "KOTLIN_VERSION", "readErrorFileAndProcessEvent", "", "file", "Ljava/io/File;", "process", "Lkotlin/Function2;", "Lcom/intellij/diagnostic/KotlinCompilerCrash;", "", "kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleBuildErrorsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleBuildErrorsChecker.kt\norg/jetbrains/kotlin/idea/gradle/diagnostic/KotlinGradleBuildErrorsCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1863#2,2:86\n1863#2,2:88\n*S KotlinDebug\n*F\n+ 1 KotlinGradleBuildErrorsChecker.kt\norg/jetbrains/kotlin/idea/gradle/diagnostic/KotlinGradleBuildErrorsCheckerKt\n*L\n40#1:86,2\n32#1:88,2\n*E\n"})
public final class KotlinGradleBuildErrorsCheckerKt {
    @NotNull
    public static final String BUILD_ERROR_REPORTS_FOLDER = ".gradle/kotlin/errors";
    @NotNull
    public static final String BUILD_ERROR_REPORTS_FILE_PREFIX = "errors-";
    @NotNull
    private static final String ERROR_MESSAGE_PREFIX = "error message: ";
    @NotNull
    private static final String KOTLIN_VERSION = "kotlin version: ";

    @ApiStatus.Internal
    public static final void readErrorFileAndProcessEvent(@NotNull File file, @NotNull Function2<? super KotlinCompilerCrash, ? super String, ? extends Object> process2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(process2, (String)"process");
        Ref.ObjectRef message2 = new Ref.ObjectRef();
        Ref.ObjectRef stackTrace = new Ref.ObjectRef();
        stackTrace.element = new ArrayList();
        String string = FilesKt.getNameWithoutExtension((File)file).substring(7);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String timeInMillis = string;
        Ref.ObjectRef kotlinVersion = new Ref.ObjectRef();
        kotlinVersion.element = "Unknown";
        Iterable $this$forEach$iv = TextStreamsKt.readLines((Reader)new FileReader(file));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String str = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)str, (String)KOTLIN_VERSION, (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(16), (String)"substring(...)");
                kotlinVersion.element = kotlinVersion.element;
                continue;
            }
            if (StringsKt.startsWith$default((String)str, (String)ERROR_MESSAGE_PREFIX, (boolean)false, (int)2, null)) {
                KotlinGradleBuildErrorsCheckerKt.readErrorFileAndProcessEvent$crashException((Ref.ObjectRef<String>)message2, (Ref.ObjectRef<ArrayList<String>>)stackTrace, timeInMillis, (Ref.ObjectRef<String>)kotlinVersion, process2);
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(15), (String)"substring(...)");
                message2.element = message2.element;
                continue;
            }
            ((ArrayList)stackTrace.element).add(str);
        }
        KotlinGradleBuildErrorsCheckerKt.readErrorFileAndProcessEvent$crashException((Ref.ObjectRef<String>)message2, (Ref.ObjectRef<ArrayList<String>>)stackTrace, timeInMillis, (Ref.ObjectRef<String>)kotlinVersion, process2);
    }

    private static final void readErrorFileAndProcessEvent$crashException(Ref.ObjectRef<String> message2, Ref.ObjectRef<ArrayList<String>> stackTrace, String timeInMillis, Ref.ObjectRef<String> kotlinVersion, Function2<? super KotlinCompilerCrash, ? super String, ? extends Object> $process) {
        String string = (String)message2.element;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            String logMessage = it + ": " + timeInMillis;
            Iterable $this$forEach$iv = CompilerInternalError.Companion.parseStack((List)stackTrace.element);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable internalError = (Throwable)element$iv;
                boolean bl2 = false;
                KotlinCompilerCrash crashException = new KotlinCompilerCrash(logMessage, internalError, (String)kotlinVersion.element);
                String string3 = ((ArrayList)stackTrace.element).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                $process.invoke((Object)crashException, (Object)string3);
            }
        }
        message2.element = null;
        stackTrace.element = new ArrayList();
    }
}

