/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinSupportAvailability;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinDefaultHighlightingSettingsProviderKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptConfigurationsProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinDefaultHighlightingSettingsProvider;", "Lcom/intellij/codeInsight/daemon/impl/analysis/DefaultHighlightingSettingProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getDefaultSetting", "Lcom/intellij/codeInsight/daemon/impl/analysis/FileHighlightingSetting;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.highlighting.shared"})
public final class KotlinDefaultHighlightingSettingsProvider
extends DefaultHighlightingSettingProvider
implements DumbAware {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public FileHighlightingSetting getDefaultSetting(@NotNull Project project, @NotNull VirtualFile file) {
        FileHighlightingSetting fileHighlightingSetting;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid()) {
            return null;
        }
        PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile(file, project);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 instanceof KtFile) {
            if (((KtFile)psiFile2).isScript()) {
                ScriptConfigurationsProvider scriptConfigurationsProvider = ScriptConfigurationsProvider.Companion.getInstance(project);
                if ((scriptConfigurationsProvider != null ? scriptConfigurationsProvider.getScriptConfigurationResult((KtFile)psiFile2) : null) == null) {
                    fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
                    return fileHighlightingSetting;
                }
            }
            if (((KtFile)psiFile2).isCompiled()) {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_INSPECTION;
                return fileHighlightingSetting;
            }
            if (!KotlinSupportAvailability.Companion.isSupported((KtElement)psiFile2)) {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
                return fileHighlightingSetting;
            }
            if (!SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, project, file)) return null;
            fileHighlightingSetting = FileHighlightingSetting.SKIP_INSPECTION;
            return fileHighlightingSetting;
        }
        if (!KotlinDefaultHighlightingSettingsProviderKt.isKotlinDecompiledFile(file)) return null;
        fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
        return fileHighlightingSetting;
    }
}

