/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KotlinLightMethodUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinGutterTooltipHelper;
import org.jetbrains.kotlin.idea.presentation.DeclarationByModuleRenderer;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a6\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H\u0000\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"isMethodWithDeclarationInOtherClass", "", "Lcom/intellij/psi/PsiMethod;", "getOverriddenDeclarations", "", "T", "mappingToJava", "", "Lcom/intellij/psi/PsiElement;", "classes", "Lcom/intellij/psi/PsiClass;", "getModuleSpecificSubclassedClassTooltip", "", "klass", "getOverriddenMethodTooltip", "method", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOverridenFunctionMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridenFunctionMarker.kt\norg/jetbrains/kotlin/idea/highlighter/markers/OverridenFunctionMarkerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n1#3:106\n*S KotlinDebug\n*F\n+ 1 OverridenFunctionMarker.kt\norg/jetbrains/kotlin/idea/highlighter/markers/OverridenFunctionMarkerKt\n*L\n93#1:103\n93#1:104,2\n*E\n"})
public final class OverridenFunctionMarkerKt {
    private static final boolean isMethodWithDeclarationInOtherClass(PsiMethod $this$isMethodWithDeclarationInOtherClass) {
        return $this$isMethodWithDeclarationInOtherClass instanceof KtLightMethod && KotlinLightMethodUtilsKt.isTraitFakeOverride((KtLightMethod)((KtLightMethod)$this$isMethodWithDeclarationInOtherClass));
    }

    @NotNull
    public static final <T> Set<T> getOverriddenDeclarations(@NotNull Map<PsiElement, T> mappingToJava, @NotNull Set<? extends PsiClass> classes) {
        Intrinsics.checkNotNullParameter(mappingToJava, (String)"mappingToJava");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        HashSet overridden = new HashSet();
        for (PsiClass psiClass : classes) {
            OverridersSearchKt.forEachDeclaredMemberOverride(psiClass, (Function2<? super PsiElement, ? super PsiElement, Boolean>)((Function2)(arg_0, arg_1) -> OverridenFunctionMarkerKt.getOverriddenDeclarations$lambda$3(mappingToJava, overridden, arg_0, arg_1)));
        }
        return overridden;
    }

    @Nullable
    public static final String getModuleSpecificSubclassedClassTooltip(@NotNull PsiClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5, (Collection)new HashSet());
        ClassInheritorsSearch.search((PsiClass)klass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        if (processor2.isOverflow()) {
            return klass.isInterface() ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"class.is.subclassed.too.many", (Object[])new Object[0]);
        }
        PsiElement[] psiElementArray = processor2.toArray((PsiElement[])PsiClass.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"toArray(...)");
        Object[] subclasses = (PsiClass[])psiElementArray;
        if (subclasses.length == 0) {
            PsiElementProcessor.CollectElementsWithLimit functionalImplementations = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new HashSet());
            FunctionalExpressionSearch.search((PsiClass)klass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)functionalImplementations));
            Collection collection = functionalImplementations.getCollection();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
            return !collection.isEmpty() ? KotlinBundle.message((String)"highlighter.text.has.functional.implementations", (Object[])new Object[0]) : null;
        }
        Comparator comparator = new DeclarationByModuleRenderer().getComparator();
        String start2 = KotlinBundle.message((String)(klass.isInterface() ? "tooltip.is.implemented.by" : "tooltip.is.subclassed.by"), (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)comparator);
        return KotlinGutterTooltipHelper.INSTANCE.buildTooltipText(ArraysKt.sortedWith((Object[])subclasses, (Comparator)comparator), start2, true, "GotoImplementation");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        OverridersSearchUtilsKt.forEachOverridingMethod$default(method, null, (Function1)new Function1<PsiMethod, Boolean>((Object)new PsiElementProcessorAdapter((PsiElementProcessor)processor2)){

            public final Boolean invoke(PsiMethod p0) {
                return ((PsiElementProcessorAdapter)this.receiver).process((Object)p0);
            }
        }, 1, null);
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return DaemonBundle.message((String)(isAbstract ? "method.is.implemented.too.many" : "method.is.overridden.too.many"), (Object[])new Object[0]);
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Collection collection = processor2.getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)comparator);
        List overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        String start2 = KotlinBundle.message((String)(isAbstract ? "overridden.marker.implementation" : "overridden.marker.overrides"), (Object[])new Object[0]);
        return KotlinGutterTooltipHelper.INSTANCE.buildTooltipText(overridingJavaMethods, start2, true, "GotoImplementation");
    }

    private static final boolean getOverriddenDeclarations$lambda$3(Map $mappingToJava, HashSet $overridden, PsiElement superMember, PsiElement overridingMember) {
        block4: {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
                Intrinsics.checkNotNullParameter((Object)overridingMember, (String)"overridingMember");
                ProgressManager.checkCanceled();
                List<PsiMethod> possiblyFakeLightMethods = OverridersSearchKt.toPossiblyFakeLightMethods(overridingMember);
                Iterable iterable = possiblyFakeLightMethods;
                for (Object t : iterable) {
                    PsiMethod it = (PsiMethod)t;
                    boolean bl = false;
                    if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            PsiMethod psiMethod = v0;
            if (psiMethod == null) break block4;
            PsiMethod it = psiMethod;
            boolean bl = false;
            Object v = $mappingToJava.remove(superMember);
            if (v != null) {
                Object declaration = v;
                boolean bl2 = false;
                if ($mappingToJava.remove(it) == null) {
                    $mappingToJava.values().removeIf(superMember::equals);
                }
                $overridden.add(declaration);
            }
        }
        return !$mappingToJava.isEmpty();
    }
}

