/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.base.codeInsight.EnumValuesSoftDeprecateKt;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinFindUsagesHandlerFactory;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.EnumUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.idea.highlighting.SafeDeleteFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchParameters;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ!\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016R\u00020\u0014\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\b*\u00020\u0019H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\b*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\b*\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0006*\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010(\u001a\u00020\u001cH\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\u0006*\u00020\u001cH\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010\u0006*\u00020\u001cH\u0002J\u0014\u0010+\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020,0\u0005H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J'\u0010.\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600H\u0002R\u00020\u0014\u00a2\u0006\u0002\u00101J!\u00102\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\nH\u0002R\u00020\u0014\u00a2\u0006\u0002\u00104J/\u00105\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u00106\u001a\u0004\u0018\u0001072\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010:J=\u00105\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u00106\u001a\u0004\u0018\u0001072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\"0<2\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010=J+\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010\t\u001a\u00020\n2\b\u0010C\u001a\u0004\u0018\u00010\nH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010DJ5\u0010E\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010F\u001a\u00020GH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010HJ-\u0010I\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u00108\u001a\u0004\u0018\u0001092\b\u0010C\u001a\u0004\u0018\u00010\nH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010JJ#\u0010K\u001a\u00020\b2\b\u0010L\u001a\u0004\u0018\u0001072\u0006\u0010F\u001a\u00020GH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010MJ\u0015\u0010N\u001a\u00020\b*\u00020OH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010PJ\u0019\u0010Q\u001a\u00020\b2\u0006\u0010L\u001a\u000207H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010RJ!\u0010K\u001a\u00020\b2\u0006\u0010S\u001a\u00020B2\u0006\u0010L\u001a\u000207H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010TJ\u000e\u0010U\u001a\u0004\u0018\u00010V*\u00020WH\u0002J\u0016\u0010X\u001a\u0004\u0018\u00010Y*\u00020Y2\u0006\u0010L\u001a\u000207H\u0002J\u0016\u0010Z\u001a\u0004\u0018\u00010[*\u00020Y2\u0006\u0010L\u001a\u000207H\u0002J\f\u0010\\\u001a\u00020\b*\u00020]H\u0002J\u0017\u0010^\u001a\u0004\u0018\u00010_*\u00020VH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010`J\u0015\u0010\\\u001a\u00020\b*\u00020VH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010aJ\f\u0010b\u001a\u00020\b*\u00020cH\u0002J\u0014\u0010b\u001a\u00020\b*\u00020d2\u0006\u0010L\u001a\u000207H\u0002J\u001f\u0010e\u001a\u00020\b*\u00020f2\b\u00108\u001a\u0004\u0018\u000109H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010gJ\u0015\u0010h\u001a\u00020\b*\u00020iH\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010jJ\u0018\u0010k\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010F\u001a\u00020GH\u0002J+\u0010l\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010F\u001a\u00020G2\b\u00108\u001a\u0004\u0018\u000109H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010mJ\u0010\u0010n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010o\u001a\u00020\b2\u0006\u0010p\u001a\u00020qH\u0002J\u0019\u0010r\u001a\b\u0012\u0004\u0012\u00020t0s2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010uJ/\u0010v\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\"0<2\u0006\u0010w\u001a\u00020\u0016H\u0002R\u00020\u0014\u00a2\u0006\u0002\u0010xR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010>\u001a\u00020\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil;", "", "<init>", "()V", "KOTLIN_ADDITIONAL_ANNOTATIONS", "", "", "isApplicableByPsi", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isExpectedOrActual", "owner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "isEffectivelyAbstractFunction", "ownerFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isLocalDeclaration", "getPsiToReportProblem", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isJavaEntryPointInspection", "Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Lcom/intellij/psi/PsiElement;", "hasKotlinAdditionalAnnotation", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "isSerializationImplicitlyUsedField", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isSerializationImplicitlyUsedMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getClassNameForCompanionObject", "Lcom/intellij/psi/PsiNamedElement;", "isCheapEnoughToSearchUsages", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "declarationAccessorNames", "listOfParameterAccessorNames", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "listOfPropertyAccessorNames", "property", "getCustomGetterName", "getCustomSetterName", "getCustomAccessorName", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "isAnnotationParameter", "checkAnnotatedUsingPatterns", "annotationPatterns", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/Collection;)Z", "checkDeclaration", "importedDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasNonTrivialUsages", "declarationContainingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isCheapEnough", "Lkotlin/Lazy;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Lazy;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isObjectOrEnum", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "checkReference", "ref", "Lcom/intellij/psi/PsiReference;", "originalDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasReferences", "useScope", "Lcom/intellij/psi/search/SearchScope;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lcom/intellij/psi/search/SearchScope;)Z", "checkPrivateDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasBuiltInEnumFunctionReference", "enumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;Lcom/intellij/psi/search/SearchScope;)Z", "isReferenceToBuiltInEnumEntries", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Z", "hasEnumFunctionReferenceInEnumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "reference", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "normalizeImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/psi/KtElement;", "normalizeEnumQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "normalizeEnumCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "isUsedStarImportOfEnumStaticFunctions", "Lcom/intellij/psi/PsiImportStaticStatement;", "resolveReferenceToSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Z", "isReferenceToBuiltInEnumFunction", "Lcom/intellij/psi/PsiImportStaticReferenceElement;", "Lcom/intellij/psi/PsiReferenceExpression;", "canBeHandledByLightMethods", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "hasInlineClassParameters", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;)Z", "hasOverrides", "hasFakeOverrides", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/search/SearchScope;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "hasPlatformImplementations", "classOrObjectHasTextUsages", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)[Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "isEntryPoint", "isJavaEntryPoint", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lkotlin/Lazy;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Z", "kotlin.highlighting.k2"})
@SourceDebugExtension(value={"SMAP\nK2UnusedSymbolUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,800:1\n154#2:801\n154#2:802\n154#2:808\n150#2:836\n150#2:837\n133#2:849\n150#2:855\n322#2:882\n333#2,10:883\n355#2:893\n322#2:894\n333#2,10:895\n355#2:905\n322#2:906\n333#2,10:907\n355#2:917\n322#2:918\n333#2,10:919\n355#2:929\n162#2:930\n322#2:935\n333#2,10:936\n355#2:946\n12574#3,2:803\n12371#3,2:964\n12574#3,2:966\n1755#4,3:805\n774#4:809\n865#4,2:810\n774#4:812\n865#4,2:813\n295#4,2:815\n1611#4,9:818\n1863#4:827\n1864#4:829\n1620#4:830\n1755#4,3:831\n1755#4,2:834\n1557#4:838\n1628#4,3:839\n2632#4,3:842\n1755#4,3:845\n1757#4:848\n2632#4,3:850\n1755#4,2:853\n1757#4:856\n1755#4,3:857\n1611#4,9:860\n1863#4:869\n1864#4:871\n1620#4:872\n774#4:873\n865#4,2:874\n1755#4,3:876\n1755#4,3:879\n1557#4:931\n1628#4,3:932\n1557#4:947\n1628#4,3:948\n1557#4:951\n1628#4,3:952\n1755#4,3:955\n1755#4,3:959\n1755#4,2:962\n1757#4:968\n1755#4,3:970\n1557#4:973\n1628#4,3:974\n1#5:817\n1#5:828\n1#5:870\n1251#6:958\n1252#6:969\n*S KotlinDebug\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n*L\n171#1:801\n173#1:802\n186#1:808\n363#1:836\n364#1:837\n397#1:849\n453#1:855\n540#1:882\n540#1:883,10\n540#1:893\n545#1:894\n545#1:895,10\n545#1:905\n551#1:906\n551#1:907,10\n551#1:917\n599#1:918\n599#1:919,10\n599#1:929\n605#1:930\n624#1:935\n624#1:936,10\n624#1:946\n177#1:803,2\n697#1:964,2\n698#1:966,2\n181#1:805,3\n258#1:809\n258#1:810,2\n261#1:812\n261#1:813,2\n265#1:815,2\n279#1:818,9\n279#1:827\n279#1:829\n279#1:830\n289#1:831,3\n358#1:834,2\n367#1:838\n367#1:839,3\n369#1:842,3\n371#1:845,3\n358#1:848\n407#1:850,3\n452#1:853,2\n452#1:856\n462#1:857,3\n517#1:860,9\n517#1:869\n517#1:871\n517#1:872\n518#1:873\n518#1:874,2\n519#1:876,3\n526#1:879,3\n615#1:931\n615#1:932,3\n636#1:947\n636#1:948,3\n642#1:951\n642#1:952,3\n661#1:955,3\n691#1:959,3\n694#1:962,2\n694#1:968\n754#1:970,3\n596#1:973\n596#1:974,3\n279#1:828\n517#1:870\n683#1:958\n683#1:969\n*E\n"})
public final class K2UnusedSymbolUtil {
    @NotNull
    public static final K2UnusedSymbolUtil INSTANCE = new K2UnusedSymbolUtil();
    @NotNull
    private static final List<String> KOTLIN_ADDITIONAL_ANNOTATIONS;

    private K2UnusedSymbolUtil() {
    }

    public final boolean isApplicableByPsi(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            return false;
        }
        if (declaration instanceof KtParameter) {
            String name2 = ((KtParameter)declaration).getName();
            if (name2 == null || Intrinsics.areEqual((Object)name2, (Object)"_")) {
                return false;
            }
            if (((KtParameter)declaration).isFunctionTypeParameter()) {
                return false;
            }
            KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
            if (ownerFunction instanceof KtConstructor) {
                KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
                if (containingClass != null) {
                    if (containingClass.isData()) {
                        return false;
                    }
                    if (containingClass.isValue() && ((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                    if (containingClass.isInline() && ((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                    if (this.isExpectedOrActual((KtModifierListOwner)containingClass)) {
                        return false;
                    }
                }
            } else {
                if (ownerFunction instanceof KtFunctionLiteral) {
                    return false;
                }
                if (ownerFunction instanceof KtFunction && (this.isEffectivelyAbstractFunction((KtFunction)ownerFunction) || this.isExpectedOrActual((KtModifierListOwner)ownerFunction))) {
                    return false;
                }
            }
        }
        KtNamedDeclaration owner = null;
        if (declaration instanceof KtTypeParameter) {
            PsiElement parent = ((KtTypeParameter)declaration).getParent();
            if (parent != null && !(parent instanceof KtTypeParameterListOwner)) {
                parent = parent.getParent();
            }
            owner = parent instanceof KtTypeParameterListOwner ? (KtNamedDeclaration)parent : declaration;
        } else {
            owner = declaration;
        }
        return !owner.hasModifier(KtTokens.OVERRIDE_KEYWORD);
    }

    private final boolean isExpectedOrActual(KtModifierListOwner owner) {
        KtModifierList modifierList = owner.getModifierList();
        return modifierList != null && (modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.ACTUAL_KEYWORD));
    }

    private final boolean isEffectivelyAbstractFunction(KtFunction ownerFunction) {
        KtModifierList modifierList = ownerFunction.getModifierList();
        if (modifierList != null && (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD) || modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) || modifierList.hasModifier(KtTokens.OPEN_KEYWORD))) {
            return true;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ownerFunction));
        return ktClass != null ? ktClass.isInterface() : false;
    }

    public final boolean isLocalDeclaration(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtProperty && ((KtProperty)declaration).isLocal()) {
            return true;
        }
        return declaration instanceof KtParameter && (!(((KtParameter)declaration).getParent().getParent() instanceof KtPrimaryConstructor) || !((KtParameter)declaration).hasValOrVar());
    }

    @Nullable
    public final PsiElement getPsiToReportProblem(@NotNull KaSession $context_receiver_0, @NotNull KtNamedDeclaration declaration, @NotNull UnusedDeclarationInspectionBase isJavaEntryPointInspection) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)isJavaEntryPointInspection, (String)"isJavaEntryPointInspection");
        KaDeclarationSymbol symbol = $context_receiver_0.getSymbol((KtDeclaration)declaration);
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration).getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED && symbol.getCompilerVisibility().isPublicAPI()) {
            return null;
        }
        if (symbol instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol).isOperator()) {
            return null;
        }
        Lazy isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.getPsiToReportProblem$lambda$0(declaration));
        if (this.isEntryPoint($context_receiver_0, declaration, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, isJavaEntryPointInspection)) {
            return null;
        }
        if (AnalysisUtilsKt.isFinalizeMethod($context_receiver_0, (KtDeclaration)declaration)) {
            return null;
        }
        if (declaration instanceof KtProperty && this.isSerializationImplicitlyUsedField((KtProperty)declaration)) {
            return null;
        }
        if (declaration instanceof KtNamedFunction && this.isSerializationImplicitlyUsedMethod((KtNamedFunction)declaration)) {
            return null;
        }
        KtClass declarationContainingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
        if (KotlinPsiUtils.isConstructorDeclaredProperty(declaration)) {
            KtClass ktClass = declarationContainingClass;
            boolean bl = ktClass != null ? KotlinPsiUtils.mustHaveNonEmptyPrimaryConstructor(ktClass) : false;
            if (bl) {
                return null;
            }
        }
        if (symbol instanceof KaClassSymbol && ((KaClassSymbol)symbol).getClassKind() == KaClassKind.ANNOTATION_CLASS) {
            String string = KaClassLikeSymbolKt.getNameOrAnonymous((KaClassifierSymbol)symbol).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqName2 = string;
            LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration);
            if (((List)languageVersionSettings.getFlag(AnalysisFlags.getOptIn())).contains(fqName2)) {
                return null;
            }
        }
        if (this.hasNonTrivialUsages($context_receiver_0, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol)) {
            return null;
        }
        if (declaration instanceof KtClassOrObject && this.classOrObjectHasTextUsages((KtClassOrObject)declaration)) {
            return null;
        }
        Object object = declaration.getNameIdentifier();
        if (object == null) {
            KtConstructor ktConstructor = declaration instanceof KtConstructor ? (KtConstructor)declaration : null;
            object = ktConstructor != null ? ktConstructor.getConstructorKeyword() : null;
        }
        return object;
    }

    private final boolean hasKotlinAdditionalAnnotation(KaSession $context_receiver_0, KtDeclaration $this$hasKotlinAdditionalAnnotation) {
        return $this$hasKotlinAdditionalAnnotation instanceof KtNamedDeclaration && this.checkAnnotatedUsingPatterns($context_receiver_0, (KtNamedDeclaration)$this$hasKotlinAdditionalAnnotation, (Collection<String>)KOTLIN_ADDITIONAL_ANNOTATIONS);
    }

    private final boolean isSerializationImplicitlyUsedField(KtProperty $this$isSerializationImplicitlyUsedField) {
        boolean bl;
        block5: {
            Object object;
            PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isSerializationImplicitlyUsedField;
            boolean $i$f$getNonStrictParentOfType = false;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
            KtObjectDeclaration ktObjectDeclaration = psiElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement : null;
            if (ktObjectDeclaration == null) {
                return false;
            }
            KtObjectDeclaration ownerObject = ktObjectDeclaration;
            if (ownerObject.isCompanion()) {
                PsiElement $this$getNonStrictParentOfType$iv2 = (PsiElement)ownerObject;
                boolean $i$f$getNonStrictParentOfType2 = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtClass.class, (boolean)false);
                object = ktClass != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass)) : null;
            } else {
                object = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ownerObject));
            }
            if (object == null) {
                return false;
            }
            KtLightClass lightClass = object;
            PsiField[] psiFieldArray = lightClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            Object[] $this$any$iv = psiFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiField it = (PsiField)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$isSerializationImplicitlyUsedField.getName()) && HighlightUtil.isSerializationImplicitlyUsedField((PsiField)it))) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSerializationImplicitlyUsedMethod(KtNamedFunction $this$isSerializationImplicitlyUsedMethod) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)$this$isSerializationImplicitlyUsedMethod));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    if (!JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)it, (PsiClass)it.getContainingClass())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getClassNameForCompanionObject(PsiNamedElement $this$getClassNameForCompanionObject) {
        String string;
        if ($this$getClassNameForCompanionObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$getClassNameForCompanionObject).isCompanion()) {
            PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$getClassNameForCompanionObject;
            boolean $i$f$getNonStrictParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClass.class, (boolean)false);
            string = ktClass != null ? ktClass.getName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchUsages(KtNamedDeclaration declaration) {
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
        if (!KotlinSearchUsagesSupport.Companion.getInstance(project2).findScriptsWithUsages(declaration, (Function1<? super KtFile, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.isCheapEnoughToSearchUsages$lambda$3(project2, arg_0)))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        SearchScope searchScope = psiSearchHelper2.getUseScope((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope useScope = searchScope;
        if (useScope instanceof GlobalSearchScope) {
            boolean zeroOccurrences = true;
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)declaration.getName()), (Iterable)this.declarationAccessorNames(declaration)), (Iterable)CollectionsKt.listOfNotNull((Object)this.getClassNameForCompanionObject((PsiNamedElement)declaration)));
            block5: for (String name2 : list2) {
                if (name2 == null) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[SearchUtilKt.isCheapEnoughToSearchConsideringOperators$default(psiSearchHelper2, name2, (GlobalSearchScope)useScope, null, 4, null).ordinal()]) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        zeroOccurrences = false;
                        continue block5;
                    }
                    case 3: {
                        return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (zeroOccurrences) {
                return PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES;
            }
        }
        return PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
    }

    private final List<String> declarationAccessorNames(KtNamedDeclaration declaration) {
        KtNamedDeclaration ktNamedDeclaration = declaration;
        return ktNamedDeclaration instanceof KtProperty ? this.listOfPropertyAccessorNames((KtProperty)declaration) : (ktNamedDeclaration instanceof KtParameter ? this.listOfParameterAccessorNames((KtParameter)declaration) : CollectionsKt.emptyList());
    }

    private final List<String> listOfParameterAccessorNames(KtParameter parameter) {
        List accessors;
        block2: {
            accessors = new ArrayList();
            if (!parameter.hasValOrVar()) break block2;
            String string = parameter.getName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                accessors.add(JvmAbi.getterName((String)it));
                if (parameter.isVarArg()) {
                    accessors.add(JvmAbi.setterName((String)it));
                }
            }
        }
        return accessors;
    }

    private final List<String> listOfPropertyAccessorNames(KtProperty property) {
        List accessors = new ArrayList();
        String string = property.getName();
        if (string == null) {
            return accessors;
        }
        String propertyName = string;
        String string2 = this.getCustomGetterName(property);
        if (string2 == null) {
            string2 = JvmAbi.getterName((String)propertyName);
        }
        accessors.add(string2);
        if (property.isVar()) {
            String string3 = this.getCustomSetterName(property);
            if (string3 == null) {
                string3 = JvmAbi.setterName((String)propertyName);
            }
            accessors.add(string3);
        }
        return accessors;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCustomGetterName(KtProperty $this$getCustomGetterName) {
        Object object = $this$getCustomGetterName.getGetter();
        if (object == null || (object = object.getAnnotationEntries()) == null || (object = this.getCustomAccessorName((List<? extends KtAnnotationEntry>)object)) == null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list2 = $this$getCustomGetterName.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable iterable = list2;
            K2UnusedSymbolUtil k2UnusedSymbolUtil = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                boolean bl = false;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                if (!((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) == AnnotationUseSiteTarget.PROPERTY_GETTER)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = k2UnusedSymbolUtil.getCustomAccessorName((List)destination$iv$iv);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCustomSetterName(KtProperty $this$getCustomSetterName) {
        Object object = $this$getCustomSetterName.getSetter();
        if (object == null || (object = object.getAnnotationEntries()) == null || (object = this.getCustomAccessorName((List<? extends KtAnnotationEntry>)object)) == null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list2 = $this$getCustomSetterName.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable iterable = list2;
            K2UnusedSymbolUtil k2UnusedSymbolUtil = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                boolean bl = false;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                if (!((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) == AnnotationUseSiteTarget.PROPERTY_SETTER)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = k2UnusedSymbolUtil.getCustomAccessorName((List)destination$iv$iv);
        }
        return object;
    }

    private final String getCustomAccessorName(List<? extends KtAnnotationEntry> $this$getCustomAccessorName) {
        String string;
        Object v1;
        block4: {
            Iterable $this$firstOrNull$iv = $this$getCustomAccessorName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                Name name2 = it.getShortName();
                if (!Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)"JvmName")) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v1;
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry customJvmNameAnnotation = ktAnnotationEntry;
        List list2 = customJvmNameAnnotation.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list2);
        if (valueArgument != null && (valueArgument = valueArgument.getArgumentExpression()) != null) {
            ValueArgument it = valueArgument;
            boolean bl = false;
            string = ElementManipulators.getValueText((PsiElement)((PsiElement)it));
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isAnnotationParameter(KtParameter parameter) {
        KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
        KtConstructor ktConstructor = ktDeclarationWithBody instanceof KtConstructor ? (KtConstructor)ktDeclarationWithBody : null;
        if (ktConstructor == null) {
            return false;
        }
        KtConstructor constructor = ktConstructor;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)constructor));
        return ktClassOrObject != null ? ktClassOrObject.isAnnotation() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkAnnotatedUsingPatterns(KaSession $context_receiver_0, KtNamedDeclaration declaration, Collection<String> annotationPatterns) {
        void $this$mapNotNullTo$iv$iv;
        if (declaration.getAnnotationEntries().isEmpty()) {
            return false;
        }
        List list2 = declaration.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            KaConstructorSymbol constructorSymbol;
            ClassId classId;
            KaSymbol symbol;
            KtAnnotationEntry reference2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            KtAnnotationEntry ktAnnotationEntry = it;
            if ((ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getCalleeExpression()) == null || (ktAnnotationEntry = ktAnnotationEntry.getConstructorReferenceExpression()) == null || (ktAnnotationEntry = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktAnnotationEntry)) == null ? null : ($context_receiver_0.resolveToSymbol((KtReference)(reference2 = ktAnnotationEntry)) == null ? null : ((symbol instanceof KaConstructorSymbol ? (KaConstructorSymbol)symbol : null) == null ? null : ((classId = (constructorSymbol = constructorSymbol).getContainingClassId()) != null && (classId = classId.asSingleFqName()) != null ? classId.asString() : null)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotationsPresent = (List)destination$iv$iv;
        if (annotationsPresent.isEmpty()) {
            return false;
        }
        for (String pattern2 : annotationPatterns) {
            boolean hasAnnotation;
            boolean bl;
            block9: {
                if (StringsKt.endsWith$default((String)pattern2, (String)".*", (boolean)false, (int)2, null)) {
                    Iterable $this$any$iv = annotationsPresent;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)StringsKt.dropLast((String)pattern2, (int)1), (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                } else {
                    bl = annotationsPresent.contains(pattern2);
                }
            }
            if (!(hasAnnotation = bl)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkDeclaration(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtNamedDeclaration importedDeclaration) {
        return !SequencesKt.contains((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)importedDeclaration)), (Object)declaration) && !K2UnusedSymbolUtil.hasNonTrivialUsages$default(this, $context_receiver_0, importedDeclaration, KtPsiUtilKt.containingClass((KtElement)((KtElement)importedDeclaration)), null, 8, null);
    }

    private final boolean hasNonTrivialUsages(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol) {
        Lazy isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.hasNonTrivialUsages$lambda$11(declaration));
        return this.hasNonTrivialUsages($context_receiver_0, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol);
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 8) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, kaDeclarationSymbol);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean hasNonTrivialUsages(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtClass declarationContainingClass, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, KaDeclarationSymbol symbol) {
        SearchScope restrictedScope;
        block35: {
            boolean bl;
            block34: {
                boolean bl2;
                Iterable $this$any$iv;
                GlobalSearchScope containingClassSearchScope;
                block36: {
                    boolean isOpenClass;
                    Project project = declaration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Project project2 = project;
                    PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
                    Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
                    PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
                    SearchScope searchScope = psiSearchHelper2.getUseScope((PsiElement)declaration);
                    Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
                    SearchScope useScope = searchScope;
                    if (useScope instanceof GlobalSearchScope) {
                        boolean bl3;
                        switch (WhenMappings.$EnumSwitchMapping$0[((PsiSearchHelper.SearchCostResult)isCheapEnough.getValue()).ordinal()]) {
                            case 1: {
                                bl3 = true;
                                break;
                            }
                            case 2: {
                                bl3 = false;
                                break;
                            }
                            case 3: {
                                return true;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        boolean zeroOccurrences = bl3;
                        if (zeroOccurrences && !PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                            if (!(declaration instanceof KtObjectDeclaration)) return false;
                            if (!((KtObjectDeclaration)declaration).isCompanion()) {
                                return false;
                            }
                        }
                        v4 = (SearchScope)(PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration)) ? KotlinSourceFilterScope.Companion.projectSourcesAndResources(KotlinScopeUtils.projectScope(project2), project2) : KotlinSourceFilterScope.Companion.projectSourcesAndResources((GlobalSearchScope)useScope, project2));
                    } else {
                        v4 = restrictedScope = useScope;
                    }
                    if (!(declaration instanceof KtTypeParameter) || declarationContainingClass == null) break block35;
                    boolean bl4 = isOpenClass = declarationContainingClass.isInterface() || declarationContainingClass.hasModifier(KtTokens.ABSTRACT_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.SEALED_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.OPEN_KEYWORD);
                    if (isOpenClass && this.hasOverrides((KtNamedDeclaration)declarationContainingClass, restrictedScope)) {
                        return true;
                    }
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
                    containingClassSearchScope = globalSearchScope;
                    Query query = ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters((PsiElement)declarationContainingClass, (SearchScope)containingClassSearchScope, false, null, null, 28, null));
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                    $this$any$iv = (Iterable)query;
                    boolean $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block36;
                    bl = false;
                    break block34;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    Iterator iterator3;
                    block40: {
                        block37: {
                            boolean bl5;
                            KtCallableDeclaration callableDeclaration;
                            block33: {
                                KtCallableDeclaration ktCallableDeclaration;
                                List typeArguments2;
                                block39: {
                                    block38: {
                                        KtParameter parameter;
                                        KtUserType userType;
                                        if (!iterator2.hasNext()) break block37;
                                        Object element$iv = iterator2.next();
                                        PsiReference ref = (PsiReference)element$iv;
                                        boolean bl6 = false;
                                        PsiElement psiElement = ref.getElement().getParent();
                                        if ((psiElement instanceof KtUserType ? (KtUserType)psiElement : null) == null) {
                                            bl2 = false;
                                            continue;
                                        }
                                        userType = userType;
                                        Intrinsics.checkNotNullExpressionValue((Object)userType.getTypeArguments(), (String)"getTypeArguments(...)");
                                        if (typeArguments2.isEmpty()) {
                                            bl2 = false;
                                            continue;
                                        }
                                        PsiElement $this$getStrictParentOfType$iv = (PsiElement)userType;
                                        boolean $i$f$getStrictParentOfType = false;
                                        if ((KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true) == null) {
                                            bl2 = false;
                                            continue;
                                        }
                                        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)parameter;
                                        boolean $i$f$getStrictParentOfType2 = false;
                                        ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallableDeclaration.class, (boolean)true);
                                        if (ktCallableDeclaration == null) break block38;
                                        KtCallableDeclaration ktCallableDeclaration2 = ktCallableDeclaration;
                                        boolean bl7 = false;
                                        KtTypeParameterListOwnerStub ktTypeParameterListOwnerStub = !(ktCallableDeclaration2 instanceof KtNamedFunction) ? (KtTypeParameterListOwnerStub)KtPsiUtilKt.containingClass((KtElement)((KtElement)ktCallableDeclaration2)) : (KtTypeParameterListOwnerStub)ktCallableDeclaration2;
                                        ktCallableDeclaration = ktTypeParameterListOwnerStub;
                                        if (ktTypeParameterListOwnerStub != null) break block39;
                                    }
                                    bl2 = false;
                                    continue;
                                }
                                callableDeclaration = ktCallableDeclaration;
                                List list2 = callableDeclaration.getTypeParameters();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
                                Iterable $this$map$iv = list2;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : iterable) {
                                    void it;
                                    KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl8 = false;
                                    collection.add(it.getName());
                                }
                                List typeParameters2 = (List)destination$iv$iv;
                                if (typeParameters2.isEmpty()) {
                                    bl2 = false;
                                    continue;
                                }
                                Iterable $this$none$iv = typeArguments2;
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl5 = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        KtTypeProjection it = (KtTypeProjection)element$iv;
                                        boolean bl9 = false;
                                        if (!typeParameters2.contains(it.getText())) continue;
                                        bl5 = false;
                                        break block33;
                                    }
                                    bl5 = true;
                                }
                            }
                            if (bl5) {
                                bl2 = false;
                                continue;
                            }
                            Query query = ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters((PsiElement)callableDeclaration, (SearchScope)containingClassSearchScope, false, null, null, 28, null));
                            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                            Iterable $this$any$iv2 = (Iterable)query;
                            boolean $i$f$any = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                                continue;
                            }
                            iterator3 = $this$any$iv2.iterator();
                            break block40;
                        }
                        bl = false;
                        break block34;
                    }
                    while (iterator3.hasNext()) {
                        KtCallElement callElement;
                        Object element$iv;
                        element$iv = iterator3.next();
                        PsiReference it = (PsiReference)element$iv;
                        boolean bl10 = false;
                        PsiElement psiElement = it.getElement().getParent();
                        KtCallElement ktCallElement = callElement = psiElement instanceof KtCallElement ? (KtCallElement)psiElement : null;
                        if (callElement != null && callElement.getTypeArgumentList() == null) {
                            return true;
                        }
                        boolean bl11 = false;
                        if (!bl11) continue;
                        return true;
                    }
                    bl2 = false;
                } while (!bl2);
                return true;
            }
            boolean isRequiredToCallFunction = bl;
            if (isRequiredToCallFunction) {
                return true;
            }
        }
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            boolean bl;
            Object object = ((KtObjectDeclaration)declaration).getBody();
            if (object != null && (object = object.getDeclarations()) != null) {
                if (!((Collection)object).isEmpty()) {
                    return true;
                }
                boolean bl12 = false;
                if (bl12) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (this.hasReferences($context_receiver_0, declaration, declarationContainingClass, symbol, restrictedScope)) return true;
        if (this.hasOverrides(declaration, restrictedScope)) return true;
        if (this.hasFakeOverrides($context_receiver_0, declaration, restrictedScope, symbol)) return true;
        if (this.hasPlatformImplementations(declaration)) return true;
        return false;
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, Lazy lazy, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 0x10) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)lazy, kaDeclarationSymbol);
    }

    private final boolean isObjectOrEnum(KtNamedDeclaration $this$isObjectOrEnum) {
        return $this$isObjectOrEnum instanceof KtObjectDeclaration || $this$isObjectOrEnum instanceof KtClass && ((KtClass)$this$isObjectOrEnum).isEnum();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkReference(KaSession $context_receiver_0, PsiReference ref, KtNamedDeclaration declaration, KtNamedDeclaration originalDeclaration) {
        KtExpression ktExpression;
        FqName declarationFqName;
        void $this$getParentOfType$iv;
        PsiElement psiElement = ref.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement refElement = psiElement;
        if (PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)declaration), (PsiElement)refElement, (boolean)false, (int)2, null)) {
            return true;
        }
        if (refElement.getParent() instanceof KtValueArgumentName) {
            return true;
        }
        PsiElement psiElement2 = refElement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType2 = false;
        KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, (boolean)strict$iv);
        if (ktImportDirective == null) {
            return false;
        }
        KtImportDirective ktImportDirective2 = ktImportDirective;
        String aliasName = ktImportDirective2.getAliasName();
        if (aliasName != null && !Intrinsics.areEqual((Object)aliasName, (Object)declaration.getName())) {
            return false;
        }
        if (!(declaration instanceof KtClassOrObject) && !(originalDeclaration instanceof KtClassOrObject)) {
            return true;
        }
        if (ktImportDirective2.isAllUnder()) {
            boolean bl;
            block16: {
                KtExpression ktExpression2 = ktImportDirective2.getImportedReference();
                PsiElement $i$f$getParentOfType2 = ktExpression2 != null && (ktExpression2 = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression2))) != null && (ktExpression2 = ReferenceUtilsKt.getMainReference((KtElement)ktExpression2)) != null ? ktExpression2.resolve() : null;
                KtClassOrObject ktClassOrObject = $i$f$getParentOfType2 instanceof KtClassOrObject ? (KtClassOrObject)$i$f$getParentOfType2 : null;
                if (ktClassOrObject == null) {
                    return true;
                }
                KtClassOrObject importedFrom = ktClassOrObject;
                Iterable $this$none$iv = importedFrom.getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtNamedDeclaration && K2UnusedSymbolUtil.hasNonTrivialUsages$default(INSTANCE, $context_receiver_0, (KtNamedDeclaration)it, KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), null, 8, null))) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        FqName importedFqName = ktImportDirective2.getImportedFqName();
        if (Intrinsics.areEqual((Object)importedFqName, (Object)(declarationFqName = declaration.getFqName()))) {
            return true;
        }
        if (declarationFqName != null) {
            FqName fqName2 = importedFqName;
            boolean bl = fqName2 != null ? fqName2.startsWith(declarationFqName) : false;
            if (bl) {
                return false;
            }
        }
        PsiElement psiElement3 = (ktExpression = ktImportDirective2.getImportedReference()) != null && (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) != null && (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)ktExpression)) != null ? ktExpression.resolve() : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement3 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement3 : null;
        if (ktNamedDeclaration == null) {
            return true;
        }
        KtNamedDeclaration importedDeclaration = ktNamedDeclaration;
        if (this.isObjectOrEnum(declaration) || KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)importedDeclaration)) instanceof KtObjectDeclaration) {
            return this.checkDeclaration($context_receiver_0, declaration, importedDeclaration);
        }
        KtNamedDeclaration ktNamedDeclaration2 = originalDeclaration;
        boolean bl = ktNamedDeclaration2 != null ? this.isObjectOrEnum(ktNamedDeclaration2) : false;
        if (bl) {
            return this.checkDeclaration($context_receiver_0, originalDeclaration, importedDeclaration);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasReferences(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol, SearchScope useScope) {
        KtNamedDeclaration originalDeclaration;
        KotlinReferencesSearchOptions searchOptions = new KotlinReferencesSearchOptions(PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration)), false, false, false, false, false, false, false, false, 510, null);
        KotlinReferencesSearchParameters searchParameters2 = new KotlinReferencesSearchParameters((PsiElement)declaration, useScope, false, null, searchOptions, 12, null);
        KaLifetimeOwner kaLifetimeOwner = symbol instanceof KaTypeAliasSymbol ? (KaTypeAliasSymbol)symbol : null;
        PsiElement psiElement = kaLifetimeOwner != null && (kaLifetimeOwner = ((KaTypeAliasSymbol)kaLifetimeOwner).getExpandedType()) != null && (kaLifetimeOwner = $context_receiver_0.getExpandedSymbol((KaType)kaLifetimeOwner)) != null ? kaLifetimeOwner.getPsi() : null;
        KtNamedDeclaration ktNamedDeclaration = originalDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
        if (!(symbol instanceof KaNamedFunctionSymbol) || !((KaNamedFunctionSymbol)symbol).getAnnotations().contains(ClassId.Companion.topLevel(new FqName("kotlin.jvm.JvmName")))) {
            List lightMethods;
            if (declaration instanceof KtSecondaryConstructor && declarationContainingClass != null) {
                boolean bl;
                if (this.isCheapEnoughToSearchUsages((KtNamedDeclaration)declarationContainingClass) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) return true;
                Query query = ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters((PsiElement)declarationContainingClass, useScope, false, null, null, 28, null));
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                Iterable $this$any$iv = (Iterable)query;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KaPartiallyAppliedSymbol kaPartiallyAppliedSymbol;
                        KaFunctionCall<?> kaFunctionCall;
                        KaCallInfo kaCallInfo;
                        PsiElement psiElement2;
                        PsiElement $this$getStrictParentOfType$iv;
                        PsiReference it = (PsiReference)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getElement(), (String)"getElement(...)");
                        boolean bl3 = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeAlias.class, (boolean)true) != null) return true;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getElement(), (String)"getElement(...)");
                        boolean $i$f$getStrictParentOfType = false;
                        $this$getStrictParentOfType$iv = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, KtCallExpression.class, (boolean)true);
                        if (Intrinsics.areEqual($this$getStrictParentOfType$iv != null && (kaCallInfo = $context_receiver_0.resolveToCall((KtElement)$this$getStrictParentOfType$iv)) != null && (kaFunctionCall = KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo)) != null && (kaPartiallyAppliedSymbol = kaFunctionCall.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaPartiallyAppliedSymbol) : null, (Object)symbol)) {
                            return true;
                        }
                        boolean bl4 = false;
                        if (!bl4) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (declaration instanceof KtCallableDeclaration && this.canBeHandledByLightMethods($context_receiver_0, (KtCallableDeclaration)declaration, symbol) && !((Collection)(lightMethods = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration)))).isEmpty()) {
                boolean lightMethodsUsed;
                Iterable $this$any$iv = lightMethods;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiMethod method = (PsiMethod)element$iv;
                        boolean bl = false;
                        if (!MethodReferencesSearch.search((PsiMethod)method).forEach(arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$20$lambda$19($context_receiver_0, declaration, originalDeclaration, arg_0))) {
                            return true;
                        }
                        boolean bl5 = false;
                        if (!bl5) continue;
                        return true;
                    }
                    v5 = lightMethodsUsed = false;
                }
                if (lightMethodsUsed) {
                    return true;
                }
                if (!PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                    return false;
                }
            }
            if (declaration instanceof KtEnumEntry) {
                KtClass enumClass;
                KtClass ktClass = declarationContainingClass;
                if (ktClass != null) {
                    KtClass ktClass2;
                    KtClass it = ktClass2 = ktClass;
                    boolean bl = false;
                    v8 = it.isEnum() ? ktClass2 : null;
                } else {
                    v8 = enumClass = null;
                }
                if (this.hasBuiltInEnumFunctionReference($context_receiver_0, enumClass, useScope)) {
                    return true;
                }
            }
        }
        if (!ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters2).forEach(arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$22($context_receiver_0, declaration, originalDeclaration, arg_0))) return true;
        return this.checkPrivateDeclaration($context_receiver_0, declaration, symbol, originalDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkPrivateDeclaration(KaSession $context_receiver_0, KtNamedDeclaration declaration, KaDeclarationSymbol symbol, KtNamedDeclaration originalDeclaration) {
        boolean bl;
        block7: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            if (symbol == null || !KtPsiUtilKt.isPrivateNestedClassOrObject((KtNamedDeclaration)declaration)) {
                return false;
            }
            HashSet setOfImportedDeclarations = new HashSet();
            KtImportList ktImportList = declaration.getContainingKtFile().getImportList();
            if (ktImportList != null) {
                ktImportList.acceptChildren((PsiElementVisitor)VisitorWrappersKt.simpleNameExpressionRecursiveVisitor(arg_0 -> K2UnusedSymbolUtil.checkPrivateDeclaration$lambda$23(setOfImportedDeclarations, arg_0)));
            }
            Iterable $this$mapNotNull$iv = setOfImportedDeclarations;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtReferenceExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                KtSimpleNameExpression it = (KtSimpleNameExpression)element$iv$iv;
                boolean bl3 = false;
                if (KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)it)) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtReferenceExpression it = (KtReferenceExpression)element$iv$iv;
                boolean bl5 = false;
                if (!$context_receiver_0.resolveToSymbols(ReferenceUtilsKt.getMainReference((KtReferenceExpression)it)).contains(symbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtReferenceExpression it = (KtReferenceExpression)element$iv;
                    boolean bl6 = false;
                    if (!(!INSTANCE.checkReference($context_receiver_0, (PsiReference)ReferenceUtilsKt.getMainReference((KtReferenceExpression)it), declaration, originalDeclaration))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasBuiltInEnumFunctionReference(KaSession $context_receiver_0, KtClass enumClass, SearchScope useScope) {
        boolean bl;
        block4: {
            void $this$any$iv;
            if (enumClass == null) {
                return false;
            }
            Query query = ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters((PsiElement)enumClass, useScope, false, null, null, 28, null));
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            Iterable iterable = (Iterable)query;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiReference it = (PsiReference)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!INSTANCE.hasBuiltInEnumFunctionReference($context_receiver_0, it, enumClass)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean isFoundEnumFunctionReferenceViaSearch = bl;
        return isFoundEnumFunctionReferenceViaSearch || this.hasEnumFunctionReferenceInEnumClass($context_receiver_0, enumClass);
    }

    private final boolean isReferenceToBuiltInEnumEntries(KaSession $context_receiver_0, KtSimpleNameExpression $this$isReferenceToBuiltInEnumEntries) {
        return EnumValuesSoftDeprecateKt.isEnumValuesSoftDeprecateEnabled((PsiElement)$this$isReferenceToBuiltInEnumEntries) && Intrinsics.areEqual((Object)$this$isReferenceToBuiltInEnumEntries.getReferencedNameAsName(), (Object)StandardNames.ENUM_ENTRIES) && KotlinPsiUtilsKt.isSynthesizedFunction($context_receiver_0, (KtExpression)$this$isReferenceToBuiltInEnumEntries);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEnumFunctionReferenceInEnumClass(KaSession $context_receiver_0, KtClass enumClass) {
        boolean isFoundSimpleNameExpression;
        PsiElement $this$anyDescendantOfType$iv;
        boolean isFoundCallableReference;
        void $this$anyDescendantOfType$iv2;
        PsiElement psiElement = (PsiElement)enumClass;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$28(enumClass, $context_receiver_0, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv2;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallableReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl = isFoundCallableReference = (PsiElement)result$iv$iv$iv.element != null;
        if (isFoundCallableReference) {
            return true;
        }
        predicate$iv = (PsiElement)enumClass;
        Function1 predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$29(enumClass, $context_receiver_0, arg_0);
        boolean $i$f$anyDescendantOfType2 = false;
        PsiElement $this$findDescendantOfType$iv$iv2 = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType3 = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv2 = $this$findDescendantOfType$iv$iv2;
        boolean $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv2);
        Ref.ObjectRef result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl2 = isFoundSimpleNameExpression = (PsiElement)result$iv$iv$iv2.element != null;
        if (isFoundSimpleNameExpression) {
            return true;
        }
        $this$anyDescendantOfType$iv = (PsiElement)enumClass;
        predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$30(enumClass, $context_receiver_0, arg_0);
        $i$f$anyDescendantOfType2 = false;
        $this$findDescendantOfType$iv$iv2 = $this$anyDescendantOfType$iv;
        $i$f$findDescendantOfType3 = false;
        $this$findDescendantOfType$iv$iv$iv2 = $this$findDescendantOfType$iv$iv2;
        $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv2);
        result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv2.element != null;
    }

    private final boolean hasBuiltInEnumFunctionReference(KaSession $context_receiver_0, PsiReference reference2, KtClass enumClass) {
        KtElement ktElement;
        PsiElement parent = reference2.getElement().getParent();
        KtQualifiedExpression ktQualifiedExpression = parent instanceof KtQualifiedExpression ? (KtQualifiedExpression)parent : null;
        boolean bl = ktQualifiedExpression != null && (ktQualifiedExpression = this.normalizeEnumQualifiedExpression(ktQualifiedExpression, enumClass)) != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktQualifiedExpression) : false;
        if (bl) {
            return true;
        }
        KtQualifiedExpression ktQualifiedExpression2 = parent instanceof KtQualifiedExpression ? (KtQualifiedExpression)parent : null;
        boolean bl2 = ktQualifiedExpression2 != null && (ktQualifiedExpression2 = this.normalizeEnumCallableReferenceExpression(ktQualifiedExpression2, enumClass)) != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction((KtCallableReferenceExpression)ktQualifiedExpression2) : false;
        if (bl2) {
            return true;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = parent instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)parent : null;
        boolean bl3 = ktCallableReferenceExpression != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktCallableReferenceExpression) : false;
        if (bl3) {
            return true;
        }
        KtTypeElement ktTypeElement = parent instanceof KtTypeElement ? (KtTypeElement)parent : null;
        PsiElement psiElement = ktTypeElement != null ? ktTypeElement.getParent() : null;
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        boolean bl4 = ktTypeReference != null ? KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($context_receiver_0, ktTypeReference) : false;
        if (bl4) {
            return true;
        }
        PsiImportStaticReferenceElement psiImportStaticReferenceElement = parent instanceof PsiImportStaticReferenceElement ? (PsiImportStaticReferenceElement)parent : null;
        boolean bl5 = psiImportStaticReferenceElement != null ? this.isReferenceToBuiltInEnumFunction(psiImportStaticReferenceElement) : false;
        if (bl5) {
            return true;
        }
        PsiReferenceExpression psiReferenceExpression = parent instanceof PsiReferenceExpression ? (PsiReferenceExpression)parent : null;
        boolean bl6 = psiReferenceExpression != null ? this.isReferenceToBuiltInEnumFunction(psiReferenceExpression, enumClass) : false;
        if (bl6) {
            return true;
        }
        KtElement ktElement2 = ktElement = parent instanceof KtElement ? (KtElement)parent : null;
        boolean bl7 = ktElement != null && (psiElement = this.normalizeImportDirective(ktElement)) != null ? this.isUsedStarImportOfEnumStaticFunctions($context_receiver_0, (KtImportDirective)psiElement) : false;
        if (bl7) {
            return true;
        }
        PsiImportStaticStatement psiImportStaticStatement = parent instanceof PsiImportStaticStatement ? (PsiImportStaticStatement)parent : null;
        return psiImportStaticStatement != null ? this.isUsedStarImportOfEnumStaticFunctions(psiImportStaticStatement) : false;
    }

    private final KtImportDirective normalizeImportDirective(KtElement $this$normalizeImportDirective) {
        if ($this$normalizeImportDirective instanceof KtImportDirective) {
            return (KtImportDirective)$this$normalizeImportDirective;
        }
        PsiElement psiElement = $this$normalizeImportDirective.getParent();
        return psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
    }

    private final KtQualifiedExpression normalizeEnumQualifiedExpression(KtQualifiedExpression $this$normalizeEnumQualifiedExpression, KtClass enumClass) {
        if (Intrinsics.areEqual((Object)$this$normalizeEnumQualifiedExpression.getReceiverExpression().getText(), (Object)enumClass.getName())) {
            return $this$normalizeEnumQualifiedExpression;
        }
        KtExpression ktExpression = $this$normalizeEnumQualifiedExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumQualifiedExpression.getParent();
            return psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
        }
        return null;
    }

    private final KtCallableReferenceExpression normalizeEnumCallableReferenceExpression(KtQualifiedExpression $this$normalizeEnumCallableReferenceExpression, KtClass enumClass) {
        KtExpression ktExpression = $this$normalizeEnumCallableReferenceExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumCallableReferenceExpression.getParent();
            return psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(PsiImportStaticStatement $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$anyDescendantOfType$iv;
        Object object = $this$isUsedStarImportOfEnumStaticFunctions.getImportReference();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object importedEnumQualifiedName = object;
        PsiClass psiClass = $this$isUsedStarImportOfEnumStaticFunctions.resolveTargetClass();
        KtLightClass ktLightClass = psiClass instanceof KtLightClass ? (KtLightClass)psiClass : null;
        if (!(ktLightClass != null ? ktLightClass.isEnum() : false)) {
            return false;
        }
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiElement psiElement = (PsiElement)psiFile;
        Function1 predicate$iv = (Function1)new Function1<PsiReferenceExpression, Boolean>((String)importedEnumQualifiedName){
            final /* synthetic */ String $importedEnumQualifiedName;
            {
                this.$importedEnumQualifiedName = $importedEnumQualifiedName;
                super(1, Intrinsics.Kotlin.class, "isQualifiedNameInEnumStaticMethods", "isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(Lcom/intellij/psi/PsiReference;Ljava/lang/String;)Z", 0);
            }

            public final Boolean invoke(PsiReferenceExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return K2UnusedSymbolUtil.access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods((PsiReference)p0, this.$importedEnumQualifiedName);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final KaSymbol resolveReferenceToSymbol(KaSession $context_receiver_0, KtImportDirective $this$resolveReferenceToSymbol) {
        KtReference ktReference;
        KtReferenceExpression ktReferenceExpression;
        if ($this$resolveReferenceToSymbol.getImportedReference() instanceof KtReferenceExpression) {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            ktReferenceExpression = (KtReferenceExpression)ktExpression;
        } else {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            if (ktExpression != null) {
                PsiElement $this$getChildOfType$iv = (PsiElement)ktExpression;
                boolean $i$f$getChildOfType = false;
                ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtReferenceExpression.class);
            } else {
                ktReferenceExpression = null;
            }
        }
        KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression;
        return ktReferenceExpression2 != null && (ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression2)) != null ? $context_receiver_0.resolveToSymbol(ktReference) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(KaSession $context_receiver_0, KtImportDirective $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$anyDescendantOfType$iv;
        void $this$mapTo$iv$iv;
        ImportPath importPath = $this$isUsedStarImportOfEnumStaticFunctions.getImportPath();
        if (!(importPath != null ? importPath.isAllUnder() : false)) {
            return false;
        }
        FqName fqName2 = $this$isUsedStarImportOfEnumStaticFunctions.getImportedFqName();
        if (fqName2 == null) {
            return false;
        }
        FqName importedEnumFqName = fqName2;
        KaSymbol kaSymbol = this.resolveReferenceToSymbol($context_receiver_0, $this$isUsedStarImportOfEnumStaticFunctions);
        KaClassSymbol kaClassSymbol = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol importedClass = kaClassSymbol;
        if (importedClass.getClassKind() != KaClassKind.ENUM_CLASS) {
            return false;
        }
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumFqName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        $this$map$iv = (PsiElement)psiFile;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$lambda$33($context_receiver_0, enumStaticMethods, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiImportStaticReferenceElement $this$isReferenceToBuiltInEnumFunction) {
        void $this$mapTo$iv$iv;
        String importedEnumQualifiedName = $this$isReferenceToBuiltInEnumFunction.getClassReference().getQualifiedName();
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumQualifiedName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        String string = $this$isReferenceToBuiltInEnumFunction.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return enumStaticMethods.contains(new FqName(string));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiReferenceExpression $this$isReferenceToBuiltInEnumFunction, KtClass enumClass) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isReferenceToBuiltInEnumFunction.resolve();
        if (!(psiElement instanceof KtLightMethod)) return false;
        KtLightMethod ktLightMethod = (KtLightMethod)psiElement;
        if (ktLightMethod == null) {
            return false;
        }
        KtLightMethod reference2 = ktLightMethod;
        if (!Intrinsics.areEqual((Object)((KtLightClass)reference2.getContainingClass()).getName(), (Object)enumClass.getName())) return false;
        if (!(reference2 instanceof SyntheticElement)) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!((List)destination$iv$iv).contains(reference2.getName())) return false;
        return true;
    }

    private final boolean canBeHandledByLightMethods(KaSession $context_receiver_0, KtCallableDeclaration $this$canBeHandledByLightMethods, KaDeclarationSymbol symbol) {
        boolean bl;
        if (symbol instanceof KaConstructorSymbol) {
            KaDeclarationSymbol kaDeclarationSymbol = $context_receiver_0.getContainingDeclaration(symbol);
            KaNamedClassSymbol kaNamedClassSymbol = kaDeclarationSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaDeclarationSymbol : null;
            if (kaNamedClassSymbol == null) {
                return false;
            }
            KaNamedClassSymbol classSymbol = kaNamedClassSymbol;
            bl = !classSymbol.isInline() && classSymbol.getVisibility() != KaSymbolVisibility.PRIVATE;
        } else {
            bl = $this$canBeHandledByLightMethods.hasModifier(KtTokens.INTERNAL_KEYWORD) ? false : (!(symbol instanceof KaNamedFunctionSymbol) ? true : !this.hasInlineClassParameters($context_receiver_0, (KaNamedFunctionSymbol)symbol));
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInlineClassParameters(KaSession $context_receiver_0, KaNamedFunctionSymbol $this$hasInlineClassParameters) {
        boolean bl;
        boolean bl2;
        KaNamedClassSymbol receiverParameterClassSymbol;
        KaType kaType = KaCallableSymbolKt.getReceiverType($this$hasInlineClassParameters);
        KaClassSymbol kaClassSymbol = kaType != null ? $context_receiver_0.getExpandedSymbol(kaType) : null;
        KaNamedClassSymbol kaNamedClassSymbol = receiverParameterClassSymbol = kaClassSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol : null;
        if (kaNamedClassSymbol != null) {
            if (kaNamedClassSymbol.isInline()) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Iterable $this$any$iv = $this$hasInlineClassParameters.getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            KaNamedClassSymbol namedClassOrObjectSymbol;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KaValueParameterSymbol it = (KaValueParameterSymbol)element$iv;
            boolean bl3 = false;
            KaClassSymbol kaClassSymbol2 = $context_receiver_0.getExpandedSymbol(it.getReturnType());
            if ((kaClassSymbol2 instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol2 : null) == null) {
                bl = false;
                continue;
            }
            namedClassOrObjectSymbol = namedClassOrObjectSymbol;
            bl = namedClassOrObjectSymbol.isInline();
        } while (!bl);
        return true;
    }

    private final boolean hasOverrides(KtNamedDeclaration declaration, SearchScope useScope) {
        Sequence<PsiElement> overrides2;
        KtNamedDeclaration ktNamedDeclaration = declaration;
        Sequence<PsiElement> sequence = overrides2 = ktNamedDeclaration instanceof KtCallableDeclaration ? KotlinSearchUtilKt.findAllOverridings((KtCallableDeclaration)declaration, useScope) : (ktNamedDeclaration instanceof KtClass ? KotlinSearchUtilKt.findAllInheritors((KtClass)declaration, useScope) : null);
        return (sequence != null ? (PsiElement)SequencesKt.firstOrNull(sequence) : null) != null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFakeOverrides(KaSession $context_receiver_0, KtNamedDeclaration declaration, SearchScope useScope, KaDeclarationSymbol symbol) {
        boolean bl;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
        if (!(ktClassOrObject instanceof KtClass)) return false;
        KtClass ktClass = (KtClass)ktClassOrObject;
        if (ktClass == null) {
            return false;
        }
        KtClass ownerClass = ktClass;
        if (!KotlinPsiUtilsKt.isInheritable(ownerClass)) {
            return false;
        }
        if (!(symbol instanceof KaCallableSymbol)) return false;
        KaCallableSymbol kaCallableSymbol = (KaCallableSymbol)symbol;
        if (kaCallableSymbol == null) {
            return false;
        }
        KaCallableSymbol callableSymbol = kaCallableSymbol;
        if (callableSymbol.getModality() == KaSymbolModality.ABSTRACT) {
            return false;
        }
        Sequence<PsiElement> $this$any$iv = KotlinSearchUtilKt.findAllInheritors(ownerClass, useScope);
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object object;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            PsiElement element = (PsiElement)element$iv;
            boolean bl2 = false;
            PsiElement psiElement = element;
            if (psiElement instanceof KtClassOrObject) {
                KaCallableSymbol kaCallableSymbol2;
                Sequence sequence;
                Object object2;
                Object object3 = $context_receiver_0.getClassSymbol((KtClassOrObject)element);
                if (object3 == null || (object = $context_receiver_0.getMemberScope((KaDeclarationContainerSymbol)object3)) == null || (object2 = object.callables((Function1<? super Name, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasFakeOverrides$lambda$43$lambda$37(callableSymbol, arg_0)))) == null || (sequence = SequencesKt.filter(object2, arg_0 -> K2UnusedSymbolUtil.hasFakeOverrides$lambda$43$lambda$38($context_receiver_0, callableSymbol, arg_0))) == null || (kaCallableSymbol2 = (KaCallableSymbol)SequencesKt.singleOrNull((Sequence)sequence)) == null) {
                    bl = false;
                    continue;
                }
                KaCallableSymbol overridingCallableSymbol = kaCallableSymbol2;
                if (!Intrinsics.areEqual((Object)overridingCallableSymbol, (Object)callableSymbol)) {
                    boolean bl3;
                    void $this$any$iv2;
                    object3 = $context_receiver_0.getIntersectionOverriddenSymbols(overridingCallableSymbol);
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl3 = false;
                    } else {
                        object2 = $this$any$iv2.iterator();
                        while (object2.hasNext()) {
                            Object element$iv2 = object2.next();
                            KaCallableSymbol it = (KaCallableSymbol)element$iv2;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)callableSymbol)) {
                                return true;
                            }
                            boolean bl5 = false;
                            if (!bl5) continue;
                            return true;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        return true;
                    }
                }
                bl = false;
                continue;
            }
            if (psiElement instanceof PsiClass) {
                Iterable $this$any$iv3 = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration));
                boolean $i$f$any3 = false;
                if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                    bl = false;
                    continue;
                }
                object = $this$any$iv3.iterator();
                while (object.hasNext()) {
                    boolean bl6;
                    PsiMethod it;
                    PsiMethod element$iv3;
                    int n;
                    int n2;
                    PsiMethod[] sameMethods;
                    PsiMethod lightMethod;
                    block21: {
                        Object element$iv4 = object.next();
                        lightMethod = (PsiMethod)element$iv4;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiClass)element).findMethodsBySignature(lightMethod, true), (String)"findMethodsBySignature(...)");
                        PsiMethod[] $this$all$iv = sameMethods;
                        boolean $i$f$all = false;
                        n2 = $this$all$iv.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv3 = $this$all$iv[n];
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual((Object)it.getContainingClass(), (Object)element)) continue;
                            bl6 = false;
                            break block21;
                        }
                        bl6 = true;
                    }
                    if (bl6) {
                        PsiMethod[] $this$any$iv4 = sameMethods;
                        boolean $i$f$any4 = false;
                        n2 = $this$any$iv4.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv3 = $this$any$iv4[n];
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual((Object)it.getContainingClass(), (Object)lightMethod.getContainingClass())) {
                                return true;
                            }
                            boolean bl10 = false;
                            if (!bl10) continue;
                            return true;
                        }
                        boolean bl11 = false;
                        if (bl11) {
                            return true;
                        }
                    }
                    boolean bl12 = false;
                    if (!bl12) continue;
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean hasPlatformImplementations(KtNamedDeclaration declaration) {
        return PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration));
    }

    private final boolean classOrObjectHasTextUsages(KtClassOrObject classOrObject) {
        Ref.BooleanRef hasTextUsages = new Ref.BooleanRef();
        if (classOrObject.getUseScope() instanceof GlobalSearchScope) {
            Project project = classOrObject.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinFindClassUsagesHandler findClassUsagesHandler = new KotlinFindClassUsagesHandler(classOrObject, new KotlinFindUsagesHandlerFactory(project));
            findClassUsagesHandler.processUsagesInText((PsiElement)classOrObject, arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$45(arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$44(hasTextUsages, arg_0), arg_0), GlobalSearchScope.projectScope((Project)classOrObject.getProject()));
        }
        return hasTextUsages.element;
    }

    @NotNull
    public final LocalQuickFixAndIntentionActionOnPsiElement[] createQuickFixes(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtParameter) {
            if (((KtParameter)declaration).isLoopParameter()) {
                return new LocalQuickFixAndIntentionActionOnPsiElement[0];
            }
            if (((KtParameter)declaration).isCatchParameter()) {
                LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray;
                if (Intrinsics.areEqual((Object)((KtParameter)declaration).getName(), (Object)"_")) {
                    localQuickFixAndIntentionActionOnPsiElementArray = new LocalQuickFixAndIntentionActionOnPsiElement[]{};
                } else {
                    LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray2 = new LocalQuickFixAndIntentionActionOnPsiElement[]{new RenameElementFix((PsiNamedElement)declaration, "_")};
                    localQuickFixAndIntentionActionOnPsiElementArray = localQuickFixAndIntentionActionOnPsiElementArray2;
                }
                return localQuickFixAndIntentionActionOnPsiElementArray;
            }
            KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
            if (ownerFunction instanceof KtPropertyAccessor && ((KtPropertyAccessor)ownerFunction).isSetter()) {
                return new LocalQuickFixAndIntentionActionOnPsiElement[0];
            }
        }
        LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray = new LocalQuickFixAndIntentionActionOnPsiElement[]{new SafeDeleteFix(declaration)};
        return localQuickFixAndIntentionActionOnPsiElementArray;
    }

    private final boolean isEntryPoint(KaSession $context_receiver_0, KtNamedDeclaration declaration, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, UnusedDeclarationInspectionBase isJavaEntryPoint) {
        PsiElement psiElement;
        if (this.hasKotlinAdditionalAnnotation($context_receiver_0, (KtDeclaration)declaration)) {
            return true;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtClass) {
            boolean bl;
            block22: {
                Iterable $this$any$iv = ((KtClass)declaration).getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.hasKotlinAdditionalAnnotation($context_receiver_0, it)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtObjectDeclaration) {
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            if (KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)declaration, null, 2, null)) {
                return true;
            }
            KtNamedDeclaration ktNamedDeclaration2 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration2);
        } else if (ktNamedDeclaration instanceof KtSecondaryConstructor) {
            KtNamedDeclaration ktNamedDeclaration3 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration3);
        } else {
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
                if (declaration instanceof KtParameter) {
                    KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
                    if (ownerFunction instanceof KtNamedFunction && KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)ownerFunction, null, 2, null)) {
                        return AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)ownerFunction, new ClassId(new FqName("kotlin.jvm"), new FqName("JvmStatic"), false), null, false, 6, null) != null;
                    }
                    if (!((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                }
                if (declaration instanceof KtParameter && this.isAnnotationParameter((KtParameter)declaration)) {
                    List lightAnnotationMethods = CollectionsKt.toList((Iterable)((Iterable)LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)declaration)));
                    for (PsiMethod javaParameterPsi : lightAnnotationMethods) {
                        if (!isJavaEntryPoint.isEntryPoint((PsiElement)javaParameterPsi)) continue;
                        return true;
                    }
                }
                EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)declaration.getProject());
                Intrinsics.checkNotNull((Object)entryPointsManager, (String)"null cannot be cast to non-null type com.intellij.codeInspection.ex.EntryPointsManagerBase");
                EntryPointsManagerBase entryPointsManager2 = (EntryPointsManagerBase)entryPointsManager;
                Collection collection = entryPointsManager2.getAdditionalAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAdditionalAnnotations(...)");
                JDOMExternalizableStringList jDOMExternalizableStringList = entryPointsManager2.ADDITIONAL_ANNOTATIONS;
                Intrinsics.checkNotNullExpressionValue((Object)jDOMExternalizableStringList, (String)"ADDITIONAL_ANNOTATIONS");
                return this.checkAnnotatedUsingPatterns($context_receiver_0, declaration, CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)jDOMExternalizableStringList)));
            }
            return false;
        }
        if (psiElement == null) {
            return false;
        }
        PsiElement lightElement = psiElement;
        if (isCheapEnough.getValue() == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return isJavaEntryPoint.isEntryPoint(lightElement);
    }

    private static final PsiSearchHelper.SearchCostResult getPsiToReportProblem$lambda$0(KtNamedDeclaration $declaration) {
        return INSTANCE.isCheapEnoughToSearchUsages($declaration);
    }

    private static final boolean isCheapEnoughToSearchUsages$lambda$3(Project $project, KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DefaultScriptingSupport.Companion.getInstance($project).isLoadedFromCache(it);
    }

    private static final PsiSearchHelper.SearchCostResult hasNonTrivialUsages$lambda$11(KtNamedDeclaration $declaration) {
        return INSTANCE.isCheapEnoughToSearchUsages($declaration);
    }

    private static final boolean hasReferences$lambda$20$lambda$19(KaSession $$context_receiver_0, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, PsiReference it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.checkReference($$context_receiver_0, it, $declaration, $originalDeclaration);
    }

    private static final boolean hasReferences$lambda$22(KaSession $$context_receiver_0, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, PsiReference it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.checkReference($$context_receiver_0, it, $declaration, $originalDeclaration);
    }

    private static final Unit checkPrivateDeclaration$lambda$23(HashSet $setOfImportedDeclarations, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$setOfImportedDeclarations).add(it);
        return Unit.INSTANCE;
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$28(KtClass $enumClass, KaSession $$context_receiver_0, KtCallableReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReceiverExpression() == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($$context_receiver_0, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$29(KtClass $enumClass, KaSession $$context_receiver_0, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it.getParent() instanceof KtCallableReferenceExpression) && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && INSTANCE.isReferenceToBuiltInEnumEntries($$context_receiver_0, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$30(KtClass $enumClass, KaSession $$context_receiver_0, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($$context_receiver_0, it);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods, String importedEnumQualifiedName) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods.resolve();
        if (!(psiElement instanceof PsiMember)) return false;
        PsiMember psiMember = (PsiMember)psiElement;
        if (psiMember == null) {
            return false;
        }
        PsiMember referenceExpression = psiMember;
        PsiClass psiClass = referenceExpression.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? JavaPsiUtils.getKotlinFqName((PsiElement)psiClass) : null), (Object)new FqName(importedEnumQualifiedName))) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)referenceExpression.getName())) return false;
        return true;
    }

    private static final boolean isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods(KtExpression $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods, KaSession $$context_receiver_0, List<FqName> enumStaticMethods) {
        if (KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods)) != null) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression = $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods : null;
        PsiElement psiElement = ktNameReferenceExpression != null ? ktNameReferenceExpression.getParent() : null;
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if ((ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getReceiverExpression() : null) != null) {
            return false;
        }
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods));
        KaSymbol kaSymbol = ktReference != null ? $$context_receiver_0.resolveToSymbol(ktReference) : null;
        KaCallableSymbol kaCallableSymbol = kaSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)kaSymbol : null;
        if (kaCallableSymbol == null) {
            return false;
        }
        KaCallableSymbol symbol = kaCallableSymbol;
        CallableId callableId = symbol.getCallableId();
        return CollectionsKt.contains((Iterable)enumStaticMethods, (Object)(callableId != null ? callableId.asSingleFqName() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$lambda$33(KaSession $$context_receiver_0, List $enumStaticMethods, KtExpression it) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtCallExpression ktCallExpression = it instanceof KtCallExpression ? (KtCallExpression)it : null;
        if (ktCallExpression != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallExpression, $$context_receiver_0, $enumStaticMethods)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        KtCallableReferenceExpression ktCallableReferenceExpression = it instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)it : null;
        if (ktCallableReferenceExpression != null && (ktCallableReferenceExpression = ktCallableReferenceExpression.getCallableReference()) != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallableReferenceExpression, $$context_receiver_0, $enumStaticMethods)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(it instanceof KtReferenceExpression)) return false;
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)it;
        if (ktReferenceExpression == null) return false;
        if (!K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktReferenceExpression, $$context_receiver_0, $enumStaticMethods)) return false;
        return true;
    }

    private static final boolean hasFakeOverrides$lambda$43$lambda$37(KaCallableSymbol $callableSymbol, Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CallableId callableId = $callableSymbol.getCallableId();
        return Intrinsics.areEqual((Object)name2, (Object)(callableId != null ? callableId.getCallableName() : null));
    }

    private static final boolean hasFakeOverrides$lambda$43$lambda$38(KaSession $$context_receiver_0, KaCallableSymbol $callableSymbol, KaCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)$$context_receiver_0.getFakeOverrideOriginal(it), (Object)$callableSymbol);
    }

    private static final boolean classOrObjectHasTextUsages$lambda$44(Ref.BooleanRef $hasTextUsages, UsageInfo it) {
        $hasTextUsages.element = true;
        return false;
    }

    private static final boolean classOrObjectHasTextUsages$lambda$45(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $receiver, String importedEnumQualifiedName) {
        return K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods($receiver, importedEnumQualifiedName);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.test.*", "kotlin.js.JsExport"};
        KOTLIN_ADDITIONAL_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiSearchHelper.SearchCostResult.values().length];
            try {
                nArray[PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

