/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionsBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceStringInDocumentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "oldString", "", "newString", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/String;)V", "elementRef", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "kotlin.inspections"})
public final class ReplaceStringInDocumentFix
implements LocalQuickFix {
    @NotNull
    private final String oldString;
    @NotNull
    private final String newString;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementRef;

    public ReplaceStringInDocumentFix(@NotNull PsiElement element, @NotNull String oldString, @NotNull String newString) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)oldString, (String)"oldString");
        Intrinsics.checkNotNullParameter((Object)newString, (String)"newString");
        this.oldString = oldString;
        this.newString = newString;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.elementRef = smartPsiElementPointer;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = this.elementRef.getElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile virtualFile = psiFile;
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        String text = element.getText();
        Intrinsics.checkNotNull((Object)text);
        int index2 = StringsKt.indexOf$default((CharSequence)text, (String)this.oldString, (int)0, (boolean)false, (int)6, null);
        if (index2 < 0) {
            return;
        }
        int start2 = element.getTextOffset() + index2;
        int end = start2 + this.oldString.length();
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        if (end > documentText.length()) {
            return;
        }
        String string2 = documentText.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)this.oldString)) {
            return;
        }
        document2.replaceString(start2, end, (CharSequence)this.newString);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.oldString, this.newString};
        return KotlinInspectionsBundle.message("replace.0.with.1", objectArray);
    }
}

