/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.AllProcessingsKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.UtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.NamedPostProcessingGroup;
import org.jetbrains.kotlin.j2k.PostProcessing;
import org.jetbrains.kotlin.j2k.PostProcessingKt;
import org.jetbrains.kotlin.j2k.PostProcessingTarget;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J6\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u001a\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor;", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "<init>", "()V", "insertImport", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "phasesCount", "", "getPhasesCount", "()I", "doAdditionalProcessing", "target", "Lorg/jetbrains/kotlin/j2k/PostProcessingTarget;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "onPhaseChanged", "Lkotlin/Function2;", "", "commitFile", "Companion", "kotlin.j2k.k1.new.post-processing"})
@SourceDebugExtension(value={"SMAP\nNewJ2kPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewJ2kPostProcessor.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1863#2,2:61\n1863#2,2:63\n1#3:65\n*S KotlinDebug\n*F\n+ 1 NewJ2kPostProcessor.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor\n*L\n44#1:61,2\n48#1:63,2\n*E\n"})
public final class NewJ2kPostProcessor
implements PostProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int phasesCount = AllProcessingsKt.getAllProcessings().size();
    @NotNull
    private static final Logger LOG;

    @Override
    public void insertImport(@NotNull KtFile file, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        UtilsKt.runUndoTransparentActionInEdt(true, (Function0<Unit>)((Function0)() -> NewJ2kPostProcessor.insertImport$lambda$1(file, fqName2)));
    }

    @Override
    public int getPhasesCount() {
        return this.phasesCount;
    }

    @Override
    public void doAdditionalProcessing(@NotNull PostProcessingTarget target, @Nullable ConverterContext converterContext, @Nullable Function2<? super Integer, ? super String, Unit> onPhaseChanged) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(converterContext instanceof NewJ2kConverterContext)) {
            throw new IllegalStateException("Invalid converter context for new J2K".toString());
        }
        Iterator iterator2 = ((Iterable)AllProcessingsKt.getAllProcessings()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            NamedPostProcessingGroup group = (NamedPostProcessingGroup)iterator2.next();
            ProgressManager.checkCanceled();
            Function2<? super Integer, ? super String, Unit> function2 = onPhaseChanged;
            if (function2 != null) {
                function2.invoke((Object)i2, (Object)group.getDescription());
            }
            for (PostProcessing processing : group.getProcessings()) {
                ProgressManager.checkCanceled();
                try {
                    PostProcessingKt.runProcessingConsideringOptions(processing, target, (NewJ2kConverterContext)converterContext);
                    Iterable $this$forEach$iv = PostProcessingKt.files(target);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean $i$f$doAdditionalProcessing$stub_for_inlining = false;
                        boolean bl = false;
                        this.commitFile(p0);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Iterable $this$forEach$iv = PostProcessingKt.files(target);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean $i$f$doAdditionalProcessing$stub_for_inlining$2 = false;
                        boolean bl = false;
                        this.commitFile(p0);
                    }
                    LOG.error(t);
                }
            }
        }
    }

    private final void commitFile(KtFile file) {
        UtilsKt.runUndoTransparentActionInEdt(true, (Function0<Unit>)((Function0)() -> NewJ2kPostProcessor.commitFile$lambda$3(file)));
    }

    private static final Unit insertImport$lambda$1(KtFile $file, FqName $fqName) {
        block0: {
            Collection<DeclarationDescriptor> descriptors = ResolutionUtils.resolveImportReference($file, $fqName);
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)descriptors);
            if (declarationDescriptor == null) break block0;
            DeclarationDescriptor it = declarationDescriptor;
            boolean bl = false;
            Project project = $file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project), $file, it, false, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit commitFile$lambda$3(KtFile $file) {
        DocumentUtilsKt.commitAndUnblockDocument((PsiFile)$file);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance((String)"@org.jetbrains.kotlin.idea.j2k.post.processings.NewJ2kPostProcessor");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.j2k.k1.new.post-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

