/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionsFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.util.PropertyUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.CreateKotlinCallableAction;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.CreateKotlinCallableActionTextBuilder;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.CreateMethodFromKotlinUsageRequest;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.K2CreateFunctionFromUsageUtil;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.K2CreatePropertyFromUsageBuilder;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.K2ElementActionsFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/K2ElementActionsFactory;", "Lcom/intellij/lang/jvm/actions/JvmElementActionsFactory;", "<init>", "()V", "createChangeModifierActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "target", "Lcom/intellij/lang/jvm/JvmModifiersOwner;", "request", "Lcom/intellij/lang/jvm/actions/ChangeModifierRequest;", "createAddMethodActions", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "createAddAnnotationActions", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "createAddFieldActions", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "kotlin.code-insight.k2"})
public final class K2ElementActionsFactory
extends JvmElementActionsFactory {
    @NotNull
    public List<IntentionAction> createChangeModifierActions(@NotNull JvmModifiersOwner target, @NotNull ChangeModifierRequest request) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PsiElement psiElement = target.getSourceElement();
        PsiElement psiElement2 = psiElement != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement) : null;
        KtModifierListOwner ktModifierListOwner = psiElement2 instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement2 : null;
        if (ktModifierListOwner == null) {
            return CollectionsKt.emptyList();
        }
        KtModifierListOwner kModifierOwner = ktModifierListOwner;
        if (request.getModifier() == JvmModifier.FINAL && !request.shouldBePresent()) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
            return CollectionsKt.listOf((Object)new AddModifierFix(kModifierOwner, ktModifierKeywordToken));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<IntentionAction> createAddMethodActions(@NotNull JvmClass targetClass, @NotNull CreateMethodRequest request) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (targetClass instanceof PsiElement && !BaseIntentionAction.canModify((PsiElement)((PsiElement)targetClass))) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement = K2CreateFunctionFromUsageUtil.INSTANCE.toKtClassOrFile(targetClass);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement container = ktElement;
        if (request instanceof CreateMethodFromKotlinUsageRequest) {
            if (((CreateMethodFromKotlinUsageRequest)request).isExtension()) {
                container = (KtElement)container.getContainingKtFile();
            }
            String actionText = CreateKotlinCallableActionTextBuilder.INSTANCE.build(KotlinBundle.message((String)"text.function", (Object[])new Object[0]), (CreateMethodFromKotlinUsageRequest)request);
            list2 = CollectionsKt.listOf((Object)new CreateKotlinCallableAction(request, targetClass, K2ElementActionsFactoryKt.access$isAbstractClass(container), !((CreateMethodFromKotlinUsageRequest)request).isAbstractClassOrInterface(), actionText, SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)container))));
        } else {
            boolean isContainerAbstract;
            Object[] objectArray = new Object[]{request.getMethodName(), String.valueOf(targetClass.getName())};
            list2 = CollectionsKt.listOf((Object)new CreateKotlinCallableAction(request, targetClass, isContainerAbstract, !(isContainerAbstract = K2ElementActionsFactoryKt.access$isAbstractClass(container)) && !KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)container), KotlinBundle.message((String)"add.method.0.to.1", (Object[])objectArray), SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)container))));
        }
        return list2;
    }

    @NotNull
    public List<IntentionAction> createAddAnnotationActions(@NotNull JvmModifiersOwner target, @NotNull AnnotationRequest request) {
        Object object;
        KtElement ktElement;
        block4: {
            block3: {
                KtModifierListOwner ktModifierListOwner;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                KtLightElement ktLightElement = target instanceof KtLightElement ? (KtLightElement)target : null;
                ktElement = ktLightElement != null ? ktLightElement.getKotlinOrigin() : null;
                object = ktElement instanceof KtModifierListOwner ? (KtModifierListOwner)ktElement : null;
                if (object == null) break block3;
                KtModifierListOwner it = ktModifierListOwner = object;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getLanguage(), (Object)KotlinLanguage.INSTANCE) ? ktModifierListOwner : null;
                if (object != null) break block4;
            }
            return CollectionsKt.emptyList();
        }
        KtModifierListOwner declaration = object;
        ktElement = target;
        AnnotationUseSiteTarget annotationUseSiteTarget = ktElement instanceof JvmField ? AnnotationUseSiteTarget.FIELD : (ktElement instanceof JvmMethod ? (PropertyUtil.isSimplePropertySetter((PsiMethod)(target instanceof PsiMethod ? (PsiMethod)target : null)) ? AnnotationUseSiteTarget.PROPERTY_SETTER : (PropertyUtil.isSimplePropertyGetter((PsiMethod)(target instanceof PsiMethod ? (PsiMethod)target : null)) ? AnnotationUseSiteTarget.PROPERTY_GETTER : null)) : null);
        return CollectionsKt.listOfNotNull((Object)K2CreatePropertyFromUsageBuilder.INSTANCE.generateAnnotationAction(declaration, annotationUseSiteTarget, request));
    }

    @NotNull
    public List<IntentionAction> createAddFieldActions(@NotNull JvmClass targetClass, @NotNull CreateFieldRequest request) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KtElement ktElement = K2CreateFunctionFromUsageUtil.INSTANCE.toKtClassOrFile(targetClass);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement targetContainer = ktElement;
        boolean writable = !request.getModifiers().contains(JvmModifier.FINAL) && !request.isConstant();
        IntentionAction action = K2CreatePropertyFromUsageBuilder.INSTANCE.generatePropertyAction(targetContainer, targetClass.getName(), request, false);
        if (writable) {
            Object[] objectArray = new IntentionAction[]{action, K2CreatePropertyFromUsageBuilder.INSTANCE.generatePropertyAction(targetContainer, targetClass.getName(), request, true)};
            list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            list2 = CollectionsKt.listOfNotNull((Object)action);
        }
        List actions = list2;
        return actions;
    }
}

