/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.types.KaDefinitelyNotNullType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a$\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u0013"}, d2={"areTypeArgumentsRedundant", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "approximateFlexible", "buildCallExpressionWithoutTypeArgs", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "element", "findContextToAnalyze", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "areTypeArgumentsEqual", "originalCallExpression", "newCallExpression", "areTypesEqual", "type1", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "type2", "kotlin.refactorings.k2"})
@SourceDebugExtension(value={"SMAP\nRedundantExplicitTypeArgumentsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantExplicitTypeArgumentsUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/util/RedundantExplicitTypeArgumentsUtilKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n66#2,2:94\n1734#3,3:96\n*S KotlinDebug\n*F\n+ 1 RedundantExplicitTypeArgumentsUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/util/RedundantExplicitTypeArgumentsUtilKt\n*L\n44#1:94,2\n73#1:96,3\n*E\n"})
public final class RedundantExplicitTypeArgumentsUtilKt {
    public static final boolean areTypeArgumentsRedundant(@NotNull KaSession $this$areTypeArgumentsRedundant, @NotNull KtTypeArgumentList typeArgumentList, boolean approximateFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$areTypeArgumentsRedundant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeArgumentList, (String)"typeArgumentList");
        PsiElement psiElement = typeArgumentList.getParent();
        KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtCallExpression ktCallExpression2 = RedundantExplicitTypeArgumentsUtilKt.buildCallExpressionWithoutTypeArgs(callExpression);
        if (ktCallExpression2 == null) {
            return false;
        }
        KtCallExpression newCallExpression = ktCallExpression2;
        return RedundantExplicitTypeArgumentsUtilKt.areTypeArgumentsEqual($this$areTypeArgumentsRedundant, callExpression, newCallExpression, approximateFlexible);
    }

    public static /* synthetic */ boolean areTypeArgumentsRedundant$default(KaSession kaSession, KtTypeArgumentList ktTypeArgumentList, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return RedundantExplicitTypeArgumentsUtilKt.areTypeArgumentsRedundant(kaSession, ktTypeArgumentList, bl);
    }

    private static final KtCallExpression buildCallExpressionWithoutTypeArgs(KtCallExpression element) {
        KtCallExpression ktCallExpression;
        KtExpression ktExpression = RedundantExplicitTypeArgumentsUtilKt.findContextToAnalyze((KtExpression)element);
        if (ktExpression == null) {
            return null;
        }
        KtExpression context2 = ktExpression;
        KtTypeArgumentList ktTypeArgumentList = element.getTypeArgumentList();
        if (ktTypeArgumentList == null || (ktTypeArgumentList = ktTypeArgumentList.getTextRange()) == null) {
            return null;
        }
        KtTypeArgumentList typeArgumentListRange = ktTypeArgumentList;
        int contextStartOffset = FixersUtilKt.getStart((TextRange)FixersUtilKt.getRange((PsiElement)((PsiElement)context2)));
        String string = context2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = FixersUtilKt.getStart((TextRange)typeArgumentListRange) - contextStartOffset;
        int n2 = FixersUtilKt.getEnd((TextRange)typeArgumentListRange) - contextStartOffset;
        String textWithoutTypeArgs = ((Object)StringsKt.removeRange((CharSequence)string2, (int)n, (int)n2)).toString();
        string2 = !(context2.getParent() instanceof KtClassBody) ? TuplesKt.to((Object)"object Obj {", (Object)"}") : TuplesKt.to((Object)"", (Object)"");
        String prefix2 = (String)string2.component1();
        String suffix2 = (String)string2.component2();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtBlockCodeFragment codeFragment = new KtPsiFactory(project, false).createBlockCodeFragment(prefix2 + textWithoutTypeArgs + suffix2, (PsiElement)context2);
        PsiElement psiElement = codeFragment.findElementAt(FixersUtilKt.getStart((TextRange)typeArgumentListRange) + prefix2.length() - contextStartOffset);
        if (psiElement != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtCallExpression.class, (boolean)true);
        } else {
            ktCallExpression = null;
        }
        return ktCallExpression;
    }

    private static final KtExpression findContextToAnalyze(KtExpression expression) {
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)expression))) {
            PsiElement psiElement = element;
            if (psiElement instanceof KtFunctionLiteral || psiElement instanceof KtParameter || psiElement instanceof KtPropertyAccessor || !(psiElement instanceof KtProperty ? !(((KtProperty)element).getParent() instanceof KtClassBody) : (psiElement instanceof KtFunction ? !((KtFunction)element).hasModifier(KtTokens.OVERRIDE_KEYWORD) : psiElement instanceof KtDeclaration))) continue;
            return (KtExpression)element;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean areTypeArgumentsEqual(KaSession $this$areTypeArgumentsEqual, KtCallExpression originalCallExpression, KtCallExpression newCallExpression, boolean approximateFlexible) {
        KaType newType;
        Pair pair;
        KaType originalType;
        KaCallInfo kaCallInfo = $this$areTypeArgumentsEqual.resolveToCall((KtElement)originalCallExpression);
        Object object = kaCallInfo;
        if (kaCallInfo == null) return false;
        KaFunctionCall<?> kaFunctionCall = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)object);
        object = kaFunctionCall;
        if (kaFunctionCall == null) return false;
        if ((object = object.getTypeArgumentsMapping()) == null) {
            return false;
        }
        Object originalTypeArgs = object;
        KaCallInfo kaCallInfo2 = $this$areTypeArgumentsEqual.resolveToCall((KtElement)newCallExpression);
        Object object2 = kaCallInfo2;
        if (kaCallInfo2 == null) return false;
        KaFunctionCall<?> kaFunctionCall2 = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)object2);
        object2 = kaFunctionCall2;
        if (kaFunctionCall2 == null) return false;
        if ((object2 = object2.getTypeArgumentsMapping()) == null) {
            return false;
        }
        Object newTypeArgs = object2;
        if (originalTypeArgs.size() != newTypeArgs.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)originalTypeArgs.values(), (Iterable)newTypeArgs.values());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            pair = (Pair)element$iv;
            boolean bl = false;
        } while (RedundantExplicitTypeArgumentsUtilKt.areTypesEqual($this$areTypeArgumentsEqual, originalType = (KaType)pair.component1(), newType = (KaType)pair.component2(), approximateFlexible));
        return false;
    }

    private static final boolean areTypesEqual(KaSession $this$areTypesEqual, KaType type1, KaType type2, boolean approximateFlexible) {
        return type1 instanceof KaTypeParameterType && type2 instanceof KaTypeParameterType ? Intrinsics.areEqual((Object)((KaTypeParameterType)type1).getName(), (Object)((KaTypeParameterType)type2).getName()) : (type1 instanceof KaDefinitelyNotNullType && type2 instanceof KaDefinitelyNotNullType ? RedundantExplicitTypeArgumentsUtilKt.areTypesEqual($this$areTypesEqual, ((KaDefinitelyNotNullType)type1).getOriginal(), ((KaDefinitelyNotNullType)type2).getOriginal(), approximateFlexible) : (approximateFlexible || $this$areTypesEqual.getHasFlexibleNullability(type1) == $this$areTypesEqual.getHasFlexibleNullability(type2)) && KaTypeRelationChecker.semanticallyEquals$default($this$areTypesEqual, type1, type2, null, 2, null));
    }
}

