/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "isCommunity", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "pluginIds", "", "", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "dismissPluginSuggestion", "", "setupCommercialIdeSuggestion", "panel", "setupPluginSuggestion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1557#2:133\n1628#2,3:134\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion\n*L\n126#1:133\n126#1:134,3\n*E\n"})
public final class KotlinNotebookPluginSuggestion
implements PluginSuggestion {
    @NotNull
    private final Project project;
    private final boolean isCommunity;
    @NotNull
    private final List<String> pluginIds;

    public KotlinNotebookPluginSuggestion(@NotNull Project project, boolean isCommunity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isCommunity = isCommunity;
        this.pluginIds = CollectionsKt.listOf((Object)"org.jetbrains.plugins.kotlin.jupyter");
    }

    @NotNull
    public List<String> getPluginIds() {
        return this.pluginIds;
    }

    @NotNull
    public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel.Status status = this.isCommunity ? EditorNotificationPanel.Status.Promo : EditorNotificationPanel.Status.Info;
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, status);
        if (this.isCommunity) {
            this.setupCommercialIdeSuggestion(panel);
        } else {
            this.setupPluginSuggestion(panel);
        }
        panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> KotlinNotebookPluginSuggestion.apply$lambda$0(this));
        return panel;
    }

    private final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue("notebook.kotlin.suggestion.dismissed", true);
    }

    private final void setupCommercialIdeSuggestion(EditorNotificationPanel panel) {
        SuggestedIde suggestedIde = PluginAdvertiserService.Companion.getIde("IU");
        if (suggestedIde == null) {
            throw new IllegalStateException("Could not find IntelliJ Ultimate reference".toString());
        }
        SuggestedIde ultimateIde = suggestedIde;
        Object[] objectArray = new Object[]{"Kotlin Notebook (*.ipynb)", ultimateIde.getName()};
        panel.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])objectArray));
        PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel, (SuggestedIde)ultimateIde, (Project)this.project, (PluginId)PluginId.getId((String)"org.jetbrains.plugins.kotlin.jupyter"), null, (int)8, null);
    }

    private final void setupPluginSuggestion(EditorNotificationPanel panel) {
        Object[] objectArray = new Object[]{"Kotlin Notebook (*.ipynb)"};
        panel.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])objectArray));
        objectArray = new Object[]{"Kotlin Notebook"};
        panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugin.name", (Object[])objectArray), () -> KotlinNotebookPluginSuggestion.setupPluginSuggestion$lambda$2(this));
    }

    private static final void apply$lambda$0(KotlinNotebookPluginSuggestion this$0) {
        FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
        this$0.dismissPluginSuggestion();
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    private static final void setupPluginSuggestion$lambda$2$lambda$1(KotlinNotebookPluginSuggestion this$0) {
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupPluginSuggestion$lambda$2(KotlinNotebookPluginSuggestion this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FUSEventSource.EDITOR.logInstallPlugins(this$0.getPluginIds(), this$0.project);
        Iterable iterable = this$0.getPluginIds();
        Project project = this$0.project;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$setupPluginSuggestion$lambda$2$stub_for_inlining = false;
            collection.add(PluginId.getId((String)p0));
        }
        PluginsAdvertiser.installAndEnable$default((Project)project, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (boolean)true, (boolean)false, null, () -> KotlinNotebookPluginSuggestion.setupPluginSuggestion$lambda$2$lambda$1(this$0), (int)24, null);
    }
}

