/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"isKotlinFileType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isJavaFileType", "getAllFilesRecursively", "", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "kotlin.base.util"})
@JvmName(name="FileUtils")
public final class FileUtils {
    public static final boolean isKotlinFileType(@NotNull VirtualFile $this$isKotlinFileType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFileType, (String)"<this>");
        CharSequence charSequence = $this$isKotlinFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".class", (boolean)false, (int)2, null)) {
            return false;
        }
        return FileTypeRegistry.getInstance().isFileOfType($this$isKotlinFileType, (FileType)KotlinFileType.INSTANCE);
    }

    public static final boolean isJavaFileType(@NotNull VirtualFile $this$isJavaFileType) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFileType, (String)"<this>");
        CharSequence charSequence = $this$isJavaFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        return StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".java", (boolean)false, (int)2, null) || FileTypeRegistry.getInstance().isFileOfType($this$isJavaFileType, (FileType)JavaFileType.INSTANCE);
    }

    @NotNull
    public static final Collection<VirtualFile> getAllFilesRecursively(@NotNull VirtualFile[] filesOrDirs) {
        Intrinsics.checkNotNullParameter((Object)filesOrDirs, (String)"filesOrDirs");
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile file : filesOrDirs) {
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, optionArray){
                final /* synthetic */ ArrayList<VirtualFile> $result;
                {
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public boolean visitFile(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    this.$result.add(file);
                    return true;
                }
            }));
        }
        return result2;
    }
}

