/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Member;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.PropertyAccessor;
import org.jetbrains.kotlin.j2k.ast.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Property;", "Lorg/jetbrains/kotlin/j2k/ast/Member;", "identifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "isVar", "", "type", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "explicitType", "initializer", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "needInitializer", "getter", "Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;", "setter", "isInInterface", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Annotations;Lorg/jetbrains/kotlin/j2k/ast/Modifiers;ZLorg/jetbrains/kotlin/j2k/ast/Type;ZLorg/jetbrains/kotlin/j2k/ast/DeferredElement;ZLorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Z)V", "getIdentifier", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "()Z", "getType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "presentationModifiers", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class Property
extends Member {
    @NotNull
    private final Identifier identifier;
    private final boolean isVar;
    @NotNull
    private final Type type;
    private final boolean explicitType;
    @NotNull
    private final DeferredElement<Expression> initializer;
    private final boolean needInitializer;
    @Nullable
    private final PropertyAccessor getter;
    @Nullable
    private final PropertyAccessor setter;
    private final boolean isInInterface;

    public Property(@NotNull Identifier identifier, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, boolean isVar, @NotNull Type type2, boolean explicitType, @NotNull DeferredElement<Expression> initializer2, boolean needInitializer, @Nullable PropertyAccessor getter, @Nullable PropertyAccessor setter, boolean isInInterface) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(initializer2, (String)"initializer");
        super(annotations2, modifiers);
        this.identifier = identifier;
        this.isVar = isVar;
        this.type = type2;
        this.explicitType = explicitType;
        this.initializer = initializer2;
        this.needInitializer = needInitializer;
        this.getter = getter;
        this.setter = setter;
        this.isInInterface = isInInterface;
    }

    @NotNull
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    public final boolean isVar() {
        return this.isVar;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    private final Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, Boolean>)((Function1)Property::presentationModifiers$lambda$0));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Element initializerToUse;
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        ModifierKt.appendWithSpaceAfter(builder2.append(this.getAnnotations()), this.presentationModifiers()).append(this.isVar ? "var " : "val ").append(this.identifier);
        if (this.explicitType) {
            builder2.append(":").append(this.type);
        }
        if ((initializerToUse = (Element)this.initializer).isEmpty() && this.needInitializer) {
            Expression expression = UtilsKt.getDefaultInitializer(this);
            Element element = initializerToUse = expression != null ? (Element)expression : (Element)Element.Empty.INSTANCE;
        }
        if (!initializerToUse.isEmpty()) {
            builder2.append(" = ").append(initializerToUse);
        }
        if (this.getter != null) {
            builder2.append("\n").append(this.getter);
        }
        if (this.setter != null) {
            builder2.append("\n").append(this.setter);
        }
    }

    private static final boolean presentationModifiers$lambda$0(Modifier it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it != Modifier.OPEN;
    }
}

