/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.symbols.UtilsKt;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKSuperExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.types.JKJavaPrimitiveType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016R\u00020\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/EqualsOperatorConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;)Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "kotlin.j2k.shared"})
public final class EqualsOperatorConversion
extends RecursiveConversion {
    public EqualsOperatorConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull KaSession $context_receiver_0, @NotNull JKTreeElement element) {
        JKExpression right;
        JKExpression left;
        block11: {
            block10: {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof JKQualifiedExpression)) {
                    return this.recurse($context_receiver_0, element);
                }
                if (((JKQualifiedExpression)element).getReceiver() instanceof JKSuperExpression) {
                    return this.recurse($context_receiver_0, element);
                }
                JKExpression jKExpression = ((JKQualifiedExpression)element).getSelector();
                JKCallExpression jKCallExpression = jKExpression instanceof JKCallExpression ? (JKCallExpression)jKExpression : null;
                if (jKCallExpression == null) {
                    return this.recurse($context_receiver_0, element);
                }
                JKCallExpression selector2 = jKCallExpression;
                List<JKArgument> arguments2 = selector2.getArguments().getArguments();
                String functionFqName = UtilsKt.deepestFqName(selector2.getIdentifier());
                if (Intrinsics.areEqual((Object)functionFqName, (Object)"java.lang.Object.equals") && arguments2.size() == 1) {
                    pair = TuplesKt.to((Object)((JKQualifiedExpression)element).getReceiver(), (Object)arguments2.get(0).getValue());
                } else if (Intrinsics.areEqual((Object)functionFqName, (Object)"java.util.Objects.equals") && arguments2.size() == 2) {
                    pair = TuplesKt.to((Object)arguments2.get(0).getValue(), (Object)arguments2.get(1).getValue());
                } else {
                    return this.recurse($context_receiver_0, element);
                }
                Pair pair2 = pair;
                left = (JKExpression)pair2.component1();
                right = (JKExpression)pair2.component2();
                JKType jKType = left.calculateType(this.getTypeFactory());
                JKJavaPrimitiveType leftType = jKType != null ? TypesUtilsKt.asPrimitiveType(jKType) : null;
                JKType jKType2 = right.calculateType(this.getTypeFactory());
                JKJavaPrimitiveType rightType = jKType2 != null ? TypesUtilsKt.asPrimitiveType(jKType2) : null;
                JKJavaPrimitiveType jKJavaPrimitiveType = leftType;
                if (jKJavaPrimitiveType != null ? TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType) : false) break block10;
                JKJavaPrimitiveType jKJavaPrimitiveType2 = rightType;
                boolean bl = jKJavaPrimitiveType2 != null ? TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType2) : false;
                if (!bl) break block11;
            }
            return this.recurse($context_receiver_0, element);
        }
        JKElement jKElement = left.getParent();
        Intrinsics.checkNotNull((Object)jKElement);
        left.detach(jKElement);
        JKElement jKElement2 = right.getParent();
        Intrinsics.checkNotNull((Object)jKElement2);
        right.detach(jKElement2);
        JKParenthesizedExpression result2 = (JKParenthesizedExpression)FormattingKt.withFormattingFrom((JKFormattingOwner)ExpressionsKt.parenthesize(ExpressionsKt.equalsExpression(left, right, this.getTypeFactory())), (JKFormattingOwner)element);
        return this.recurse($context_receiver_0, (JKTreeElement)result2);
    }
}

