/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Compressor;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.artifactResolver.MavenArtifactResolvedM31RtMarker;
import org.jetbrains.idea.maven.artifactResolver.common.MavenModuleMap;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenExternalParameters {
    private static final Logger LOG = Logger.getInstance(MavenExternalParameters.class);
    public static final String MAVEN_LAUNCHER_CLASS = "org.codehaus.classworlds.Launcher";
    @NonNls
    public static final String MAVEN_OPTS = "MAVEN_OPTS";

    public static JavaParameters createJavaParameters(@NotNull Project project, @NotNull MavenRunnerParameters parameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable MavenRunConfiguration runConfiguration) throws ExecutionException {
        String mavenHome;
        String mavenVersion;
        if (project == null) {
            MavenExternalParameters.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            MavenExternalParameters.$$$reportNull$$$0(1);
        }
        JavaParameters params = new JavaParameters();
        if (coreSettings == null) {
            coreSettings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        }
        if ((mavenVersion = MavenUtil.getMavenVersion(mavenHome = MavenExternalParameters.resolveMavenHome(coreSettings, project, parameters.getWorkingDirPath(), runConfiguration))) == null) {
            throw new ExecutionException(MavenProjectBundle.message("dialog.message.maven.home.directory.invalid", mavenHome));
        }
        if (runnerSettings == null) {
            runnerSettings = MavenRunner.getInstance(project).getState();
        }
        params.getProgramParametersList().patchMacroWithEnvs(runnerSettings.getEnvironmentProperties());
        params.setWorkingDirectory(ProgramParametersUtil.expandPathAndMacros((String)parameters.getWorkingDirPath(), null, (Project)project));
        String jreName = runnerSettings.getJreName();
        boolean isGlobalRunnerSettings = MavenRunner.getInstance(project).getState() == runnerSettings;
        Sdk jdk = (Sdk)ReadAction.compute(() -> MavenExternalParameters.getJdk(project, jreName, isGlobalRunnerSettings));
        params.setJdk(jdk);
        if (!MavenUtil.verifyMavenSdkRequirements(jdk, mavenVersion)) {
            throw new ExecutionException(RunnerBundle.message("maven.3.3.1.bad.jdk", new Object[0]));
        }
        params.getProgramParametersList().addProperty("idea.version", MavenUtil.getIdeaVersionToPassToMavenProcess());
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3") >= 0) {
            String mavenMultimoduleDir = !StringUtil.isEmptyOrSpaces((String)parameters.getMultimoduleDir()) ? ProgramParametersUtil.expandPathAndMacros((String)parameters.getMultimoduleDir(), null, (Project)project) : MavenServerUtil.findMavenBasedir((File)parameters.getWorkingDirFile()).getPath();
            params.getVMParametersList().addProperty("maven.multiModuleProjectDirectory", mavenMultimoduleDir);
        }
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.5") >= 0) {
            params.getVMParametersList().addProperty("jansi.passthrough", "true");
        }
        String vmOptions = MavenExternalParameters.getRunVmOptions(runnerSettings, project, parameters.getWorkingDirPath());
        vmOptions = ProgramParametersUtil.expandPathAndMacros((String)vmOptions, null, (Project)project);
        MavenExternalParameters.addVMParameters(params.getVMParametersList(), mavenHome, vmOptions);
        File confFile = MavenUtil.getMavenConfFile(new File(mavenHome));
        if (!confFile.isFile()) {
            throw new ExecutionException(MavenProjectBundle.message("dialog.message.configuration.file.not.exists.in.maven.home", confFile.getAbsolutePath()));
        }
        if (parameters.isResolveToWorkspace()) {
            try {
                String resolverJar = MavenExternalParameters.getArtifactResolverJar(mavenVersion);
                confFile = MavenExternalParameters.patchConfFile(confFile, resolverJar);
                File modulesPathsFile = MavenExternalParameters.dumpModulesPaths(project);
                params.getVMParametersList().addProperty("idea.modules.paths.file", modulesPathsFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                throw new ExecutionException(MavenProjectBundle.message("dialog.message.failed.to.run.maven.configuration", new Object[0]), (Throwable)e);
            }
        }
        params.getVMParametersList().addProperty("classworlds.conf", confFile.getPath());
        for (String path : MavenExternalParameters.getMavenClasspathEntries(mavenHome)) {
            params.getClassPath().add(path);
        }
        params.setEnv(new HashMap<String, String>(runnerSettings.getEnvironmentProperties()));
        params.setPassParentEnvs(runnerSettings.isPassParentEnv());
        params.setMainClass(MAVEN_LAUNCHER_CLASS);
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        params.setCharset(encodingManager.getDefaultCharset());
        MavenExternalParameters.addMavenParameters(params.getProgramParametersList(), mavenHome, coreSettings, runnerSettings, parameters);
        MavenUtil.addEventListener(mavenVersion, (SimpleJavaParameters)params);
        return params;
    }

    @Nullable
    static String getRunVmOptions(@Nullable MavenRunnerSettings runnerSettings, @Nullable Project project, @NotNull String workingDirPath) {
        if (workingDirPath == null) {
            MavenExternalParameters.$$$reportNull$$$0(2);
        }
        if (runnerSettings != null && !StringUtil.isEmptyOrSpaces((String)runnerSettings.getVmOptions())) {
            return runnerSettings.getVmOptions();
        }
        if (project == null) {
            return null;
        }
        return MavenExternalParameters.readJvmConfigOptions(workingDirPath);
    }

    @NotNull
    public static String readJvmConfigOptions(@NotNull String workingDirPath) {
        if (workingDirPath == null) {
            MavenExternalParameters.$$$reportNull$$$0(3);
        }
        String string = Optional.ofNullable(MavenExternalParameters.getJvmConfig(workingDirPath)).map(jdkOpts -> MavenExternalParameters.toVmString(jdkOpts)).orElse("");
        if (string == null) {
            MavenExternalParameters.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getJvmConfig(@NotNull String workingDirPath) {
        if (workingDirPath == null) {
            MavenExternalParameters.$$$reportNull$$$0(5);
        }
        return Optional.ofNullable(LocalFileSystem.getInstance().findFileByPath(workingDirPath)).map(baseDir -> baseDir.findChild(".mvn")).map(mvn -> mvn.findChild("jvm.config")).orElse(null);
    }

    private static String toVmString(VirtualFile jdkOpts) {
        try {
            return new String(jdkOpts.contentsToByteArray(true), jdkOpts.getCharset());
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
            return null;
        }
    }

    private static File patchConfFile(File conf, String library) throws IOException {
        File tmpConf = FileUtil.createTempFile((String)"idea-", (String)"-mvn.conf");
        tmpConf.deleteOnExit();
        MavenExternalParameters.patchConfFile(conf, tmpConf, library);
        return tmpConf;
    }

    private static void patchConfFile(File originalConf, File dest, String library) throws IOException {
        try (Scanner sc = new Scanner(originalConf);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), StandardCharsets.UTF_8));){
            boolean patched = false;
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                out.append(line);
                out.newLine();
                if (patched || !"[plexus.core]".equals(line)) continue;
                out.append("load ").append(library);
                out.newLine();
                patched = true;
            }
        }
    }

    private static String getArtifactResolverJar(@Nullable String mavenVersion) throws IOException {
        Class<MavenArtifactResolvedM31RtMarker> marker = MavenArtifactResolvedM31RtMarker.class;
        File classDirOrJar = new File(PathUtil.getJarPathForClass(marker));
        if (!classDirOrJar.isDirectory()) {
            return classDirOrJar.getAbsolutePath();
        }
        File tempFile = FileUtil.createTempFile((String)"idea-", (String)"-artifactResolver.jar", (boolean)true);
        try (Compressor.Zip zip = new Compressor.Zip(tempFile);){
            zip.addDirectory(classDirOrJar);
            String m2Module = PathUtil.getJarPathForClass(MavenModuleMap.class);
            String commonClassesPath = MavenModuleMap.class.getPackage().getName().replace('.', '/');
            zip.addDirectory(commonClassesPath, new File(m2Module, commonClassesPath));
        }
        return tempFile.getAbsolutePath();
    }

    private static File dumpModulesPaths(@NotNull Project project) throws IOException {
        if (project == null) {
            MavenExternalParameters.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Properties res = new Properties();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            MavenProject mavenProject;
            if (!manager.isMavenizedModule(module) || (mavenProject = manager.findProject(module)) == null || manager.isIgnored(mavenProject)) continue;
            res.setProperty(mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId() + ":pom:" + mavenProject.getMavenId().getVersion(), mavenProject.getFile().getPath());
            res.setProperty(mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId() + ":" + mavenProject.getPackaging() + ":" + mavenProject.getMavenId().getVersion(), mavenProject.getOutputDirectory());
            res.setProperty(mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId() + ":test-jar:" + mavenProject.getMavenId().getVersion(), mavenProject.getTestOutputDirectory());
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "sources");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "test-sources");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "javadoc");
            MavenExternalParameters.addArtifactFileMapping(res, mavenProject, "test-javadoc");
        }
        File file = new File(PathManager.getSystemPath(), "Maven/idea-projects-state-" + project.getLocationHash() + ".properties");
        FileUtil.ensureExists((File)file.getParentFile());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            res.store(out, null);
        }
        return file;
    }

    private static void addArtifactFileMapping(@NotNull Properties res, @NotNull MavenProject mavenProject, @NotNull String classifier) {
        File file;
        if (res == null) {
            MavenExternalParameters.$$$reportNull$$$0(7);
        }
        if (mavenProject == null) {
            MavenExternalParameters.$$$reportNull$$$0(8);
        }
        if (classifier == null) {
            MavenExternalParameters.$$$reportNull$$$0(9);
        }
        if ((file = new File(mavenProject.getBuildDirectory(), mavenProject.getFinalName() + "-" + classifier + ".jar")).exists()) {
            res.setProperty(mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId() + ":" + classifier + ":" + mavenProject.getMavenId().getVersion(), file.getPath());
        }
    }

    @NotNull
    private static Sdk getJdk(@Nullable Project project, String jreName, boolean isGlobalRunnerSettings) throws ExecutionException {
        if (jreName.equals("#JAVA_INTERNAL")) {
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(10);
            }
            return sdk;
        }
        if (jreName.equals("#USE_PROJECT_JDK")) {
            if (project != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project).getProjectSdk();
                if (res != null) {
                    Sdk sdk = res;
                    if (sdk == null) {
                        MavenExternalParameters.$$$reportNull$$$0(11);
                    }
                    return sdk;
                }
                for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    Sdk sdk2 = sdk;
                    if (sdk2 == null) {
                        MavenExternalParameters.$$$reportNull$$$0(12);
                    }
                    return sdk2;
                }
            }
            if (project == null) {
                Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                if (recent != null) {
                    Sdk sdk = recent;
                    if (sdk == null) {
                        MavenExternalParameters.$$$reportNull$$$0(13);
                    }
                    return sdk;
                }
                Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
                if (sdk == null) {
                    MavenExternalParameters.$$$reportNull$$$0(14);
                }
                return sdk;
            }
            throw new ProjectJdkSettingsOpenerExecutionException(RunnerBundle.message("dialog.message.project.jdk.not.specified.href.configure", new Object[0]), project);
        }
        if (jreName.equals("#JAVA_HOME")) {
            String javaHome = ExternalSystemJdkUtil.getJavaHome();
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new ExecutionException(RunnerBundle.message("maven.java.home.undefined", new Object[0]));
            }
            Sdk sdk = JavaSdk.getInstance().createJdk("", javaHome);
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(15);
            }
            return sdk;
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(jreName)) continue;
            Sdk sdk = projectJdk;
            if (sdk == null) {
                MavenExternalParameters.$$$reportNull$$$0(16);
            }
            return sdk;
        }
        if (isGlobalRunnerSettings) {
            throw new ExecutionException(RunnerBundle.message("maven.java.not.found.default.config", jreName));
        }
        throw new ExecutionException(RunnerBundle.message("maven.java.not.found", jreName));
    }

    public static void addVMParameters(ParametersList parametersList, String mavenHome, String vmOptionsSettings) {
        parametersList.addParametersString(System.getenv(MAVEN_OPTS));
        parametersList.addParametersString(vmOptionsSettings);
        parametersList.addProperty("maven.home", mavenHome);
    }

    private static void addMavenParameters(ParametersList parametersList, String mavenHome, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, MavenRunnerParameters parameters) {
        MavenExternalParameters.encodeCoreAndRunnerSettings(coreSettings, mavenHome, parametersList);
        if (runnerSettings.isSkipTests()) {
            parametersList.addProperty("skipTests", "true");
        }
        for (Map.Entry<String, String> entry : runnerSettings.getMavenProperties().entrySet()) {
            if (entry.getKey().length() <= 0) continue;
            parametersList.addProperty(entry.getKey(), entry.getValue());
        }
        for (String goal : parameters.getGoals()) {
            parametersList.add(goal);
        }
        for (String cmdOption : parameters.getOptions()) {
            parametersList.add(cmdOption);
        }
        if (parameters.getPomFileName() != null && !FileUtil.namesEqual((String)"pom.xml", (String)parameters.getPomFileName())) {
            parametersList.add("-f");
            parametersList.add(parameters.getPomFileName());
        }
        MavenExternalParameters.addOption(parametersList, "P", MavenExternalParameters.encodeProfiles(parameters.getProfilesMap()));
    }

    private static void addOption(ParametersList cmdList, @NonNls String key, @NonNls String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            cmdList.add("-" + key);
            cmdList.add(value);
        }
    }

    @NotNull
    @NlsSafe
    public static String resolveMavenHome(@NotNull MavenGeneralSettings coreSettings, @NotNull Project project, @NotNull String workingDir, @Nullable MavenRunConfiguration runConfiguration) throws ExecutionException {
        String string;
        if (coreSettings == null) {
            MavenExternalParameters.$$$reportNull$$$0(17);
        }
        if (project == null) {
            MavenExternalParameters.$$$reportNull$$$0(18);
        }
        if (workingDir == null) {
            MavenExternalParameters.$$$reportNull$$$0(19);
        }
        MavenHomeType type = coreSettings.getMavenHomeType();
        File file = null;
        if (type instanceof StaticResolvedMavenHomeType) {
            StaticResolvedMavenHomeType st = (StaticResolvedMavenHomeType)type;
            file = MavenUtil.getMavenHomeFile(st);
        }
        if (type instanceof MavenWrapper) {
            MavenDistribution distribution = MavenDistributionsCache.getInstance(project).getWrapper(workingDir);
            file = distribution != null ? distribution.getMavenHome().toFile() : MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome().toFile();
        }
        if (file == null) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.no.default", new Object[0]), RunnerBundle.message("external.maven.home.no.default.with.fix", new Object[0]), coreSettings, project, runConfiguration);
        }
        if (!file.exists()) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.does.not.exist", file.getPath()), RunnerBundle.message("external.maven.home.does.not.exist.with.fix", file.getPath()), coreSettings, project, runConfiguration);
        }
        if (!MavenUtil.isValidMavenHome(file)) {
            throw MavenExternalParameters.createExecutionException(RunnerBundle.message("external.maven.home.invalid", file.getPath()), RunnerBundle.message("external.maven.home.invalid.with.fix", file.getPath()), coreSettings, project, runConfiguration);
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        if (string == null) {
            MavenExternalParameters.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static ExecutionException createExecutionException(@NlsContexts.DialogMessage String text, @NlsContexts.DialogMessage String textWithFix, @NotNull MavenGeneralSettings coreSettings, @Nullable Project project, @Nullable MavenRunConfiguration runConfiguration) {
        Project runCfgProject;
        Project notNullProject;
        if (coreSettings == null) {
            MavenExternalParameters.$$$reportNull$$$0(21);
        }
        if ((notNullProject = project) == null) {
            if (runConfiguration == null) {
                return new ExecutionException(text);
            }
            notNullProject = runConfiguration.getProject();
        }
        if (coreSettings == MavenProjectsManager.getInstance(notNullProject).getGeneralSettings()) {
            return new ProjectSettingsOpenerExecutionException(textWithFix, notNullProject);
        }
        if (runConfiguration != null && ((RunManagerImpl)RunManager.getInstance((Project)(runCfgProject = runConfiguration.getProject()))).getSettings((RunConfiguration)runConfiguration) != null) {
            return new RunConfigurationOpenerExecutionException(textWithFix, runConfiguration);
        }
        return new ExecutionException(text);
    }

    private static List<String> getMavenClasspathEntries(String mavenHome) {
        File mavenHomeBootAsFile = new File(new File(mavenHome, "core"), "boot");
        if (!mavenHomeBootAsFile.exists()) {
            mavenHomeBootAsFile = new File(mavenHome, "boot");
        }
        ArrayList<String> classpathEntries = new ArrayList<String>();
        File[] files2 = mavenHomeBootAsFile.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                if (!file.getName().contains("classworlds")) continue;
                classpathEntries.add(file.getAbsolutePath());
            }
        }
        return classpathEntries;
    }

    private static void encodeCoreAndRunnerSettings(MavenGeneralSettings coreSettings, String mavenHome, ParametersList cmdList) {
        if (coreSettings.isWorkOffline()) {
            cmdList.add("--offline");
        }
        if (coreSettings.getOutputLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
            cmdList.add("--debug");
        }
        if (coreSettings.isNonRecursive()) {
            cmdList.add("--non-recursive");
        }
        if (coreSettings.isPrintErrorStackTraces()) {
            cmdList.add("--errors");
        }
        if (coreSettings.isAlwaysUpdateSnapshots()) {
            cmdList.add("--update-snapshots");
        }
        if (StringUtil.isNotEmpty((String)coreSettings.getThreads())) {
            cmdList.add("-T", coreSettings.getThreads());
        }
        MavenExternalParameters.addIfNotEmpty(cmdList, coreSettings.getFailureBehavior().getCommandLineOption());
        MavenExternalParameters.addIfNotEmpty(cmdList, coreSettings.getChecksumPolicy().getCommandLineOption());
        MavenExternalParameters.addOption(cmdList, "s", coreSettings.getUserSettingsFile());
        if (!StringUtil.isEmptyOrSpaces((String)coreSettings.getLocalRepository())) {
            cmdList.addProperty("maven.repo.local", coreSettings.getLocalRepository());
        }
    }

    private static void addIfNotEmpty(ParametersList parametersList, @Nullable String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            parametersList.add(value);
        }
    }

    @ApiStatus.Internal
    public static String encodeProfiles(Map<String, Boolean> profiles2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Boolean> entry : profiles2.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            if (!entry.getValue().booleanValue()) {
                stringBuilder.append("!");
            }
            stringBuilder.append(entry.getKey());
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 11, 12, 13, 14, 15, 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirPath";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenExternalParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classifier";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreSettings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenExternalParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readJvmConfigOptions";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMavenHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRunVmOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readJvmConfigOptions";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJvmConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumpModulesPaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addArtifactFileMapping";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveMavenHome";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 11, 12, 13, 14, 15, 16, 20 -> new IllegalStateException(string);
        };
    }

    private static class ProjectJdkSettingsOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final Project myProject;

        ProjectJdkSettingsOpenerExecutionException(@NlsContexts.DialogMessage String s, Project project) {
            super(s);
            this.myProject = project;
        }

        @Override
        protected void hyperlinkClicked() {
            ProjectSettingsService.getInstance((Project)this.myProject).openProjectSettings();
        }
    }

    private static class ProjectSettingsOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final Project myProject;

        ProjectSettingsOpenerExecutionException(@NlsContexts.DialogMessage String s, Project project) {
            super(s);
            this.myProject = project;
        }

        @Override
        protected void hyperlinkClicked() {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }
    }

    private static class RunConfigurationOpenerExecutionException
    extends WithHyperlinkExecutionException {
        private final MavenRunConfiguration myRunConfiguration;

        RunConfigurationOpenerExecutionException(@NlsContexts.DialogMessage String s, MavenRunConfiguration runConfiguration) {
            super(s);
            this.myRunConfiguration = runConfiguration;
        }

        @Override
        protected void hyperlinkClicked() {
            Project project = this.myRunConfiguration.getProject();
            EditConfigurationsDialog dialog = new EditConfigurationsDialog(project);
            dialog.show();
        }
    }

    private static abstract class WithHyperlinkExecutionException
    extends ExecutionException
    implements HyperlinkListener,
    NotificationListener {
        WithHyperlinkExecutionException(@NlsContexts.DialogMessage String s) {
            super(s);
        }

        protected abstract void hyperlinkClicked();

        @Override
        public final void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkClicked();
            }
        }

        public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                WithHyperlinkExecutionException.$$$reportNull$$$0(0);
            }
            if (event == null) {
                WithHyperlinkExecutionException.$$$reportNull$$$0(1);
            }
            this.hyperlinkUpdate(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenExternalParameters$WithHyperlinkExecutionException";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

