/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.Idle;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.server.ssl.State;
import org.jetbrains.idea.maven.server.ssl.WaitForAuthType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/WaitForChainLen;", "Lorg/jetbrains/idea/maven/server/ssl/State;", "machine", "Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "key", "", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;I)V", "getMachine", "()Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "getKey", "()I", "addLine", "text", "", "intellij.maven"})
public final class WaitForChainLen
extends State {
    @NotNull
    private final SslDelegateHandlerStateMachine machine;
    private final int key;

    public WaitForChainLen(@NotNull SslDelegateHandlerStateMachine machine, int key) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        super(null);
        this.machine = machine;
        this.key = key;
    }

    @NotNull
    public final SslDelegateHandlerStateMachine getMachine() {
        return this.machine;
    }

    public final int getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public State addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Integer len = StringsKt.toIntOrNull((String)text);
        if (len != null) {
            return new WaitForAuthType(this.machine, this.key, len);
        }
        return new Idle(this.machine);
    }
}

