/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.dependency.jsr305.concurrent.ThreadSafe;
import org.assertj.swing.monitor.ProtectingTimerTask;
import org.assertj.swing.monitor.WindowVisibilityMonitor;
import org.assertj.swing.util.Maps;

@ThreadSafe
class Windows {
    @VisibleForTesting
    static int WINDOW_READY_DELAY = 10000;
    @GuardedBy(value="lock")
    final Map<Window, TimerTask> pending = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> open = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> closed = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> hidden = Maps.newWeakHashMap();
    private final Timer windowReadyTimer;
    private final Object lock = new Object();

    Windows() {
        this.windowReadyTimer = new Timer("Window Ready Timer", true);
    }

    void attachNewWindowVisibilityMonitor(Window target) {
        WindowVisibilityMonitor monitor = new WindowVisibilityMonitor(this);
        target.addWindowListener(monitor);
        target.addComponentListener(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInCurrentThread
    void markExisting(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.open.put(w, true);
            if (!w.isShowing()) {
                this.hidden.put(w, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsHidden(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.hidden.put(w, true);
            this.removeWindowFrom(w, this.pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsShowing(final @Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            TimerTask task2 = new TimerTask(){

                @Override
                public void run() {
                    Windows.this.markAsReady(w);
                }
            };
            this.windowReadyTimer.schedule((TimerTask)new ProtectingTimerTask(task2), WINDOW_READY_DELAY);
            this.pending.put(w, task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReady(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.pending.containsKey(w)) {
                return;
            }
            this.removeWindowFrom(w, this.closed, this.hidden, this.pending);
            this.open.put(w, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsClosed(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.removeWindowFrom(w, this.open, this.hidden, this.pending);
            this.closed.put(w, true);
        }
    }

    private void removeWindowFrom(Window w, Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            map.remove(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed(@Nonnull Component c) {
        Object object = this.lock;
        synchronized (object) {
            return this.closed.containsKey(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReady(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.open.containsKey(w) && !this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHidden(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isShowingButNotReady(@Nonnull Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.pending.containsKey(w);
        }
    }
}

