/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.javac.Iterators;

public final class CachingMultiMaplet<K, V>
implements MultiMaplet<K, V> {
    private final LoadingCache<K, Iterable<V>> myCache;
    private final MultiMaplet<K, V> myDelegate;

    public CachingMultiMaplet(MultiMaplet<K, V> delegate, int maxCacheSize) {
        this.myDelegate = delegate;
        this.myCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).build(this.myDelegate::get);
    }

    @Override
    public boolean containsKey(K key) {
        return this.myCache.getIfPresent(key) != null || this.myDelegate.containsKey(key);
    }

    @Override
    @NotNull
    public Iterable<V> get(K key) {
        Iterable iterable = (Iterable)this.myCache.get(key);
        if (iterable == null) {
            CachingMultiMaplet.$$$reportNull$$$0(0);
        }
        return iterable;
    }

    @Override
    public void put(K key, @NotNull Iterable<? extends V> values) {
        if (values == null) {
            CachingMultiMaplet.$$$reportNull$$$0(1);
        }
        try {
            this.myDelegate.put(key, values);
        }
        finally {
            this.myCache.invalidate(key);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.myDelegate.remove(key);
        }
        finally {
            this.myCache.invalidate(key);
        }
    }

    @Override
    public void appendValue(K key, V value) {
        this.appendValues(key, Collections.singleton(value));
    }

    @Override
    public void appendValues(K key, @NotNull Iterable<? extends V> values) {
        if (values == null) {
            CachingMultiMaplet.$$$reportNull$$$0(2);
        }
        if (!Iterators.isEmpty(values)) {
            try {
                this.myDelegate.appendValues(key, values);
            }
            finally {
                this.myCache.invalidate(key);
            }
        }
    }

    @Override
    public void removeValue(K key, V value) {
        this.removeValues(key, Collections.singleton(value));
    }

    @Override
    public void removeValues(K key, @NotNull Iterable<? extends V> values) {
        if (values == null) {
            CachingMultiMaplet.$$$reportNull$$$0(3);
        }
        if (!Iterators.isEmpty(values)) {
            try {
                this.myDelegate.removeValues(key, values);
            }
            finally {
                this.myCache.invalidate(key);
            }
        }
    }

    @Override
    @NotNull
    public Iterable<K> getKeys() {
        Iterable iterable = this.myDelegate.getKeys();
        if (iterable == null) {
            CachingMultiMaplet.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    @Override
    public void close() throws IOException {
        this.myCache.invalidateAll();
        this.myDelegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.myDelegate.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/CachingMultiMaplet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/CachingMultiMaplet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

