/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.kotlin;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationChangesTracker;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;

public final class NullabilityAnnotationChangesTracker
implements AnnotationChangesTracker {
    private static final Set<String> ourTrackedAnnotations = Set.of("org/jetbrains/annotations/Nullable", "androidx/annotation/Nullable", "android/support/annotation/Nullable", "android/annotation/Nullable", "com/android/annotations/Nullable", "org/eclipse/jdt/annotation/Nullable", "org/checkerframework/checker/nullness/qual/Nullable", "javax/annotation/Nullable", "javax/annotation/CheckForNull", "edu/umd/cs/findbugs/annotations/CheckForNull", "edu/umd/cs/findbugs/annotations/Nullable", "edu/umd/cs/findbugs/annotations/PossiblyNull", "io/reactivex/annotations/Nullable", "io/reactivex/rxjava3/annotations/Nullable", "javax/annotation/Nonnull", "org/jetbrains/annotations/NotNull", "edu/umd/cs/findbugs/annotations/NonNull", "androidx/annotation/NonNull", "android/support/annotation/NonNull", "android/annotation/NonNull", "com/android/annotations/NonNull", "org/eclipse/jdt/annotation/NonNull", "org/checkerframework/checker/nullness/qual/NonNull", "lombok/NonNull", "io/reactivex/annotations/NonNull", "io/reactivex/rxjava3/annotations/NonNull");

    @Override
    @NotNull
    public Set<AnnotationChangesTracker.Recompile> methodAnnotationsChanged(JvmMethod method, Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotationsDiff, Difference.Specifier<ParamAnnotation, ParamAnnotation.Diff> paramAnnotationsDiff) {
        if (NullabilityAnnotationChangesTracker.isAffected(Iterators.map((Iterable)Iterators.flat(List.of(annotationsDiff.added(), annotationsDiff.removed(), paramAnnotationsDiff.added(), paramAnnotationsDiff.removed())), an -> an.getAnnotationClass()))) {
            EnumSet<AnnotationChangesTracker.Recompile> enumSet = method.isFinal() ? EnumSet.of(AnnotationChangesTracker.Recompile.USAGES) : EnumSet.of(AnnotationChangesTracker.Recompile.USAGES, AnnotationChangesTracker.Recompile.SUBCLASSES);
            if (enumSet == null) {
                NullabilityAnnotationChangesTracker.$$$reportNull$$$0(0);
            }
            return enumSet;
        }
        Set set = RECOMPILE_NONE;
        if (set == null) {
            NullabilityAnnotationChangesTracker.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<AnnotationChangesTracker.Recompile> fieldAnnotationsChanged(JvmField field, Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotationsDiff) {
        EnumSet<AnnotationChangesTracker.Recompile> enumSet = NullabilityAnnotationChangesTracker.isAffected(Iterators.map((Iterable)Iterators.flat(annotationsDiff.added(), annotationsDiff.removed()), an -> an.getAnnotationClass())) ? EnumSet.of(AnnotationChangesTracker.Recompile.USAGES) : RECOMPILE_NONE;
        if (enumSet == null) {
            NullabilityAnnotationChangesTracker.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    private static boolean isAffected(Iterable<TypeRepr.ClassType> addedOrRemoved) {
        return !Iterators.isEmpty((Iterable)Iterators.filter(addedOrRemoved, t -> ourTrackedAnnotations.contains(t.getJvmName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/dependency/kotlin/NullabilityAnnotationChangesTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "methodAnnotationsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldAnnotationsChanged";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

