/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.tracing.Tracer;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.storage.BuildTargetStorages;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.NodeSourcePathMapper;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.impl.DependencyGraphImpl;
import org.jetbrains.jps.dependency.impl.LoggingDependencyGraph;
import org.jetbrains.jps.dependency.impl.PathSourceMapper;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.ExperimentalBuildDataManager;
import org.jetbrains.jps.incremental.storage.OneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.jps.javac.Iterators;

public final class BuildDataManager {
    private static final Logger LOG = Logger.getInstance(BuildDataManager.class);
    public static final String PROCESS_CONSTANTS_NON_INCREMENTAL_PROPERTY = "compiler.process.constants.non.incremental";
    private static final int VERSION = 39 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0) + (JavaBuilderUtil.isDepGraphEnabled() ? 2 : 0);
    private static final String SRC_TO_FORM_STORAGE = "src-form";
    private static final String SRC_TO_OUTPUT_STORAGE = "src-out";
    private static final String OUT_TARGET_STORAGE = "out-target";
    private static final String MAPPINGS_STORAGE = "mappings";
    private static final String SRC_TO_OUTPUT_FILE_NAME = "data";
    @NotNull
    private final ConcurrentMap<BuildTarget<?>, BuildTargetStorages> myTargetStorages;
    @NotNull
    private final ConcurrentMap<BuildTarget<?>, SourceToOutputMappingWrapper> buildTargetToSourceToOutputMapping;
    @Nullable
    private final ExperimentalBuildDataManager newDataManager;
    @Nullable
    private ProjectStamps myFileStampService;
    @Nullable
    private final OneToManyPathsMapping sourceToFormMap;
    private final Mappings myMappings;
    private final Object myGraphManagementLock;
    private DependencyGraph myDepGraph;
    private final NodeSourcePathMapper myDepGraphPathMapper;
    private final BuildDataPaths myDataPaths;
    private final BuildTargetsState myTargetsState;
    @Nullable
    private final OutputToTargetRegistry outputToTargetMapping;
    private final File myVersionFile;
    private final PathRelativizerService myRelativizer;
    private boolean myProcessConstantsIncrementally;
    private Boolean myVersionDiffers;

    @ApiStatus.Internal
    @TestOnly
    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, @NotNull PathRelativizerService relativizer) throws IOException {
        if (relativizer == null) {
            BuildDataManager.$$$reportNull$$$0(0);
        }
        this(dataPaths, targetsState, relativizer, null, null);
    }

    @ApiStatus.Internal
    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, @NotNull PathRelativizerService relativizer, @Nullable StorageManager storageManager) throws IOException {
        if (relativizer == null) {
            BuildDataManager.$$$reportNull$$$0(1);
        }
        this(dataPaths, targetsState, relativizer, storageManager, ProjectStamps.PORTABLE_CACHES ? null : new ProjectStamps(dataPaths.getDataStorageRoot().toPath(), targetsState));
    }

    private BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, @NotNull PathRelativizerService relativizer, @Nullable StorageManager storageManager, @Nullable ProjectStamps projectStamps) throws IOException {
        if (relativizer == null) {
            BuildDataManager.$$$reportNull$$$0(2);
        }
        this.myTargetStorages = new ConcurrentHashMap();
        this.buildTargetToSourceToOutputMapping = new ConcurrentHashMap();
        this.myGraphManagementLock = new Object();
        this.myProcessConstantsIncrementally = !Boolean.parseBoolean(System.getProperty(PROCESS_CONSTANTS_NON_INCREMENTAL_PROPERTY, "false"));
        this.myVersionDiffers = null;
        this.myDataPaths = dataPaths;
        this.myTargetsState = targetsState;
        this.myFileStampService = projectStamps;
        Path dataStorageRoot = dataPaths.getDataStorageRoot().toPath();
        try {
            this.newDataManager = storageManager == null ? null : new ExperimentalBuildDataManager(storageManager, relativizer);
            this.sourceToFormMap = storageManager == null ? new OneToManyPathsMapping(this.getSourceToFormsRoot().resolve(SRC_TO_OUTPUT_FILE_NAME), relativizer) : null;
            this.outputToTargetMapping = storageManager == null ? new OutputToTargetRegistry(this.getOutputToSourceRegistryRoot().resolve(SRC_TO_OUTPUT_FILE_NAME), relativizer) : null;
            Path mappingsRoot = BuildDataManager.getMappingsRoot(dataStorageRoot);
            if (JavaBuilderUtil.isDepGraphEnabled()) {
                this.myMappings = null;
                this.createDependencyGraph(mappingsRoot, false);
                FileUtilRt.deleteRecursively((Path)BuildDataManager.getMappingsRoot(dataStorageRoot, false));
                LOG.info("Using DependencyGraph-based build incremental analysis");
            } else {
                this.myMappings = new Mappings(mappingsRoot.toFile(), relativizer);
                FileUtilRt.deleteRecursively((Path)BuildDataManager.getMappingsRoot(dataStorageRoot, true));
                this.myMappings.setProcessConstantsIncrementally(this.isProcessConstantsIncrementally());
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        this.myVersionFile = dataStorageRoot.resolve("version.dat").toFile();
        this.myDepGraphPathMapper = new PathSourceMapper(relativizer::toFull, relativizer::toRelative);
        this.myRelativizer = relativizer;
    }

    @ApiStatus.Internal
    public void setFileStampService(@Nullable ProjectStamps fileStampService) {
        this.myFileStampService = fileStampService;
    }

    @ApiStatus.Internal
    public void clearCache() {
        if (this.newDataManager != null) {
            this.newDataManager.clearCache();
        }
    }

    public void setProcessConstantsIncrementally(boolean processInc) {
        this.myProcessConstantsIncrementally = processInc;
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            mappings.setProcessConstantsIncrementally(processInc);
        }
    }

    public boolean isProcessConstantsIncrementally() {
        return this.myProcessConstantsIncrementally;
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public void cleanStaleTarget(@NotNull BuildTargetType<?> targetType, @NotNull String targetId) throws IOException {
        if (targetType == null) {
            BuildDataManager.$$$reportNull$$$0(3);
        }
        if (targetId == null) {
            BuildDataManager.$$$reportNull$$$0(4);
        }
        try {
            FileUtilRt.deleteRecursively((Path)this.getDataPaths().getTargetDataRoot(targetType, targetId));
            if (this.newDataManager != null) {
                this.newDataManager.removeStaleTarget(targetId, targetType.getTypeId());
            }
        }
        finally {
            this.getTargetsState().cleanStaleTarget(targetType, targetId);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public OutputToTargetMapping getOutputToTargetMapping() {
        OutputToTargetMapping outputToTargetMapping = this.newDataManager == null ? (OutputToTargetMapping)Objects.requireNonNull(this.outputToTargetMapping) : this.newDataManager.getOutputToTargetMapping();
        if (outputToTargetMapping == null) {
            BuildDataManager.$$$reportNull$$$0(5);
        }
        return outputToTargetMapping;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public OutputToTargetRegistry getOutputToTargetRegistry() {
        OutputToTargetRegistry outputToTargetRegistry = Objects.requireNonNull(this.outputToTargetMapping);
        if (outputToTargetRegistry == null) {
            BuildDataManager.$$$reportNull$$$0(6);
        }
        return outputToTargetRegistry;
    }

    @NotNull
    public SourceToOutputMapping getSourceToOutputMap(@NotNull BuildTarget<?> target) throws IOException {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(7);
        }
        if (this.newDataManager == null) {
            SourceToOutputMapping sourceToOutputMapping;
            try {
                sourceToOutputMapping = this.buildTargetToSourceToOutputMapping.computeIfAbsent(target, this::createSourceToOutputMap);
            }
            catch (BuildDataCorruptedException e) {
                LOG.info((Throwable)e);
                throw e.getCause();
            }
            if (sourceToOutputMapping == null) {
                BuildDataManager.$$$reportNull$$$0(8);
            }
            return sourceToOutputMapping;
        }
        SourceToOutputMapping sourceToOutputMapping = this.newDataManager.getSourceToOutputMapping(target);
        if (sourceToOutputMapping == null) {
            BuildDataManager.$$$reportNull$$$0(9);
        }
        return sourceToOutputMapping;
    }

    @NotNull
    private SourceToOutputMappingWrapper createSourceToOutputMap(@NotNull BuildTarget<?> target) {
        SourceToOutputMappingImpl map;
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(10);
        }
        try {
            Path file = this.myDataPaths.getTargetDataRootDir(target).resolve(SRC_TO_OUTPUT_STORAGE).resolve(SRC_TO_OUTPUT_FILE_NAME);
            map = new SourceToOutputMappingImpl(file, this.myRelativizer);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new BuildDataCorruptedException(e);
        }
        return new SourceToOutputMappingWrapper(map, this.myTargetsState.getBuildTargetId(target), this.outputToTargetMapping);
    }

    @Nullable
    public StampsStorage<?> getFileStampStorage(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(11);
        }
        if (this.newDataManager != null) {
            return this.newDataManager.getFileStampStorage(target);
        }
        return this.myFileStampService == null ? null : this.myFileStampService.getStampStorage();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public ProjectStamps getFileStampService() {
        return this.myFileStampService;
    }

    @ApiStatus.Internal
    public SourceToOutputMappingImpl createSourceToOutputMapForStaleTarget(BuildTargetType<?> targetType, String targetId) throws IOException {
        return new SourceToOutputMappingImpl(this.getSourceToOutputMapRoot(targetType, targetId).resolve(SRC_TO_OUTPUT_FILE_NAME), this.myRelativizer);
    }

    @NotNull
    public <S extends StorageOwner> S getStorage(@NotNull BuildTarget<?> target, @NotNull StorageProvider<S> provider) throws IOException {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(12);
        }
        if (provider == null) {
            BuildDataManager.$$$reportNull$$$0(13);
        }
        BuildTargetStorages targetStorages = this.myTargetStorages.computeIfAbsent(target, t -> new BuildTargetStorages((BuildTarget<?>)t, this.myDataPaths));
        S s = targetStorages.getOrCreateStorage(provider, this.myRelativizer);
        if (s == null) {
            BuildDataManager.$$$reportNull$$$0(14);
        }
        return s;
    }

    @ApiStatus.Internal
    @NotNull
    public OneToManyPathMapping getSourceToFormMap(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(15);
        }
        OneToManyPathMapping oneToManyPathMapping = this.newDataManager == null ? (OneToManyPathMapping)Objects.requireNonNull(this.sourceToFormMap) : this.newDataManager.getSourceToForm(target);
        if (oneToManyPathMapping == null) {
            BuildDataManager.$$$reportNull$$$0(16);
        }
        return oneToManyPathMapping;
    }

    @ApiStatus.Internal
    public Mappings getMappings() {
        return this.myMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GraphConfiguration getDependencyGraph() {
        Object object = this.myGraphManagementLock;
        synchronized (object) {
            final DependencyGraph depGraph = this.myDepGraph;
            return depGraph == null ? null : new GraphConfiguration(){

                @Override
                @NotNull
                public NodeSourcePathMapper getPathMapper() {
                    NodeSourcePathMapper nodeSourcePathMapper = BuildDataManager.this.myDepGraphPathMapper;
                    if (nodeSourcePathMapper == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return nodeSourcePathMapper;
                }

                @Override
                @NotNull
                public DependencyGraph getGraph() {
                    DependencyGraph dependencyGraph = depGraph;
                    if (dependencyGraph == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return dependencyGraph;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPathMapper";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getGraph";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTargetStorages(@NotNull BuildTarget<?> target) throws IOException {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(17);
        }
        try {
            SourceToOutputMappingWrapper sourceToOutput;
            block12: {
                try {
                    BuildTargetStorages storages = (BuildTargetStorages)this.myTargetStorages.remove(target);
                    if (storages == null) break block12;
                    storages.close();
                }
                catch (Throwable throwable) {
                    SourceToOutputMappingWrapper sourceToOutput2 = (SourceToOutputMappingWrapper)this.buildTargetToSourceToOutputMapping.remove(target);
                    if (sourceToOutput2 != null && sourceToOutput2.myDelegate != null) {
                        sourceToOutput2.myDelegate.close();
                    }
                    if (this.newDataManager != null) {
                        this.newDataManager.closeTargetMaps(target);
                    }
                    throw throwable;
                }
            }
            if ((sourceToOutput = (SourceToOutputMappingWrapper)this.buildTargetToSourceToOutputMapping.remove(target)) != null && sourceToOutput.myDelegate != null) {
                sourceToOutput.myDelegate.close();
            }
            if (this.newDataManager != null) {
                this.newDataManager.closeTargetMaps(target);
            }
        }
        finally {
            List targetData = NioFiles.list((Path)this.myDataPaths.getTargetDataRootDir(target));
            if (!targetData.isEmpty()) {
                Path srcOutputMapRoot = this.getSourceToOutputMapRoot(target);
                for (Path dataFile : targetData) {
                    if (dataFile.equals(srcOutputMapRoot)) continue;
                    NioFiles.deleteRecursively((Path)dataFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(@NotNull Consumer<Future<?>> asyncTaskCollector) throws IOException {
        if (asyncTaskCollector == null) {
            BuildDataManager.$$$reportNull$$$0(18);
        }
        if (this.myFileStampService != null) {
            try {
                this.myFileStampService.clean();
            }
            catch (Throwable e) {
                LOG.error((Throwable)new ProjectBuildException(JpsBuildBundle.message("build.message.error.cleaning.timestamps.storage", new Object[0]), e));
            }
        }
        try {
            this.allTargetStorages(asyncTaskCollector).clean();
            this.buildTargetToSourceToOutputMapping.clear();
            this.myTargetStorages.clear();
            if (this.newDataManager != null) {
                this.newDataManager.removeAllMaps();
            }
        }
        finally {
            try {
                if (this.sourceToFormMap != null) {
                    BuildDataManager.wipeStorage(this.getSourceToFormsRoot(), this.sourceToFormMap);
                }
            }
            finally {
                try {
                    if (this.outputToTargetMapping != null) {
                        BuildDataManager.wipeStorage(this.getOutputToSourceRegistryRoot(), this.outputToTargetMapping);
                    }
                }
                finally {
                    Path mappingsRoot = BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot().toPath());
                    Mappings mappings = this.myMappings;
                    if (mappings != null) {
                        Mappings mappings2 = mappings;
                        synchronized (mappings2) {
                            mappings.clean();
                        }
                    } else {
                        FileUtilRt.deleteRecursively((Path)mappingsRoot);
                    }
                    if (JavaBuilderUtil.isDepGraphEnabled()) {
                        this.createDependencyGraph(mappingsRoot, true);
                    }
                }
            }
            this.myTargetsState.clean();
        }
        this.saveVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDependencyGraph(@NotNull Path mappingsRoot, boolean deleteExisting) throws IOException {
        if (mappingsRoot == null) {
            BuildDataManager.$$$reportNull$$$0(19);
        }
        try {
            Object object = this.myGraphManagementLock;
            synchronized (object) {
                DependencyGraph depGraph = this.myDepGraph;
                if (depGraph == null) {
                    if (deleteExisting) {
                        FileUtil.delete((Path)mappingsRoot);
                    }
                    this.myDepGraph = BuildDataManager.asSynchronizedGraph(new DependencyGraphImpl(Containers.createPersistentContainerFactory(mappingsRoot.toString())));
                } else {
                    try {
                        depGraph.close();
                    }
                    finally {
                        if (deleteExisting) {
                            FileUtil.delete((Path)mappingsRoot);
                        }
                        this.myDepGraph = BuildDataManager.asSynchronizedGraph(new DependencyGraphImpl(Containers.createPersistentContainerFactory(mappingsRoot.toString())));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        if (this.newDataManager != null && !memoryCachesOnly) {
            this.newDataManager.commit();
        }
        if (this.myFileStampService != null) {
            this.myFileStampService.flush(memoryCachesOnly);
        }
        if (this.outputToTargetMapping != null) {
            this.outputToTargetMapping.flush(memoryCachesOnly);
        }
        if (this.sourceToFormMap != null) {
            this.sourceToFormMap.flush(memoryCachesOnly);
        }
        this.allTargetStorages().flush(memoryCachesOnly);
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            Mappings mappings2 = mappings;
            synchronized (mappings2) {
                mappings.flush(memoryCachesOnly);
            }
        }
    }

    public void close() throws IOException {
        IOOperation.execAll(IOException.class, IOOperation.adapt(this.myTargetsState, BuildTargetsState::save), IOOperation.adapt(this.allTargetStorages(), StorageOwner::close), () -> {
            this.myTargetStorages.clear();
            this.buildTargetToSourceToOutputMapping.clear();
        }, IOOperation.adapt(this.newDataManager, ExperimentalBuildDataManager::close), IOOperation.adapt(this.myFileStampService, StorageOwner::close), IOOperation.adapt(this.outputToTargetMapping, StorageOwner::close), () -> {
            if (this.sourceToFormMap != null) {
                OneToManyPathsMapping oneToManyPathsMapping = this.sourceToFormMap;
                synchronized (oneToManyPathsMapping) {
                    this.sourceToFormMap.close();
                }
            }
        }, () -> {
            Mappings mappings = this.myMappings;
            if (mappings != null) {
                try {
                    mappings.close();
                }
                catch (BuildDataCorruptedException e) {
                    throw e.getCause();
                }
            }
            Object object = this.myGraphManagementLock;
            synchronized (object) {
                DependencyGraph depGraph = this.myDepGraph;
                if (depGraph != null) {
                    this.myDepGraph = null;
                    try {
                        depGraph.close();
                    }
                    catch (BuildDataCorruptedException e) {
                        throw e.getCause();
                    }
                }
            }
        });
    }

    public void closeSourceToOutputStorages(@NotNull BuildTargetChunk chunk) throws IOException {
        if (chunk == null) {
            BuildDataManager.$$$reportNull$$$0(20);
        }
        Tracer.Span flush = Tracer.start((String)"closeSourceToOutputStorages");
        IOOperation.execAll(IOException.class, Iterators.map(chunk.getTargets(), target -> {
            SourceToOutputMappingWrapper wrapper = (SourceToOutputMappingWrapper)this.buildTargetToSourceToOutputMapping.remove(target);
            return IOOperation.adapt(wrapper != null ? wrapper.myDelegate : null, StorageOwner::close);
        }));
        flush.complete();
    }

    @NotNull
    private Path getSourceToOutputMapRoot(BuildTarget<?> target) {
        Path path = this.myDataPaths.getTargetDataRootDir(target).resolve(SRC_TO_OUTPUT_STORAGE);
        if (path == null) {
            BuildDataManager.$$$reportNull$$$0(21);
        }
        return path;
    }

    private Path getSourceToOutputMapRoot(BuildTargetType<?> targetType, String targetId) {
        return this.myDataPaths.getTargetDataRoot(targetType, targetId).resolve(SRC_TO_OUTPUT_STORAGE);
    }

    @NotNull
    private Path getSourceToFormsRoot() {
        Path path = this.myDataPaths.getDataStorageRoot().toPath().resolve(SRC_TO_FORM_STORAGE);
        if (path == null) {
            BuildDataManager.$$$reportNull$$$0(22);
        }
        return path;
    }

    @NotNull
    private Path getOutputToSourceRegistryRoot() {
        Path path = this.myDataPaths.getDataStorageRoot().toPath().resolve(OUT_TARGET_STORAGE);
        if (path == null) {
            BuildDataManager.$$$reportNull$$$0(23);
        }
        return path;
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    public PathRelativizerService getRelativizer() {
        return this.myRelativizer;
    }

    @NotNull
    public static Path getMappingsRoot(@NotNull Path dataStorageRoot) {
        if (dataStorageRoot == null) {
            BuildDataManager.$$$reportNull$$$0(24);
        }
        Path path = BuildDataManager.getMappingsRoot(dataStorageRoot, JavaBuilderUtil.isDepGraphEnabled());
        if (path == null) {
            BuildDataManager.$$$reportNull$$$0(25);
        }
        return path;
    }

    private static Path getMappingsRoot(@NotNull Path dataStorageRoot, boolean forDepGraph) {
        if (dataStorageRoot == null) {
            BuildDataManager.$$$reportNull$$$0(26);
        }
        return dataStorageRoot.resolve(forDepGraph ? "mappings-graph" : MAPPINGS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wipeStorage(@NotNull Path root, @Nullable StorageOwner storage) {
        if (root == null) {
            BuildDataManager.$$$reportNull$$$0(27);
        }
        if (storage != null) {
            StorageOwner storageOwner = storage;
            synchronized (storageOwner) {
                try {
                    storage.clean();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            FileUtilRt.deleteRecursively((Path)root);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public boolean versionDiffers() {
        boolean bl;
        Boolean cached = this.myVersionDiffers;
        if (cached != null) {
            return cached;
        }
        DataInputStream is = new DataInputStream(new FileInputStream(this.myVersionFile));
        try {
            boolean diff = is.readInt() != VERSION;
            this.myVersionDiffers = diff;
            bl = diff;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ignored) {
                return false;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return true;
            }
        }
        is.close();
        return bl;
    }

    public void saveVersion() {
        Boolean differs = this.myVersionDiffers;
        if (differs == null || differs.booleanValue()) {
            FileUtil.createIfDoesntExist((File)this.myVersionFile);
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(this.myVersionFile));){
                os.writeInt(VERSION);
                this.myVersionDiffers = Boolean.FALSE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reportUnhandledRelativizerPaths() {
        this.myRelativizer.reportUnhandledPaths();
    }

    @NotNull
    private StorageOwner allTargetStorages(final @NotNull Consumer<Future<?>> asyncTaskCollector) {
        if (asyncTaskCollector == null) {
            BuildDataManager.$$$reportNull$$$0(28);
        }
        return new CompositeStorageOwner(){

            @Override
            public void clean() throws IOException {
                try {
                    this.close();
                }
                finally {
                    asyncTaskCollector.accept(FileUtil.asyncDelete((File)BuildDataManager.this.myDataPaths.getTargetsDataRoot()));
                }
            }

            @Override
            protected Iterable<? extends StorageOwner> getChildStorages() {
                return Iterators.flat(BuildDataManager.this.myTargetStorages.values(), (Iterable)Iterators.filter((Iterable)Iterators.map(BuildDataManager.this.buildTargetToSourceToOutputMapping.values(), w -> w.myDelegate), Objects::nonNull));
            }
        };
    }

    @NotNull
    private StorageOwner allTargetStorages() {
        return this.allTargetStorages(f -> {});
    }

    private static DependencyGraph asSynchronizedGraph(DependencyGraph graph) {
        final LoggingDependencyGraph delegate = new LoggingDependencyGraph(graph, msg -> LOG.info(msg));
        return new DependencyGraph(){
            private final ReadWriteLock lock = new ReentrantReadWriteLock();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Delta createDelta(Iterable<NodeSource> sourcesToProcess, Iterable<NodeSource> deletedSources, boolean isSourceOnly) throws IOException {
                this.lock.readLock().lock();
                try {
                    Delta delta = delegate.createDelta(sourcesToProcess, deletedSources, isSourceOnly);
                    return delta;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DifferentiateResult differentiate(Delta delta, DifferentiateParameters params) {
                this.lock.readLock().lock();
                try {
                    DifferentiateResult differentiateResult = delegate.differentiate(delta, params);
                    return differentiateResult;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            @Override
            public void integrate(@NotNull DifferentiateResult diffResult) {
                if (diffResult == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.lock.writeLock().lock();
                try {
                    delegate.integrate(diffResult);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            @Override
            public Iterable<BackDependencyIndex> getIndices() {
                return delegate.getIndices();
            }

            @Override
            @Nullable
            public BackDependencyIndex getIndex(String name) {
                return delegate.getIndex(name);
            }

            @Override
            public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
                if (id == null) {
                    3.$$$reportNull$$$0(1);
                }
                return delegate.getSources(id);
            }

            @Override
            public Iterable<ReferenceID> getRegisteredNodes() {
                return delegate.getRegisteredNodes();
            }

            @Override
            public Iterable<NodeSource> getSources() {
                return delegate.getSources();
            }

            @Override
            public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
                if (source == null) {
                    3.$$$reportNull$$$0(2);
                }
                return delegate.getNodes(source);
            }

            @Override
            public <T extends Node<T, ?>> Iterable<T> getNodes(NodeSource src, Class<T> nodeSelector) {
                return delegate.getNodes(src, nodeSelector);
            }

            @Override
            @NotNull
            public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
                if (id == null) {
                    3.$$$reportNull$$$0(3);
                }
                Iterable<ReferenceID> iterable = delegate.getDependingNodes(id);
                if (iterable == null) {
                    3.$$$reportNull$$$0(4);
                }
                return iterable;
            }

            @Override
            public void close() throws IOException {
                this.lock.writeLock().lock();
                try {
                    delegate.close();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "diffResult";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager$3";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDependingNodes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "integrate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSources";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodes";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getDependingNodes";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncTaskCollector";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingsRoot";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputToTargetMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputToTargetRegistry";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceToOutputMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceToFormMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceToOutputMapRoot";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceToFormsRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputToSourceRegistryRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanStaleTarget";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSourceToOutputMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSourceToOutputMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileStampStorage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceToFormMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cleanTargetStorages";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "clean";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDependencyGraph";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "closeSourceToOutputStorages";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsRoot";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "wipeStorage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "allTargetStorages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SourceToOutputMappingWrapper
    implements SourceToOutputMapping {
        private final SourceToOutputMappingImpl myDelegate;
        private final int myBuildTargetId;
        private final OutputToTargetRegistry outputToTargetMapping;

        SourceToOutputMappingWrapper(SourceToOutputMappingImpl delegate, int buildTargetId, OutputToTargetRegistry outputToTargetMapping) {
            this.myDelegate = delegate;
            this.myBuildTargetId = buildTargetId;
            this.outputToTargetMapping = outputToTargetMapping;
        }

        @Override
        public void setOutputs(@NotNull String srcPath, @NotNull List<String> outputs) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(0);
            }
            if (outputs == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(1);
            }
            try {
                this.myDelegate.setOutputs(srcPath, outputs);
            }
            finally {
                this.outputToTargetMapping.addMappings(outputs, this.myBuildTargetId);
            }
        }

        @Override
        public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(2);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(3);
            }
            try {
                this.myDelegate.setOutput(srcPath, outputPath);
            }
            finally {
                this.outputToTargetMapping.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(4);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(5);
            }
            try {
                this.myDelegate.appendOutput(srcPath, outputPath);
            }
            finally {
                this.outputToTargetMapping.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void remove(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(6);
            }
            this.myDelegate.remove(srcPath);
        }

        @Override
        public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
            if (sourcePath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(7);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(8);
            }
            this.myDelegate.removeOutput(sourcePath, outputPath);
        }

        @Override
        @Nullable
        public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(9);
            }
            return this.myDelegate.getOutputs(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getSourcesIterator() throws IOException {
            Iterator<String> iterator = this.myDelegate.getSourcesIterator();
            if (iterator == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(10);
            }
            return iterator;
        }

        @Override
        @NotNull
        public SourceToOutputMappingCursor cursor() throws IOException {
            SourceToOutputMappingCursor sourceToOutputMappingCursor = this.myDelegate.cursor();
            if (sourceToOutputMappingCursor == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(11);
            }
            return sourceToOutputMappingCursor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputs";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePath";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourcesIterator";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cursor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutputs";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutput";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOutput";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOutput";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutputs";
                    break;
                }
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface IOOperation<T extends Throwable> {
        public void exec() throws T;

        public static <Obj, E extends Throwable> IOOperation<E> adapt(@Nullable Obj caller, Call<Obj, E> op) {
            return () -> {
                if (caller != null) {
                    op.execute(caller);
                }
            };
        }

        public static <T extends Throwable> void execAll(Class<T> errorClass, IOOperation<T> ... operations) throws T {
            IOOperation.execAll(errorClass, Arrays.asList(operations));
        }

        public static <T extends Throwable> void execAll(Class<T> errorClass, Iterable<IOOperation<T>> operations) throws T {
            Throwable error = null;
            for (IOOperation<T> operation : operations) {
                try {
                    operation.exec();
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (error != null) continue;
                    error = e;
                }
            }
            if (errorClass.isInstance(error)) {
                throw (Throwable)errorClass.cast(error);
            }
            if (error != null) {
                throw new RuntimeException(error);
            }
        }

        public static interface Call<T, E extends Throwable> {
            public void execute(T var1) throws E;
        }
    }
}

