/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.BaseOutputReader;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacMessageHandler;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.ExternalJavacRunResult;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.javac.rpc.JavacRemoteProto;

@ApiStatus.Internal
public class ExternalJavacManager
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance(ExternalJavacManager.class);
    public static final GlobalContextKey<ExternalJavacManager> KEY = GlobalContextKey.create("_external_javac_server_");
    public static final int DEFAULT_SERVER_PORT = 7878;
    public static final String STDOUT_LINE_PREFIX = "JAVAC_PROCESS[STDOUT]";
    public static final String STDERR_LINE_PREFIX = "JAVAC_PROCESS[STDERR]";
    private static final AttributeKey<UUID> PROCESS_ID_KEY = AttributeKey.valueOf((String)"ExternalJavacServer.ProcessId");
    private static final Key<Integer> PROCESS_HASH = Key.create((String)"ExternalJavacServer.SdkHomePath");
    private static final Key<ExternalJavacMessageHandler.WslSupport> WSL_SUPPORT = Key.create((String)"_wsl_support_");
    private final File myWorkingDir;
    private final ChannelRegistrar myChannelRegistrar;
    private int myListenPort;
    private InetAddress myListenAddress;
    private final Map<UUID, CompileSession> mySessions;
    private final Map<UUID, ExternalJavacProcessHandler> myRunningProcesses;
    private final Map<UUID, Channel> myConnections;
    private final Executor myExecutor;
    private boolean myOwnExecutor;
    private final long myKeepAliveTimeout;
    private String myWslExePath;

    public ExternalJavacManager(@NotNull File workingDir, @NotNull Executor executor) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            ExternalJavacManager.$$$reportNull$$$0(1);
        }
        this(workingDir, executor, 300000L);
    }

    public ExternalJavacManager(@NotNull File workingDir, @NotNull Executor executor, long keepAliveTimeout) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            ExternalJavacManager.$$$reportNull$$$0(3);
        }
        this.myListenPort = 7878;
        this.mySessions = Collections.synchronizedMap(new HashMap());
        this.myRunningProcesses = Collections.synchronizedMap(new HashMap());
        this.myConnections = Collections.synchronizedMap(new HashMap());
        this.myWslExePath = "wsl";
        this.myWorkingDir = workingDir;
        this.myChannelRegistrar = new ChannelRegistrar();
        this.myExecutor = executor;
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    public void start(int listenPort) throws UnknownHostException {
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, this.myExecutor)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{ExternalJavacManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        this.myListenAddress = WslToLinuxPathConverter.isWslPath(this.myWorkingDir) ? InetAddress.getLocalHost() : InetAddress.getLoopbackAddress();
        this.myChannelRegistrar.add(bootstrap.bind(this.myListenAddress, listenPort).syncUninterruptibly().channel());
        this.myListenPort = listenPort;
    }

    public ExternalJavacRunResult forkJavac(String javaHome, int heapSize, Iterable<String> vmOptions, Iterable<String> options, CompilationPaths paths, Iterable<? extends File> files, Map<File, Set<File>> outs, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, CanceledStatus cancelStatus, boolean keepProcessAlive) {
        try {
            ExternalJavacProcessHandler running = this.findRunningProcess(ExternalJavacManager.processHash(javaHome, vmOptions, compilingTool));
            ExternalJavacProcessHandler processHandler = running != null ? running : this.launchExternalJavacProcess(javaHome, heapSize, this.myListenPort, this.myWorkingDir, vmOptions, compilingTool, keepProcessAlive);
            Channel channel = this.lookupChannel(processHandler.getProcessId());
            if (channel != null) {
                ExternalJavacMessageHandler.WslSupport wslSupport = (ExternalJavacMessageHandler.WslSupport)WSL_SUPPORT.get((UserDataHolder)processHandler);
                ExternalJavacMessageHandler.WslSupport converter = wslSupport instanceof WslToLinuxPathConverter ? ((WslToLinuxPathConverter)wslSupport).reverseConverter() : ExternalJavacMessageHandler.WslSupport.DIRECT;
                CompileSession session = new CompileSession(processHandler.getProcessId(), new ExternalJavacMessageHandler(diagnosticSink, outputSink, ExternalJavacManager.getEncodingName(options), converter), cancelStatus);
                this.mySessions.put(session.getId(), session);
                channel.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)session.getId(), (JavacRemoteProto.Message.Request)JavacProtoUtil.createCompilationRequest(options, files, paths.getClasspath(), paths.getPlatformClasspath(), (ModulePath)paths.getModulePath(), paths.getUpgradeModulePath(), paths.getSourcePath(), outs, (ExternalJavacMessageHandler.WslSupport)wslSupport)));
                return session;
            }
            LOG.warn("Failed to connect to javac process");
        }
        catch (Throwable e) {
            LOG.info(e);
            diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
        }
        return ExternalJavacRunResult.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public boolean waitForAllProcessHandlers(long time, @NotNull TimeUnit timeUnit) {
        ArrayList<ExternalJavacProcessHandler> processes;
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(4);
        }
        Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
        synchronized (map) {
            processes = new ArrayList<ExternalJavacProcessHandler>(this.myRunningProcesses.values());
        }
        for (ProcessHandler processHandler : processes) {
            void unit;
            if (processHandler.waitFor(unit.toMillis(time))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(5);
        }
        if (this.myOwnExecutor && this.myExecutor instanceof ExecutorService) {
            try {
                void unit;
                return ((ExecutorService)this.myExecutor).awaitTermination(time, (TimeUnit)unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalJavacProcessHandler findRunningProcess(int processHash) {
        ExternalJavacManager.debug(() -> "findRunningProcess: looking for hash " + processHash);
        ArrayList<ExternalJavacProcessHandler> idleProcesses = null;
        try {
            Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
            synchronized (map) {
                for (Map.Entry<UUID, ExternalJavacProcessHandler> entry : this.myRunningProcesses.entrySet()) {
                    ExternalJavacProcessHandler process = entry.getValue();
                    if (!process.isKeepProcessAlive()) continue;
                    Integer hash = (Integer)PROCESS_HASH.get((UserDataHolder)process);
                    if (hash != null && hash == processHash && process.lock()) {
                        ExternalJavacManager.debug(() -> "findRunningProcess: returning process " + process.getProcessId() + " for hash " + processHash);
                        ExternalJavacProcessHandler externalJavacProcessHandler = process;
                        return externalJavacProcessHandler;
                    }
                    if (process.getIdleTime() <= this.myKeepAliveTimeout) continue;
                    if (idleProcesses == null) {
                        idleProcesses = new ArrayList<ExternalJavacProcessHandler>();
                    }
                    ExternalJavacManager.debug(() -> "findRunningProcess: adding " + process.getProcessId() + " to idle list");
                    idleProcesses.add(process);
                }
            }
            ExternalJavacManager.debug(() -> "findRunningProcess: no running process for " + processHash + " is found");
            map = null;
            return map;
        }
        finally {
            if (idleProcesses != null) {
                for (ExternalJavacProcessHandler process : idleProcesses) {
                    this.shutdownProcess(process);
                }
            }
        }
    }

    private static <T> void debug(T data, Function<? super T, String> message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message.apply(data));
        }
    }

    private static void debug(Supplier<String> message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    private static int processHash(String sdkHomePath, Iterable<String> vmOptions, JavaCompilingTool tool) {
        Collection opts = vmOptions instanceof Collection ? (Collection)vmOptions : Iterators.collect(vmOptions, new ArrayList());
        return Objects.hash(sdkHomePath.replace(File.separatorChar, '/'), opts, tool.getId());
    }

    @Nullable
    private static String getEncodingName(Iterable<String> options) {
        Iterator<String> it = options.iterator();
        while (it.hasNext()) {
            String option = it.next();
            if (!"-encoding".equals(option)) continue;
            return it.hasNext() ? it.next() : null;
        }
        return null;
    }

    public boolean isRunning() {
        return !this.myChannelRegistrar.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<UUID, Channel> map = this.myConnections;
        synchronized (map) {
            for (Map.Entry<UUID, Channel> entry : this.myConnections.entrySet()) {
                entry.getValue().writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)entry.getKey(), (JavacRemoteProto.Message.Request)JavacProtoUtil.createShutdownRequest()));
            }
        }
        this.myChannelRegistrar.close().awaitUninterruptibly();
        if (this.myOwnExecutor && this.myExecutor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.myExecutor;
            service.shutdown();
            try {
                service.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownIdleProcesses() {
        ArrayList<ExternalJavacProcessHandler> idleProcesses = null;
        Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
        synchronized (map) {
            for (ExternalJavacProcessHandler process : this.myRunningProcesses.values()) {
                long idle = process.getIdleTime();
                if (idle <= this.myKeepAliveTimeout) continue;
                if (idleProcesses == null) {
                    idleProcesses = new ArrayList<ExternalJavacProcessHandler>();
                }
                idleProcesses.add(process);
            }
        }
        if (idleProcesses != null) {
            for (ExternalJavacProcessHandler process : idleProcesses) {
                this.shutdownProcess(process);
            }
        }
    }

    private boolean shutdownProcess(ExternalJavacProcessHandler process) {
        UUID processId = process.getProcessId();
        ExternalJavacManager.debug(() -> "shutdownProcess: shutting down " + processId);
        Channel conn = this.myConnections.get(processId);
        if (conn != null && process.lock()) {
            ExternalJavacManager.debug(() -> "shutdownProcess: sending shutdown request to " + processId);
            conn.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)processId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createShutdownRequest()));
            return true;
        }
        return false;
    }

    private ExternalJavacProcessHandler launchExternalJavacProcess(String sdkHomePath, int heapSize, int port, File workingDir, Iterable<String> vmOptions, JavaCompilingTool compilingTool, boolean keepProcessAlive) throws Exception {
        UUID processId = UUID.randomUUID();
        ArrayList<String> cmdLine = new ArrayList<String>();
        WslToLinuxPathConverter wslConverter = WslToLinuxPathConverter.createFrom(sdkHomePath);
        boolean launchWSL = wslConverter != null;
        WslToLinuxPathConverter wslSupport = launchWSL ? wslConverter : ExternalJavacMessageHandler.WslSupport.DIRECT;
        ExternalJavacManager.appendParam(cmdLine, wslSupport.convertPath(sdkHomePath + "/bin/java"));
        ExternalJavacManager.appendParam(cmdLine, "-Djava.awt.headless=true");
        if (heapSize > 0) {
            int xms = heapSize / 2;
            if (xms > 32) {
                ExternalJavacManager.appendParam(cmdLine, "-Xms" + xms + "m");
            }
            ExternalJavacManager.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        }
        ExternalJavacManager.copyProperty(cmdLine, "file.encoding");
        ExternalJavacManager.copyProperty(cmdLine, "user.language");
        ExternalJavacManager.copyProperty(cmdLine, "user.country");
        ExternalJavacManager.copyProperty(cmdLine, "user.region");
        ExternalJavacManager.copyProperty(cmdLine, "io.netty.noUnsafe");
        ExternalJavacManager.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        for (String option : vmOptions) {
            ExternalJavacManager.appendParam(cmdLine, option);
        }
        ExternalJavacManager.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getExternalJavacProcessClasspath(sdkHomePath, compilingTool);
        String pathSeparator = launchWSL ? ":" : File.pathSeparator;
        String classpath = String.join((CharSequence)pathSeparator, Iterators.map(cp, f -> wslSupport.convertPath(f.getPath())));
        if (launchWSL && !classpath.isEmpty()) {
            cmdLine.add("'" + classpath.replace("'", "\\'") + "'");
        } else {
            ExternalJavacManager.appendParam(cmdLine, classpath);
        }
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacProcess.class.getName());
        ExternalJavacManager.appendParam(cmdLine, processId.toString());
        InetAddress targetAddress = this.myListenAddress;
        if (targetAddress == null) {
            targetAddress = InetAddress.getLoopbackAddress();
        }
        ExternalJavacManager.appendParam(cmdLine, targetAddress.getHostAddress());
        ExternalJavacManager.appendParam(cmdLine, Integer.toString(port));
        ExternalJavacManager.appendParam(cmdLine, Boolean.toString(keepProcessAlive));
        if (launchWSL) {
            String command = "\"cd '" + wslSupport.convertPath(workingDir.getPath()) + "' && " + String.join((CharSequence)" ", cmdLine) + "\"";
            cmdLine.clear();
            cmdLine.add(this.myWslExePath);
            cmdLine.add("--distribution");
            cmdLine.add(wslConverter.getDistributionId());
            cmdLine.add("--exec");
            cmdLine.add("/bin/sh");
            cmdLine.add("-c");
            cmdLine.add(command);
        }
        ExternalJavacManager.debug(() -> "starting external compiler: " + cmdLine);
        FileUtil.createDirectory((File)workingDir);
        int processHash = ExternalJavacManager.processHash(sdkHomePath, vmOptions, compilingTool);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
        if (!launchWSL) {
            processBuilder.directory(workingDir);
        }
        ExternalJavacProcessHandler processHandler = this.createProcessHandler(processId, processBuilder.start(), String.join((CharSequence)" ", cmdLine), keepProcessAlive);
        WSL_SUPPORT.set((UserDataHolder)processHandler, (Object)wslSupport);
        PROCESS_HASH.set((UserDataHolder)processHandler, (Object)processHash);
        processHandler.lock();
        this.myRunningProcesses.put(processId, processHandler);
        ExternalJavacManager.debug(() -> "external compiler process registered: id=" + processId + ", hash=" + processHash);
        processHandler.addProcessListener((ProcessListener)this);
        processHandler.startNotify();
        return processHandler;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ExternalJavacManager.$$$reportNull$$$0(6);
        }
        UUID processId = ((ExternalJavacProcessHandler)event.getProcessHandler()).getProcessId();
        ExternalJavacManager.debug(() -> "process " + processId + " terminated");
        this.myRunningProcesses.remove(processId);
        if (this.myConnections.get(processId) == null) {
            this.cleanSessions(processId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSessions(UUID processId) {
        Map<UUID, CompileSession> map = this.mySessions;
        synchronized (map) {
            Iterator<Map.Entry<UUID, CompileSession>> it = this.mySessions.entrySet().iterator();
            while (it.hasNext()) {
                CompileSession session = it.next().getValue();
                if (!processId.equals(session.getProcessId())) continue;
                session.setDone();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        String text;
        if (event == null) {
            ExternalJavacManager.$$$reportNull$$$0(7);
        }
        if (outputType == null) {
            ExternalJavacManager.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(text = event.getText()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("text from javac: " + text);
            }
            String prefix = null;
            if (outputType == ProcessOutputTypes.STDOUT) {
                prefix = STDOUT_LINE_PREFIX;
            } else if (outputType == ProcessOutputTypes.STDERR) {
                prefix = STDERR_LINE_PREFIX;
            }
            if (prefix != null) {
                ArrayList<DiagnosticOutputConsumer> consumers = null;
                UUID processId = ((ExternalJavacProcessHandler)event.getProcessHandler()).getProcessId();
                Map<UUID, CompileSession> map = this.mySessions;
                synchronized (map) {
                    for (CompileSession session : this.mySessions.values()) {
                        if (!processId.equals(session.getProcessId())) continue;
                        if (consumers == null) {
                            consumers = new ArrayList<DiagnosticOutputConsumer>();
                        }
                        consumers.add(session.myHandler.getDiagnosticSink());
                    }
                }
                String msg = prefix + ": " + text;
                if (consumers != null) {
                    for (DiagnosticOutputConsumer consumer : consumers) {
                        consumer.outputLineAvailable(msg);
                    }
                } else {
                    LOG.info(msg.trim());
                }
            }
        }
    }

    protected ExternalJavacProcessHandler createProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
        if (process == null) {
            ExternalJavacManager.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            ExternalJavacManager.$$$reportNull$$$0(10);
        }
        return new ExternalJavacProcessHandler(processId, process, commandLine, keepProcessAlive);
    }

    private static void appendParam(List<? super String> cmdLine, String parameter) {
        if (SystemInfo.isWindows) {
            if (parameter.contains("\"")) {
                parameter = parameter.replace("\"", "\\\"");
            } else if (parameter.isEmpty()) {
                parameter = "\"\"";
            }
        }
        cmdLine.add(parameter);
    }

    private static void copyProperty(List<? super String> cmdLine, String name) {
        String value = System.getProperty(name);
        if (value != null) {
            ExternalJavacManager.appendParam(cmdLine, "-D" + name + "=" + value);
        }
    }

    public void setWslExecutablePath(@Nullable Path wslExePath) {
        if (wslExePath != null) {
            this.myWslExePath = wslExePath.toAbsolutePath().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel lookupChannel(UUID processId) {
        Channel channel = null;
        Map<UUID, Channel> map = this.myConnections;
        synchronized (map) {
            channel = this.myConnections.get(processId);
            ExternalJavacManager.debug(channel, ch -> "lookupChannel: channel for " + processId + " is " + ch);
            while (channel == null) {
                if (!this.myRunningProcesses.containsKey(processId)) {
                    ExternalJavacManager.debug(() -> "lookupChannel: no process for " + processId);
                    break;
                }
                try {
                    this.myConnections.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                channel = this.myConnections.get(processId);
                ExternalJavacManager.debug(channel, ch -> "lookupChannel: after wait channel for " + processId + " is " + ch);
            }
        }
        return channel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAllProcessHandlers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcessHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                ChannelRegistrar.$$$reportNull$$$0(0);
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                Iterator iterator = this.openChannels.close();
                return iterator;
            }
            finally {
                if (eventLoopGroup != null) {
                    eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/jps/javac/ExternalJavacManager$ChannelRegistrar", "add"));
        }
    }

    @ChannelHandler.Sharable
    private final class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            try {
                Channel channel = context.channel();
                UUID processId = (UUID)channel.attr(PROCESS_ID_KEY).get();
                if (processId != null) {
                    ExternalJavacManager.this.cleanSessions(processId);
                    ExternalJavacManager.this.myConnections.remove(processId);
                }
            }
            finally {
                super.channelInactive(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(ChannelHandlerContext context, JavacRemoteProto.Message message) {
            JavacRemoteProto.Message reply;
            JavacRemoteProto.Message.Type messageType;
            ExternalJavacMessageHandler handler;
            CompileSession session;
            UUID msgUuid;
            block12: {
                msgUuid = JavacProtoUtil.fromProtoUUID((JavacRemoteProto.Message.UUID)message.getSessionId());
                session = ExternalJavacManager.this.mySessions.get(msgUuid);
                handler = session != null ? session.myHandler : null;
                messageType = message.getMessageType();
                reply = null;
                try {
                    JavacRemoteProto.Message.Response response;
                    JavacRemoteProto.Message.Response.Type responseType;
                    if (messageType != JavacRemoteProto.Message.Type.RESPONSE || (responseType = (response = message.getResponse()).getResponseType()) != JavacRemoteProto.Message.Response.Type.REQUEST_ACK) break block12;
                    Channel channel = context.channel();
                    channel.attr(PROCESS_ID_KEY).set((Object)msgUuid);
                    Map<UUID, Channel> map = ExternalJavacManager.this.myConnections;
                    synchronized (map) {
                        ExternalJavacManager.this.myConnections.put(msgUuid, channel);
                        ExternalJavacManager.this.myConnections.notifyAll();
                    }
                    if (reply == null) return;
                }
                catch (Throwable throwable) {
                    if (reply == null) throw throwable;
                    context.channel().writeAndFlush(reply);
                    throw throwable;
                }
                context.channel().writeAndFlush((Object)reply);
                return;
            }
            if (handler != null) {
                boolean terminateOk = handler.handleMessage((MessageLite)message);
                if (terminateOk) {
                    session.setDone();
                    ExternalJavacManager.this.mySessions.remove(session.getId());
                    ExternalJavacProcessHandler process = ExternalJavacManager.this.myRunningProcesses.get(session.getProcessId());
                    if (process != null) {
                        process.unlock();
                    }
                } else if (session.isCancelRequested()) {
                    reply = JavacProtoUtil.toMessage((UUID)msgUuid, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest());
                }
            } else {
                LOG.info("No message handler is registered to handle message " + messageType.name() + "; canceling the process");
                reply = JavacProtoUtil.toMessage((UUID)msgUuid, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest());
            }
            if (reply == null) return;
            context.channel().writeAndFlush((Object)reply);
        }
    }

    private static final class WslToLinuxPathConverter
    implements ExternalJavacMessageHandler.WslSupport {
        private static final List<String> WSL_PATH_PREFIXES = List.of("//wsl$/", "//wsl.localhost/");
        private static final String MNT_PREFIX = "/mnt/";
        private static final int MNT_PATTERN_LENGTH = "/mnt/".length() + 2;
        @NotNull
        private final String myDistributionId;
        @NotNull
        private final String myWslPathPrefix;

        WslToLinuxPathConverter(@NotNull String distributionId, @NotNull String wslPathPrefix) {
            if (distributionId == null) {
                WslToLinuxPathConverter.$$$reportNull$$$0(0);
            }
            if (wslPathPrefix == null) {
                WslToLinuxPathConverter.$$$reportNull$$$0(1);
            }
            this.myDistributionId = distributionId;
            this.myWslPathPrefix = wslPathPrefix;
        }

        @NotNull
        public String getDistributionId() {
            String string = this.myDistributionId;
            if (string == null) {
                WslToLinuxPathConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String convertPath(String path) {
            String normalized = FileUtilRt.toSystemIndependentName((String)path);
            if (WslToLinuxPathConverter.isWslPath(normalized)) {
                int distrSeparatorIndex = normalized.indexOf(47, this.myWslPathPrefix.length());
                return distrSeparatorIndex > this.myWslPathPrefix.length() ? normalized.substring(distrSeparatorIndex) : normalized;
            }
            if (WslToLinuxPathConverter.isWinPath(normalized)) {
                return MNT_PREFIX + Character.toLowerCase(normalized.charAt(0)) + normalized.substring(2);
            }
            return normalized;
        }

        public ExternalJavacMessageHandler.WslSupport reverseConverter() {
            String prefix = this.myWslPathPrefix + this.myDistributionId;
            return path -> {
                char driveLetter;
                if (path.startsWith(MNT_PREFIX) && path.length() >= MNT_PATTERN_LENGTH && Character.isLetter(driveLetter = path.charAt(MNT_PREFIX.length())) && path.charAt(MNT_PATTERN_LENGTH - 1) == '/') {
                    return driveLetter + ":/" + path.substring(MNT_PATTERN_LENGTH);
                }
                return path.startsWith("/") ? prefix + path : prefix + "/" + path;
            };
        }

        @Nullable
        static WslToLinuxPathConverter createFrom(String path) {
            if (SystemInfo.isWin10OrNewer) {
                path = FileUtilRt.toSystemIndependentName((String)path);
                for (String wslPathPrefix : WSL_PATH_PREFIXES) {
                    int distrSeparatorIndex;
                    if (!path.startsWith(wslPathPrefix) || (distrSeparatorIndex = path.indexOf(47, wslPathPrefix.length())) <= wslPathPrefix.length()) continue;
                    return new WslToLinuxPathConverter(path.substring(wslPathPrefix.length(), distrSeparatorIndex), wslPathPrefix);
                }
            }
            return null;
        }

        static boolean isWslPath(File file) {
            return file != null && WslToLinuxPathConverter.isWslPath(FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath()));
        }

        static boolean isWslPath(String path) {
            for (String wslPathPrefix : WSL_PATH_PREFIXES) {
                if (!path.startsWith(wslPathPrefix)) continue;
                return true;
            }
            return false;
        }

        static boolean isWinPath(String path) {
            return OSAgnosticPathUtil.isAbsoluteDosPath((String)path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "distributionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPathPrefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$WslToLinuxPathConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$WslToLinuxPathConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDistributionId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ExternalJavacProcessHandler
    extends BaseOSProcessHandler {
        private long myIdleSince;
        private final UUID myProcessId;
        private final boolean myKeepProcessAlive;
        private boolean myIsBusy;

        protected ExternalJavacProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
            if (process == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, commandLine, null);
            this.myProcessId = processId;
            this.myKeepProcessAlive = keepProcessAlive;
        }

        public UUID getProcessId() {
            return this.myProcessId;
        }

        public synchronized long getIdleTime() {
            long idleSince = this.myIdleSince;
            return idleSince == -42L ? 0L : TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - idleSince);
        }

        public synchronized void unlock() {
            this.myIdleSince = System.nanoTime();
            this.myIsBusy = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized boolean lock() {
            this.myIdleSince = -42L;
            if (this.myIsBusy) return false;
            this.myIsBusy = true;
            if (!true) return false;
            return true;
        }

        public boolean isKeepProcessAlive() {
            return this.myKeepProcessAlive;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = this.myKeepProcessAlive ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
            if (options == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class CompileSession
    extends ExternalJavacRunResult {
        private final UUID myId;
        private final UUID myProcessId;
        private final CanceledStatus myCancelStatus;
        private final ExternalJavacMessageHandler myHandler;
        private final Semaphore myDone;

        CompileSession(@NotNull UUID processId, ExternalJavacMessageHandler handler, CanceledStatus cancelStatus) {
            if (processId == null) {
                CompileSession.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                CompileSession.$$$reportNull$$$0(1);
            }
            this.myDone = new Semaphore();
            this.myProcessId = processId;
            this.myCancelStatus = cancelStatus;
            this.myId = UUID.randomUUID();
            this.myHandler = handler;
            this.myDone.down();
        }

        @NotNull
        public UUID getId() {
            UUID uUID = this.myId;
            if (uUID == null) {
                CompileSession.$$$reportNull$$$0(2);
            }
            return uUID;
        }

        @NotNull
        public UUID getProcessId() {
            UUID uUID = this.myProcessId;
            if (uUID == null) {
                CompileSession.$$$reportNull$$$0(3);
            }
            return uUID;
        }

        @Override
        public boolean isDone() {
            return this.myDone.isUp();
        }

        public void setDone() {
            this.myDone.up();
        }

        public boolean isTerminatedSuccessfully() {
            return this.myHandler.isTerminatedSuccessfully();
        }

        boolean isCancelRequested() {
            return this.myCancelStatus.isCanceled();
        }

        @Override
        @NotNull
        public Boolean get() {
            while (true) {
                try {
                    if (this.myDone.waitForUnsafe(300L)) {
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.notifyCancelled();
            }
            boolean successfully = this.isTerminatedSuccessfully();
            if (!successfully) {
                ExternalJavacManager.debug(() -> "Javac compile session " + this.myId + " in process " + this.myProcessId + "didn't terminate successfully");
            }
            Boolean bl = successfully;
            if (bl == null) {
                CompileSession.$$$reportNull$$$0(4);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Boolean get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                CompileSession.$$$reportNull$$$0(5);
            }
            if (!this.myDone.waitForUnsafe(unit.toMillis(timeout))) {
                this.notifyCancelled();
                throw new TimeoutException();
            }
            boolean successfully = this.isTerminatedSuccessfully();
            if (!successfully) {
                ExternalJavacManager.debug(() -> "Javac compile session " + this.myId + " in process " + this.myProcessId + "didn't terminate successfully");
            }
            Boolean bl = successfully;
            if (bl == null) {
                CompileSession.$$$reportNull$$$0(6);
            }
            return bl;
        }

        private void notifyCancelled() {
            Channel channel;
            if (this.isCancelRequested() && ExternalJavacManager.this.myRunningProcesses.containsKey(this.myProcessId) && (channel = ExternalJavacManager.this.myConnections.get(this.myProcessId)) != null) {
                channel.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)this.myId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$CompileSession";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$CompileSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessId";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

