/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertyBag
implements Map<String, Object> {
    public static final String TAGS_KEY = "tags";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> tags = new LinkedHashSet<String>();

    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.properties.containsValue(value2);
    }

    @Override
    public Object get(Object key) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.get(key);
    }

    @Override
    public Object put(String key, Object value2) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.put(key, value2);
    }

    @Override
    public Object remove(Object key) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m.containsKey(TAGS_KEY)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBag that = (PropertyBag)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.properties, this.tags);
    }

    public static class PropertyBagTypeAdapterFactory
    implements TypeAdapterFactory {
        private final Set<String> ignoreKeys;

        public PropertyBagTypeAdapterFactory(Collection<String> ignoreKeys) {
            this.ignoreKeys = new HashSet<String>(ignoreKeys);
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!PropertyBag.class.equals((Object)rawType)) {
                return null;
            }
            return new PropertyBagTypeAdapter(this.ignoreKeys, gson);
        }

        public static class PropertyBagTypeAdapter
        extends TypeAdapter<PropertyBag> {
            private final Gson gson;
            private final Set<String> ignoreKeys;

            public PropertyBagTypeAdapter(Set<String> ignoreKeys, Gson gson) {
                this.ignoreKeys = ignoreKeys;
                this.gson = gson;
            }

            public void write(JsonWriter out, PropertyBag bag) throws IOException {
                if (bag == null) {
                    out.nullValue();
                    return;
                }
                HashMap<String, Object> toSerialize = new HashMap<String, Object>(bag);
                if (!bag.tags.isEmpty()) {
                    toSerialize.put(PropertyBag.TAGS_KEY, bag.getTags());
                }
                TypeAdapter objectTypeAdapter = this.gson.getAdapter(Object.class);
                out.beginObject();
                for (Map.Entry<String, Object> entry : toSerialize.entrySet()) {
                    if (this.ignoreKeys.contains(entry.getKey())) continue;
                    out.name(String.valueOf(entry.getKey()));
                    objectTypeAdapter.write(out, entry.getValue());
                }
                out.endObject();
            }

            public PropertyBag read(JsonReader in) throws IOException {
                JsonToken peek = in.peek();
                if (peek == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                PropertyBag result2 = new PropertyBag();
                HashMap<String, Object> serializedMap = new HashMap<String, Object>();
                TypeAdapter objectTypeAdapter = this.gson.getAdapter(Object.class);
                in.beginObject();
                while (in.hasNext()) {
                    String key = in.nextName();
                    if (!this.ignoreKeys.contains(key)) {
                        Object value2 = objectTypeAdapter.read(in);
                        Object replaced = serializedMap.put(key, value2);
                        if (replaced == null) continue;
                        throw new JsonSyntaxException("Duplicate key: " + key);
                    }
                    in.skipValue();
                }
                in.endObject();
                Object tags = serializedMap.remove(PropertyBag.TAGS_KEY);
                result2.putAll((Map<? extends String, ?>)serializedMap);
                if (tags instanceof List) {
                    result2.tags.addAll((Collection)tags);
                }
                return result2;
            }
        }
    }
}

