/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher;

import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.PropertyOwner;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.RunAutomationDetails;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.publisher.Config;
import org.jetbrains.qodana.publisher.PublisherParsingException;
import org.jetbrains.qodana.publisher.ReportMetadata;
import org.jetbrains.qodana.publisher.ReportMetadata$Companion$Attributes$;
import org.jetbrains.qodana.publisher.ReportMetadata$Companion$IdeaMetaData$;
import org.jetbrains.qodana.publisher.ReportMetadata$Companion$SarifIdeaVcs$;
import org.jetbrains.qodana.publisher.ReportMetadata$Companion$SarifVcs$;
import org.jetbrains.qodana.publisher.ReportMetadata$Companion$SarifVcs$Properties$;
import org.jetbrains.qodana.publisher.schemas.PublisherAuthor;
import org.jetbrains.qodana.publisher.schemas.PublisherReportFile;
import org.jetbrains.qodana.publisher.schemas.PublisherVcs;
import org.jetbrains.qodana.publisher.utils.MapKeysSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J?\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata;", "", "vcs", "Lorg/jetbrains/qodana/publisher/schemas/PublisherVcs;", "tools", "", "", "projectId", "analysisId", "(Lorg/jetbrains/qodana/publisher/schemas/PublisherVcs;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getAnalysisId", "()Ljava/lang/String;", "getProjectId", "getTools", "()Ljava/util/List;", "getVcs", "()Lorg/jetbrains/qodana/publisher/schemas/PublisherVcs;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "publisher"})
public final class ReportMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PublisherVcs vcs;
    @Nullable
    private final List<String> tools;
    @Nullable
    private final String projectId;
    @Nullable
    private final String analysisId;
    private static final Logger logger = LoggerFactory.getLogger(Companion.class.getEnclosingClass());
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)Companion.json.1.INSTANCE, (int)1, null);

    public ReportMetadata(@Nullable PublisherVcs vcs, @Nullable List<String> tools, @Nullable String projectId, @Nullable String analysisId) {
        this.vcs = vcs;
        this.tools = tools;
        this.projectId = projectId;
        this.analysisId = analysisId;
    }

    @Nullable
    public final PublisherVcs getVcs() {
        return this.vcs;
    }

    @Nullable
    public final List<String> getTools() {
        return this.tools;
    }

    @Nullable
    public final String getProjectId() {
        return this.projectId;
    }

    @Nullable
    public final String getAnalysisId() {
        return this.analysisId;
    }

    @Nullable
    public final PublisherVcs component1() {
        return this.vcs;
    }

    @Nullable
    public final List<String> component2() {
        return this.tools;
    }

    @Nullable
    public final String component3() {
        return this.projectId;
    }

    @Nullable
    public final String component4() {
        return this.analysisId;
    }

    @NotNull
    public final ReportMetadata copy(@Nullable PublisherVcs vcs, @Nullable List<String> tools, @Nullable String projectId, @Nullable String analysisId) {
        return new ReportMetadata(vcs, tools, projectId, analysisId);
    }

    public static /* synthetic */ ReportMetadata copy$default(ReportMetadata reportMetadata, PublisherVcs publisherVcs, List list2, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            publisherVcs = reportMetadata.vcs;
        }
        if ((n & 2) != 0) {
            list2 = reportMetadata.tools;
        }
        if ((n & 4) != 0) {
            string = reportMetadata.projectId;
        }
        if ((n & 8) != 0) {
            string2 = reportMetadata.analysisId;
        }
        return reportMetadata.copy(publisherVcs, list2, string, string2);
    }

    @NotNull
    public String toString() {
        return "ReportMetadata(vcs=" + this.vcs + ", tools=" + this.tools + ", projectId=" + this.projectId + ", analysisId=" + this.analysisId + ")";
    }

    public int hashCode() {
        int result2 = this.vcs == null ? 0 : this.vcs.hashCode();
        result2 = result2 * 31 + (this.tools == null ? 0 : ((Object)this.tools).hashCode());
        result2 = result2 * 31 + (this.projectId == null ? 0 : this.projectId.hashCode());
        result2 = result2 * 31 + (this.analysisId == null ? 0 : this.analysisId.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportMetadata)) {
            return false;
        }
        ReportMetadata reportMetadata = (ReportMetadata)other;
        if (!Intrinsics.areEqual((Object)this.vcs, (Object)reportMetadata.vcs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tools, reportMetadata.tools)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectId, (Object)reportMetadata.projectId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.analysisId, (Object)reportMetadata.analysisId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\u001d\u001e\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J3\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\r\"\b\b\u0000\u0010\u0015*\u00020\u0001*\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0018H\u0082\bJ\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\b\u0012\u0004\u0012\u00020\u001c0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "extract", "Lorg/jetbrains/qodana/publisher/ReportMetadata;", "config", "Lorg/jetbrains/qodana/publisher/Config;", "publisherReportFiles", "", "Lorg/jetbrains/qodana/publisher/schemas/PublisherReportFile;", "(Lorg/jetbrains/qodana/publisher/Config;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractIdea", "metaPath", "Ljava/nio/file/Path;", "extractSarif", "collectRuns", "T", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "get", "Lkotlin/Function1;", "Lcom/jetbrains/qodana/sarif/model/Run;", "extractVcs", "Lorg/jetbrains/qodana/publisher/schemas/PublisherVcs;", "Lcom/jetbrains/qodana/sarif/model/VersionControlDetails;", "Attributes", "IdeaMetaData", "SarifIdeaVcs", "SarifVcs", "publisher"})
    @SourceDebugExtension(value={"SMAP\nReportMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportMetadata.kt\norg/jetbrains/qodana/publisher/ReportMetadata$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n102#1,2:178\n104#1:181\n105#1:183\n106#1:185\n102#1,2:186\n104#1:189\n105#1:191\n106#1:193\n102#1,2:194\n104#1:197\n105#1:199\n106#1:201\n102#1,2:202\n104#1:205\n105#1:207\n106#1:209\n96#2:176\n1#3:177\n1#3:182\n1#3:190\n1#3:198\n1#3:206\n1855#4:180\n1856#4:184\n1855#4:188\n1856#4:192\n1855#4:196\n1856#4:200\n1855#4:204\n1856#4:208\n1855#4,2:210\n*S KotlinDebug\n*F\n+ 1 ReportMetadata.kt\norg/jetbrains/qodana/publisher/ReportMetadata$Companion\n*L\n70#1:178,2\n70#1:181\n70#1:183\n70#1:185\n76#1:186,2\n76#1:189\n76#1:191\n76#1:193\n80#1:194,2\n80#1:197\n80#1:199\n80#1:201\n85#1:202,2\n85#1:205\n85#1:207\n85#1:209\n50#1:176\n70#1:182\n76#1:190\n80#1:198\n85#1:206\n70#1:180\n70#1:184\n76#1:188\n76#1:192\n80#1:196\n80#1:200\n85#1:204\n85#1:208\n103#1:210,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object extract(@NotNull Config config, @NotNull List<PublisherReportFile> publisherReportFiles, @NotNull Continuation<? super ReportMetadata> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReportMetadata>, Object>(config, publisherReportFiles, null){
                int label;
                final /* synthetic */ Config $config;
                final /* synthetic */ List<PublisherReportFile> $publisherReportFiles;
                {
                    this.$config = $config;
                    this.$publisherReportFiles = $publisherReportFiles;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            metaFile = this.$config.getReportType().getMetaFile();
                            $this$any$iv = this.$publisherReportFiles;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl12
                            v0 = false;
                            ** GOTO lbl19
lbl12:
                            // 2 sources

                            for (T element$iv : $this$any$iv) {
                                it = (PublisherReportFile)element$iv;
                                $i$a$-any-ReportMetadata$Companion$extract$2$1 = false;
                                if (!Intrinsics.areEqual((Object)metaFile, (Object)it.getName())) continue;
                                v0 = true;
                                ** GOTO lbl19
                            }
                            v0 = false;
lbl19:
                            // 3 sources

                            if (!v0) {
                                throw new PublisherParsingException("WARN: " + metaFile + " was not found", null, 2, null);
                            }
                            v1 = this.$config.getReportPath().resolve(metaFile);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                            metaPath = v1;
                            switch (extract.WhenMappings.$EnumSwitchMapping$0[this.$config.getReportType().ordinal()]) {
                                case 1: {
                                    v2 = org.jetbrains.qodana.publisher.ReportMetadata$Companion.access$extractIdea(ReportMetadata.Companion, metaPath);
                                    break;
                                }
                                case 2: {
                                    v2 = org.jetbrains.qodana.publisher.ReportMetadata$Companion.access$extractSarif(ReportMetadata.Companion, metaPath);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return v2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ReportMetadata> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        /*
         * WARNING - void declaration
         */
        private final ReportMetadata extractIdea(Path metaPath) {
            List<String> list2;
            void this_$iv;
            Json json2 = json;
            String string$iv = PathsKt.readText$default((Path)metaPath, null, (int)1, null);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            IdeaMetaData metadata = (IdeaMetaData)this_$iv.decodeFromString((DeserializationStrategy)IdeaMetaData.Companion.serializer(), string$iv);
            Object object = metadata.getAttributes();
            PublisherVcs vcs = object != null && (object = ((Attributes)object).getVcs()) != null && (object = ((SarifIdeaVcs)object).getSarifIdea()) != null ? ((SarifVcs)object).toVcs() : null;
            List<String> list3 = metadata.getTools();
            if (list3 != null) {
                List<String> list4;
                List<String> it = list4 = list3;
                boolean bl = false;
                list2 = !((Collection)it).isEmpty() ? list4 : null;
            } else {
                list2 = null;
            }
            List<String> tools = list2;
            Attributes attributes = metadata.getAttributes();
            String projectId = attributes != null ? attributes.getDeviceId() : null;
            return new ReportMetadata(vcs, tools, projectId, null);
        }

        /*
         * WARNING - void declaration
         */
        private final ReportMetadata extractSarif(Path metaPath) {
            void $this$collectRuns$iv;
            List list2;
            void $this$collectRuns$iv2;
            void $this$collectRuns$iv3;
            Companion $this$collectRuns$iv4;
            List list3;
            SarifReport sarifReport;
            try {
                sarifReport = SarifUtil.readReport(metaPath, false);
                Intrinsics.checkNotNull((Object)sarifReport);
            }
            catch (Exception e) {
                throw new PublisherParsingException("Failed reading SARIF report: " + e.getMessage(), e);
            }
            SarifReport report2 = sarifReport;
            Companion e = this;
            SarifReport sarifReport2 = report2;
            Companion companion = this;
            boolean $i$f$collectRuns22 = false;
            List $this$collectRuns_u24lambda_u2410$iv = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            List<Run> list4 = ((SarifReport)((Object)$this$collectRuns$iv4)).getRuns();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getRuns(...)");
            Iterable $this$forEach$iv$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Set<VersionControlDetails> it$iv;
                Run run$iv = (Run)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)run$iv);
                Run it = run$iv;
                boolean bl3 = false;
                if (it.getVersionControlProvenance() == null) continue;
                boolean bl4 = false;
                $this$collectRuns_u24lambda_u2410$iv.add(it$iv);
            }
            PublisherVcs vcs = companion.extractVcs(CollectionsKt.filterNotNull((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.build((List)list3))));
            $this$collectRuns$iv4 = this;
            SarifReport $i$f$collectRuns22 = report2;
            boolean $i$f$collectRuns = false;
            List $this$collectRuns_u24lambda_u2410$iv2 = $this$collectRuns_u24lambda_u2410$iv = CollectionsKt.createListBuilder();
            $i$a$-buildList-ReportMetadata$Companion$collectRuns$1$iv = false;
            List<Run> list5 = $this$collectRuns$iv3.getRuns();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"getRuns(...)");
            Iterable $this$forEach$iv$iv2 = list5;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv2) {
                String it$iv;
                Run run$iv = (Run)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)run$iv);
                Run it = run$iv;
                boolean bl6 = false;
                PropertyOwner propertyOwner = it.getTool();
                if ((propertyOwner != null && (propertyOwner = ((Tool)propertyOwner).getDriver()) != null ? ((ToolComponent)propertyOwner).getFullName() : null) == null) continue;
                it$iv = it$iv;
                boolean bl7 = false;
                $this$collectRuns_u24lambda_u2410$iv2.add(it$iv);
            }
            List this_$iv = CollectionsKt.build((List)$this$collectRuns_u24lambda_u2410$iv);
            Object it = this_$iv;
            boolean $i$a$-takeIf-ReportMetadata$Companion$extractSarif$tools$32 = false;
            List tools = !((Collection)it).isEmpty() ? this_$iv : null;
            it = this;
            SarifReport $i$a$-takeIf-ReportMetadata$Companion$extractSarif$tools$32 = report2;
            boolean $i$f$collectRuns3 = false;
            List $this$collectRuns_u24lambda_u2410$iv3 = $this$collectRuns_u24lambda_u2410$iv2 = CollectionsKt.createListBuilder();
            $i$a$-buildList-ReportMetadata$Companion$collectRuns$1$iv = false;
            List<Run> list6 = $this$collectRuns$iv2.getRuns();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"getRuns(...)");
            Iterable $this$forEach$iv$iv3 = list6;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv3) {
                String it$iv;
                Run run$iv = (Run)element$iv$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNull((Object)run$iv);
                Run it2 = run$iv;
                boolean bl9 = false;
                PropertyBag propertyBag = it2.getProperties();
                if ((String)(propertyBag != null ? propertyBag.get("deviceId") : null) == null) continue;
                boolean bl10 = false;
                $this$collectRuns_u24lambda_u2410$iv3.add(it$iv);
            }
            Object this_$iv2 = CollectionsKt.singleOrNull((List)CollectionsKt.build((List)$this$collectRuns_u24lambda_u2410$iv2));
            Object it3 = (String)this_$iv2;
            boolean $i$a$-also-ReportMetadata$Companion$extractSarif$projectId$32 = false;
            if (it3 == null) {
                logger.warn("Exactly one \"deviceId\" expected in qodana.sarif.json");
            }
            String projectId = (String)this_$iv2;
            it3 = this;
            SarifReport $i$a$-also-ReportMetadata$Companion$extractSarif$projectId$32 = report2;
            boolean $i$f$collectRuns4 = false;
            List $this$collectRuns_u24lambda_u2410$iv4 = list2 = CollectionsKt.createListBuilder();
            $i$a$-buildList-ReportMetadata$Companion$collectRuns$1$iv = false;
            List<Run> list7 = $this$collectRuns$iv.getRuns();
            Intrinsics.checkNotNullExpressionValue(list7, (String)"getRuns(...)");
            Iterable $this$forEach$iv$iv4 = list7;
            boolean $i$f$forEach4 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv4) {
                String it$iv;
                Run run$iv = (Run)element$iv$iv;
                boolean bl11 = false;
                Intrinsics.checkNotNull((Object)run$iv);
                Run it4 = run$iv;
                boolean bl12 = false;
                RunAutomationDetails runAutomationDetails = it4.getAutomationDetails();
                if ((runAutomationDetails != null ? runAutomationDetails.getGuid() : null) == null) continue;
                it$iv = it$iv;
                boolean bl13 = false;
                $this$collectRuns_u24lambda_u2410$iv4.add(it$iv);
            }
            Object object = CollectionsKt.singleOrNull((List)CollectionsKt.build((List)list2));
            String it5 = (String)object;
            boolean bl14 = false;
            if (it5 == null) {
                logger.warn("One or zero \"automationDetails.guid\" expected in qodana.sarif.json");
            }
            String analysisId = (String)object;
            return new ReportMetadata(vcs, tools, projectId, analysisId);
        }

        private final <T> List<T> collectRuns(SarifReport $this$collectRuns, Function1<? super Run, ? extends T> get) {
            List list2;
            boolean $i$f$collectRuns = false;
            List $this$collectRuns_u24lambda_u2410 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            List<Run> list3 = $this$collectRuns.getRuns();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getRuns(...)");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object it;
                Run run2 = (Run)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)run2);
                if (get.invoke((Object)run2) == null) continue;
                boolean bl3 = false;
                $this$collectRuns_u24lambda_u2410.add(it);
            }
            return CollectionsKt.build((List)list2);
        }

        private final PublisherVcs extractVcs(List<? extends VersionControlDetails> $this$extractVcs) {
            PublisherAuthor publisherAuthor;
            VersionControlDetails versionControlDetails = (VersionControlDetails)CollectionsKt.singleOrNull($this$extractVcs);
            if (versionControlDetails == null) {
                return null;
            }
            VersionControlDetails vcs = versionControlDetails;
            String commit = vcs.getRevisionId();
            String branch = vcs.getBranch();
            PropertyBag propertyBag = vcs.getProperties();
            if (propertyBag != null) {
                PropertyBag it = propertyBag;
                boolean bl = false;
                String string = (String)it.get("lastAuthorName");
                if (string == null) {
                    publisherAuthor = null;
                } else {
                    String name = string;
                    String string2 = (String)it.get("lastAuthorEmail");
                    if (string2 == null) {
                        publisherAuthor = null;
                    } else {
                        String email = string2;
                        publisherAuthor = new PublisherAuthor(name, email);
                    }
                }
            } else {
                publisherAuthor = null;
            }
            PublisherAuthor author = publisherAuthor;
            URI uRI = vcs.getRepositoryUri();
            return new PublisherVcs(commit, branch, author, uRI != null ? uRI.toString() : null);
        }

        public static final /* synthetic */ ReportMetadata access$extractIdea(Companion $this, Path metaPath) {
            return $this.extractIdea(metaPath);
        }

        public static final /* synthetic */ ReportMetadata access$extractSarif(Companion $this, Path metaPath) {
            return $this.extractSarif(metaPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Serializable
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0083\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J!\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u00c7\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;", "", "seen1", "", "deviceId", "", "vcs", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;)V", "getDeviceId", "()Ljava/lang/String;", "getVcs", "()Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "publisher"})
        private static final class Attributes {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private final String deviceId;
            @Nullable
            private final SarifIdeaVcs vcs;

            public Attributes(@Nullable String deviceId, @Nullable SarifIdeaVcs vcs) {
                this.deviceId = deviceId;
                this.vcs = vcs;
            }

            public /* synthetic */ Attributes(String string, SarifIdeaVcs sarifIdeaVcs, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    sarifIdeaVcs = null;
                }
                this(string, sarifIdeaVcs);
            }

            @Nullable
            public final String getDeviceId() {
                return this.deviceId;
            }

            @Nullable
            public final SarifIdeaVcs getVcs() {
                return this.vcs;
            }

            @Nullable
            public final String component1() {
                return this.deviceId;
            }

            @Nullable
            public final SarifIdeaVcs component2() {
                return this.vcs;
            }

            @NotNull
            public final Attributes copy(@Nullable String deviceId, @Nullable SarifIdeaVcs vcs) {
                return new Attributes(deviceId, vcs);
            }

            public static /* synthetic */ Attributes copy$default(Attributes attributes, String string, SarifIdeaVcs sarifIdeaVcs, int n, Object object) {
                if ((n & 1) != 0) {
                    string = attributes.deviceId;
                }
                if ((n & 2) != 0) {
                    sarifIdeaVcs = attributes.vcs;
                }
                return attributes.copy(string, sarifIdeaVcs);
            }

            @NotNull
            public String toString() {
                return "Attributes(deviceId=" + this.deviceId + ", vcs=" + this.vcs + ")";
            }

            public int hashCode() {
                int result2 = this.deviceId == null ? 0 : this.deviceId.hashCode();
                result2 = result2 * 31 + (this.vcs == null ? 0 : this.vcs.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Attributes)) {
                    return false;
                }
                Attributes attributes = (Attributes)other;
                if (!Intrinsics.areEqual((Object)this.deviceId, (Object)attributes.deviceId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.vcs, (Object)attributes.vcs);
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self(Attributes self, CompositeEncoder output, SerialDescriptor serialDesc) {
                if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.deviceId != null) {
                    output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.deviceId);
                }
                if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.vcs != null) {
                    output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)Companion$SarifIdeaVcs$$serializer.INSTANCE, (Object)self.vcs);
                }
            }

            @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
            public /* synthetic */ Attributes(int seen1, String deviceId, SarifIdeaVcs vcs, SerializationConstructorMarker serializationConstructorMarker) {
                if ((0 & seen1) != 0) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)Companion$Attributes$$serializer.INSTANCE.getDescriptor());
                }
                this.deviceId = (seen1 & 1) == 0 ? null : deviceId;
                this.vcs = (seen1 & 2) == 0 ? null : vcs;
            }

            public Attributes() {
                this(null, null, 3, null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;", "publisher"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Attributes> serializer() {
                    return (KSerializer)Companion$Attributes$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Serializable
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0083\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0001\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB#\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u00c7\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$IdeaMetaData;", "", "seen1", "", "tools", "", "", "attributes", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/util/List;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;)V", "getAttributes", "()Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$Attributes;", "getTools$annotations", "()V", "getTools", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "publisher"})
        private static final class IdeaMetaData {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private final List<String> tools;
            @Nullable
            private final Attributes attributes;

            public IdeaMetaData(@Nullable List<String> tools, @Nullable Attributes attributes) {
                this.tools = tools;
                this.attributes = attributes;
            }

            public /* synthetic */ IdeaMetaData(List list2, Attributes attributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    list2 = null;
                }
                if ((n & 2) != 0) {
                    attributes = null;
                }
                this(list2, attributes);
            }

            @Nullable
            public final List<String> getTools() {
                return this.tools;
            }

            @SerialName(value="tools inspection")
            @Serializable(with=MapKeysSerializer.class)
            public static /* synthetic */ void getTools$annotations() {
            }

            @Nullable
            public final Attributes getAttributes() {
                return this.attributes;
            }

            @Nullable
            public final List<String> component1() {
                return this.tools;
            }

            @Nullable
            public final Attributes component2() {
                return this.attributes;
            }

            @NotNull
            public final IdeaMetaData copy(@Nullable List<String> tools, @Nullable Attributes attributes) {
                return new IdeaMetaData(tools, attributes);
            }

            public static /* synthetic */ IdeaMetaData copy$default(IdeaMetaData ideaMetaData, List list2, Attributes attributes, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = ideaMetaData.tools;
                }
                if ((n & 2) != 0) {
                    attributes = ideaMetaData.attributes;
                }
                return ideaMetaData.copy(list2, attributes);
            }

            @NotNull
            public String toString() {
                return "IdeaMetaData(tools=" + this.tools + ", attributes=" + this.attributes + ")";
            }

            public int hashCode() {
                int result2 = this.tools == null ? 0 : ((Object)this.tools).hashCode();
                result2 = result2 * 31 + (this.attributes == null ? 0 : this.attributes.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IdeaMetaData)) {
                    return false;
                }
                IdeaMetaData ideaMetaData = (IdeaMetaData)other;
                if (!Intrinsics.areEqual(this.tools, ideaMetaData.tools)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.attributes, (Object)ideaMetaData.attributes);
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self(IdeaMetaData self, CompositeEncoder output, SerialDescriptor serialDesc) {
                if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.tools != null) {
                    output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)MapKeysSerializer.INSTANCE, self.tools);
                }
                if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.attributes != null) {
                    output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)Companion$Attributes$$serializer.INSTANCE, (Object)self.attributes);
                }
            }

            @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
            public /* synthetic */ IdeaMetaData(int seen1, @SerialName(value="tools inspection") @Serializable(with=MapKeysSerializer.class) List tools, Attributes attributes, SerializationConstructorMarker serializationConstructorMarker) {
                if ((0 & seen1) != 0) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)Companion$IdeaMetaData$$serializer.INSTANCE.getDescriptor());
                }
                this.tools = (seen1 & 1) == 0 ? null : tools;
                this.attributes = (seen1 & 2) == 0 ? null : attributes;
            }

            public IdeaMetaData() {
                this(null, null, 3, null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$IdeaMetaData$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$IdeaMetaData;", "publisher"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<IdeaMetaData> serializer() {
                    return (KSerializer)Companion$IdeaMetaData$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Serializable
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0083\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u00c7\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;", "", "seen1", "", "sarifIdea", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;)V", "getSarifIdea", "()Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "publisher"})
        private static final class SarifIdeaVcs {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final SarifVcs sarifIdea;

            public SarifIdeaVcs(@NotNull SarifVcs sarifIdea) {
                Intrinsics.checkNotNullParameter((Object)sarifIdea, (String)"sarifIdea");
                this.sarifIdea = sarifIdea;
            }

            @NotNull
            public final SarifVcs getSarifIdea() {
                return this.sarifIdea;
            }

            @NotNull
            public final SarifVcs component1() {
                return this.sarifIdea;
            }

            @NotNull
            public final SarifIdeaVcs copy(@NotNull SarifVcs sarifIdea) {
                Intrinsics.checkNotNullParameter((Object)sarifIdea, (String)"sarifIdea");
                return new SarifIdeaVcs(sarifIdea);
            }

            public static /* synthetic */ SarifIdeaVcs copy$default(SarifIdeaVcs sarifIdeaVcs, SarifVcs sarifVcs, int n, Object object) {
                if ((n & 1) != 0) {
                    sarifVcs = sarifIdeaVcs.sarifIdea;
                }
                return sarifIdeaVcs.copy(sarifVcs);
            }

            @NotNull
            public String toString() {
                return "SarifIdeaVcs(sarifIdea=" + this.sarifIdea + ")";
            }

            public int hashCode() {
                return this.sarifIdea.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SarifIdeaVcs)) {
                    return false;
                }
                SarifIdeaVcs sarifIdeaVcs = (SarifIdeaVcs)other;
                return Intrinsics.areEqual((Object)this.sarifIdea, (Object)sarifIdeaVcs.sarifIdea);
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self(SarifIdeaVcs self, CompositeEncoder output, SerialDescriptor serialDesc) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)Companion$SarifVcs$$serializer.INSTANCE, (Object)self.sarifIdea);
            }

            @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
            public /* synthetic */ SarifIdeaVcs(int seen1, SarifVcs sarifIdea, SerializationConstructorMarker serializationConstructorMarker) {
                if (1 != (1 & seen1)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)1, (SerialDescriptor)Companion$SarifIdeaVcs$$serializer.INSTANCE.getDescriptor());
                }
                this.sarifIdea = sarifIdea;
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifIdeaVcs;", "publisher"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<SarifIdeaVcs> serializer() {
                    return (KSerializer)Companion$SarifIdeaVcs$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Serializable
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 (2\u00020\u0001:\u0003'()BA\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB5\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ!\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u00c7\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;", "", "seen1", "", "repositoryUri", "", "revisionId", "branch", "properties", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;)V", "getBranch", "()Ljava/lang/String;", "getProperties", "()Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;", "getRepositoryUri", "getRevisionId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "toVcs", "Lorg/jetbrains/qodana/publisher/schemas/PublisherVcs;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "Properties", "publisher"})
        private static final class SarifVcs {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private final String repositoryUri;
            @Nullable
            private final String revisionId;
            @Nullable
            private final String branch;
            @Nullable
            private final Properties properties;

            public SarifVcs(@Nullable String repositoryUri, @Nullable String revisionId, @Nullable String branch, @Nullable Properties properties) {
                this.repositoryUri = repositoryUri;
                this.revisionId = revisionId;
                this.branch = branch;
                this.properties = properties;
            }

            public /* synthetic */ SarifVcs(String string, String string2, String string3, Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                if ((n & 8) != 0) {
                    properties = null;
                }
                this(string, string2, string3, properties);
            }

            @Nullable
            public final String getRepositoryUri() {
                return this.repositoryUri;
            }

            @Nullable
            public final String getRevisionId() {
                return this.revisionId;
            }

            @Nullable
            public final String getBranch() {
                return this.branch;
            }

            @Nullable
            public final Properties getProperties() {
                return this.properties;
            }

            @NotNull
            public final PublisherVcs toVcs() {
                PublisherAuthor publisherAuthor;
                Properties properties = this.properties;
                if (properties != null) {
                    Properties $this$toVcs_u24lambda_u242 = properties;
                    boolean bl = false;
                    String string = $this$toVcs_u24lambda_u242.getLastAuthorEmail();
                    if (string != null) {
                        String email = string;
                        boolean bl2 = false;
                        String string2 = $this$toVcs_u24lambda_u242.getLastAuthorName();
                        if (string2 != null) {
                            String name = string2;
                            boolean bl3 = false;
                            publisherAuthor = new PublisherAuthor(name, email);
                        } else {
                            publisherAuthor = null;
                        }
                    } else {
                        publisherAuthor = null;
                    }
                } else {
                    publisherAuthor = null;
                }
                PublisherAuthor author = publisherAuthor;
                String string = this.branch;
                String string3 = this.revisionId;
                String string4 = this.repositoryUri;
                return new PublisherVcs(string3, string, author, string4);
            }

            @Nullable
            public final String component1() {
                return this.repositoryUri;
            }

            @Nullable
            public final String component2() {
                return this.revisionId;
            }

            @Nullable
            public final String component3() {
                return this.branch;
            }

            @Nullable
            public final Properties component4() {
                return this.properties;
            }

            @NotNull
            public final SarifVcs copy(@Nullable String repositoryUri, @Nullable String revisionId, @Nullable String branch, @Nullable Properties properties) {
                return new SarifVcs(repositoryUri, revisionId, branch, properties);
            }

            public static /* synthetic */ SarifVcs copy$default(SarifVcs sarifVcs, String string, String string2, String string3, Properties properties, int n, Object object) {
                if ((n & 1) != 0) {
                    string = sarifVcs.repositoryUri;
                }
                if ((n & 2) != 0) {
                    string2 = sarifVcs.revisionId;
                }
                if ((n & 4) != 0) {
                    string3 = sarifVcs.branch;
                }
                if ((n & 8) != 0) {
                    properties = sarifVcs.properties;
                }
                return sarifVcs.copy(string, string2, string3, properties);
            }

            @NotNull
            public String toString() {
                return "SarifVcs(repositoryUri=" + this.repositoryUri + ", revisionId=" + this.revisionId + ", branch=" + this.branch + ", properties=" + this.properties + ")";
            }

            public int hashCode() {
                int result2 = this.repositoryUri == null ? 0 : this.repositoryUri.hashCode();
                result2 = result2 * 31 + (this.revisionId == null ? 0 : this.revisionId.hashCode());
                result2 = result2 * 31 + (this.branch == null ? 0 : this.branch.hashCode());
                result2 = result2 * 31 + (this.properties == null ? 0 : this.properties.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SarifVcs)) {
                    return false;
                }
                SarifVcs sarifVcs = (SarifVcs)other;
                if (!Intrinsics.areEqual((Object)this.repositoryUri, (Object)sarifVcs.repositoryUri)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.revisionId, (Object)sarifVcs.revisionId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.branch, (Object)sarifVcs.branch)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.properties, (Object)sarifVcs.properties);
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self(SarifVcs self, CompositeEncoder output, SerialDescriptor serialDesc) {
                if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.repositoryUri != null) {
                    output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.repositoryUri);
                }
                if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.revisionId != null) {
                    output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.revisionId);
                }
                if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.branch != null) {
                    output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.branch);
                }
                if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.properties != null) {
                    output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)Companion$SarifVcs$Properties$$serializer.INSTANCE, (Object)self.properties);
                }
            }

            @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
            public /* synthetic */ SarifVcs(int seen1, String repositoryUri, String revisionId, String branch, Properties properties, SerializationConstructorMarker serializationConstructorMarker) {
                if ((0 & seen1) != 0) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)Companion$SarifVcs$$serializer.INSTANCE.getDescriptor());
                }
                this.repositoryUri = (seen1 & 1) == 0 ? null : repositoryUri;
                this.revisionId = (seen1 & 2) == 0 ? null : revisionId;
                this.branch = (seen1 & 4) == 0 ? null : branch;
                this.properties = (seen1 & 8) == 0 ? null : properties;
            }

            public SarifVcs() {
                this(null, null, null, null, 15, null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs;", "publisher"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<SarifVcs> serializer() {
                    return (KSerializer)Companion$SarifVcs$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Serializable
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u001d\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c7\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;", "", "seen1", "", "lastAuthorName", "", "lastAuthorEmail", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getLastAuthorEmail", "()Ljava/lang/String;", "getLastAuthorName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "publisher"})
            public static final class Properties {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @Nullable
                private final String lastAuthorName;
                @Nullable
                private final String lastAuthorEmail;

                public Properties(@Nullable String lastAuthorName, @Nullable String lastAuthorEmail) {
                    this.lastAuthorName = lastAuthorName;
                    this.lastAuthorEmail = lastAuthorEmail;
                }

                public /* synthetic */ Properties(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        string = null;
                    }
                    if ((n & 2) != 0) {
                        string2 = null;
                    }
                    this(string, string2);
                }

                @Nullable
                public final String getLastAuthorName() {
                    return this.lastAuthorName;
                }

                @Nullable
                public final String getLastAuthorEmail() {
                    return this.lastAuthorEmail;
                }

                @Nullable
                public final String component1() {
                    return this.lastAuthorName;
                }

                @Nullable
                public final String component2() {
                    return this.lastAuthorEmail;
                }

                @NotNull
                public final Properties copy(@Nullable String lastAuthorName, @Nullable String lastAuthorEmail) {
                    return new Properties(lastAuthorName, lastAuthorEmail);
                }

                public static /* synthetic */ Properties copy$default(Properties properties, String string, String string2, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = properties.lastAuthorName;
                    }
                    if ((n & 2) != 0) {
                        string2 = properties.lastAuthorEmail;
                    }
                    return properties.copy(string, string2);
                }

                @NotNull
                public String toString() {
                    return "Properties(lastAuthorName=" + this.lastAuthorName + ", lastAuthorEmail=" + this.lastAuthorEmail + ")";
                }

                public int hashCode() {
                    int result2 = this.lastAuthorName == null ? 0 : this.lastAuthorName.hashCode();
                    result2 = result2 * 31 + (this.lastAuthorEmail == null ? 0 : this.lastAuthorEmail.hashCode());
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Properties)) {
                        return false;
                    }
                    Properties properties = (Properties)other;
                    if (!Intrinsics.areEqual((Object)this.lastAuthorName, (Object)properties.lastAuthorName)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.lastAuthorEmail, (Object)properties.lastAuthorEmail);
                }

                @JvmStatic
                public static final /* synthetic */ void write$Self(Properties self, CompositeEncoder output, SerialDescriptor serialDesc) {
                    if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.lastAuthorName != null) {
                        output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.lastAuthorName);
                    }
                    if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.lastAuthorEmail != null) {
                        output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.lastAuthorEmail);
                    }
                }

                @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
                public /* synthetic */ Properties(int seen1, String lastAuthorName, String lastAuthorEmail, SerializationConstructorMarker serializationConstructorMarker) {
                    if ((0 & seen1) != 0) {
                        PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)Companion$SarifVcs$Properties$$serializer.INSTANCE.getDescriptor());
                    }
                    this.lastAuthorName = (seen1 & 1) == 0 ? null : lastAuthorName;
                    this.lastAuthorEmail = (seen1 & 2) == 0 ? null : lastAuthorEmail;
                }

                public Properties() {
                    this(null, null, 3, null);
                }

                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/qodana/publisher/ReportMetadata$Companion$SarifVcs$Properties;", "publisher"})
                public static final class Companion {
                    private Companion() {
                    }

                    @NotNull
                    public final KSerializer<Properties> serializer() {
                        return (KSerializer)Companion$SarifVcs$Properties$$serializer.INSTANCE;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }
        }
    }
}

