/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.TemplatesKt;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/ConstructorMethodRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "factory", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "Lorg/jetbrains/annotations/NotNull;", "getFactory", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "execute", "", "setupTemplate", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "renderConstructor", "insertConstructor", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nCreateConstructorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateConstructorAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/ConstructorMethodRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n37#2,2:88\n37#2,2:90\n*S KotlinDebug\n*F\n+ 1 CreateConstructorAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/ConstructorMethodRenderer\n*L\n56#1:88,2\n57#1:90,2\n*E\n"})
final class ConstructorMethodRenderer {
    @NotNull
    private final Project project;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateConstructorRequest request;
    @NotNull
    private final GroovyPsiElementFactory factory;

    public ConstructorMethodRenderer(@NotNull Project project, @NotNull GrTypeDefinition targetClass, @NotNull CreateConstructorRequest request) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project;
        this.targetClass = targetClass;
        this.request = request;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
        this.factory = groovyPsiElementFactory;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateConstructorRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final GroovyPsiElementFactory getFactory() {
        return this.factory;
    }

    public final void execute() {
        GrMethod constructor = this.renderConstructor();
        constructor = this.insertConstructor(constructor);
        GrMethod grMethod = (GrMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)constructor);
        if (grMethod == null) {
            return;
        }
        constructor = grMethod;
        this.setupTemplate(constructor);
    }

    private final void setupTemplate(GrMethod method) {
        List list = this.request.getExpectedParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpectedParameters(...)");
        List parameters = list;
        Collection $this$toTypedArray$iv = TemplatesKt.setupParameters(method, parameters);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ChooseTypeExpression[] typeExpressions = thisCollection$iv.toArray(new ChooseTypeExpression[0]);
        Collection $this$toTypedArray$iv2 = TemplatesKt.setupNameExpressions(parameters, this.project);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        ParameterNameExpression[] nameExpressions = thisCollection$iv2.toArray(new ParameterNameExpression[0]);
        IntentionUtils.createTemplateForMethod(typeExpressions, nameExpressions, method, this.targetClass, null, true, this.request.isStartTemplate(), null);
    }

    @NotNull
    public final GrMethod renderConstructor() {
        GrMethod grMethod = this.factory.createConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)grMethod, (String)"createConstructor(...)");
        GrMethod constructor = grMethod;
        String name = this.targetClass.getName();
        if (name != null) {
            constructor.setName(name);
        }
        Collection collection = this.request.getModifiers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getModifiers(...)");
        List modifiersToRender = CollectionsKt.toMutableList((Collection)collection);
        ((Collection)modifiersToRender).remove(JvmModifier.PUBLIC);
        for (JvmModifier modifier : modifiersToRender) {
            GrModifierList grModifierList = constructor.getModifierList();
            Intrinsics.checkNotNull((Object)modifier);
            grModifierList.setModifierProperty(JvmPsiUtilKt.toPsiModifier(modifier), true);
        }
        for (AnnotationRequest annotation : this.request.getAnnotations()) {
            constructor.getModifierList().addAnnotation(annotation.getQualifiedName());
        }
        return constructor;
    }

    private final GrMethod insertConstructor(GrMethod method) {
        PsiElement psiElement = this.targetClass.add(method);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        return (GrMethod)psiElement;
    }
}

