/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.options;

import java.util.prefs.Preferences;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.openide.filesystems.FileObject;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public abstract class HintsSettings {
    private static final String ENABLED_KEY = "enabled";
    private static final String OLD_SEVERITY_KEY = "severity";
    private static final String NEW_SEVERITY_KEY = "hintSeverity";
    private static final String DEFAULT_PROFILE = "default";
    private static final String PREFERENCES_LOCATION = "org/netbeans/modules/java/hints";
    private static final HintsSettings GLOBAL_SETTINGS = HintsSettings.createPreferencesBasedHintsSettings(NbPreferences.root().node("org/netbeans/modules/java/hints").node("default"), true, null);

    public abstract boolean isEnabled(HintMetadata var1);

    public abstract void setEnabled(HintMetadata var1, boolean var2);

    public abstract Preferences getHintPreferences(HintMetadata var1);

    public abstract Severity getSeverity(HintMetadata var1);

    public abstract void setSeverity(HintMetadata var1, Severity var2);

    public static HintsSettings createPreferencesBasedHintsSettings(Preferences preferences, boolean useDefaultEnabled, Severity overrideSeverity) {
        return new PreferencesBasedHintsSettings(preferences, useDefaultEnabled, overrideSeverity);
    }

    public static HintsSettings getSettingsFor(FileObject file) {
        return HintsSettings.createPreferencesBasedHintsSettings(FileHintPreferences.getFilePreferences((FileObject)file, (String)"text/x-java"), true, null);
    }

    public static HintsSettings getGlobalSettings() {
        return GLOBAL_SETTINGS;
    }

    private static final class PreferencesBasedHintsSettings
    extends HintsSettings {
        private final Preferences preferences;
        private final boolean useDefaultEnabled;
        private final Severity overrideSeverity;

        public PreferencesBasedHintsSettings(Preferences preferences, boolean useDefaultEnabled, Severity overrideSeverity) {
            Parameters.notNull((CharSequence)"preferences", (Object)preferences);
            this.preferences = preferences;
            this.useDefaultEnabled = useDefaultEnabled;
            this.overrideSeverity = overrideSeverity;
        }

        @Override
        public boolean isEnabled(HintMetadata hint) {
            return this.getHintPreferences(hint).getBoolean(HintsSettings.ENABLED_KEY, this.useDefaultEnabled && hint.enabled);
        }

        @Override
        public void setEnabled(HintMetadata hint, boolean value) {
            this.getHintPreferences(hint).putBoolean(HintsSettings.ENABLED_KEY, value);
        }

        @Override
        public Preferences getHintPreferences(HintMetadata hint) {
            return this.preferences.node(hint.id);
        }

        @Override
        public Severity getSeverity(HintMetadata hint) {
            Preferences prefs = this.getHintPreferences(hint);
            String s = prefs.get(HintsSettings.NEW_SEVERITY_KEY, null);
            if (s != null) {
                return Severity.valueOf((String)s);
            }
            s = prefs.get(HintsSettings.OLD_SEVERITY_KEY, null);
            if (s == null) {
                return this.overrideSeverity != null ? this.overrideSeverity : (hint != null ? hint.severity : null);
            }
            return switch (s) {
                case "ERROR" -> Severity.ERROR;
                case "WARNING" -> Severity.VERIFIER;
                case "CURRENT_LINE_WARNING" -> Severity.HINT;
                default -> this.overrideSeverity != null ? this.overrideSeverity : (hint != null ? hint.severity : null);
            };
        }

        @Override
        public void setSeverity(HintMetadata hint, Severity severity) {
            this.getHintPreferences(hint).put(HintsSettings.NEW_SEVERITY_KEY, severity.name());
        }
    }

    public static class GlobalSettingsProvider
    implements FileHintPreferences.GlobalHintPreferencesProvider {
        public Preferences getGlobalPreferences() {
            return NbPreferences.root().node(HintsSettings.PREFERENCES_LOCATION).node(HintsSettings.DEFAULT_PROFILE);
        }
    }
}

