/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.CreatedModifiedFilesProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NameAndLocationPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.SelectLibraryPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;

public final class NewLibraryDescriptor
extends BasicWizardIterator {
    DataModel data;

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewLibraryDescriptor.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new SelectLibraryPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private Library library;
        private String libraryName;
        private String libraryDisplayName;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public Library getLibrary() {
            return this.library;
        }

        public void setLibrary(Library library) {
            this.library = library;
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public void setLibraryName(String libraryName) {
            this.libraryName = libraryName;
        }

        public boolean isValidLibraryName() {
            if (this.getLibraryName() == null || this.getLibraryName().trim().length() == 0 || this.getLibraryName().indexOf(47) != -1) {
                return false;
            }
            try {
                String path = CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(this.getLibraryName());
                new URI(path);
                LayerUtil.findGeneratedName(null, (String)path);
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }

        public String getLibraryDisplayName() {
            return this.libraryDisplayName;
        }

        public void setLibraryDisplayName(String libraryDisplayName) {
            this.libraryDisplayName = libraryDisplayName;
        }

        public boolean isValidLibraryDisplayName() {
            return this.getLibraryDisplayName() != null && this.getLibraryDisplayName().trim().length() != 0;
        }

        boolean libraryAlreadyExists() {
            FileSystem layerFs = null;
            LayerHandle handle = LayerHandle.forProject((Project)this.getProject());
            layerFs = handle.layer(false);
            return layerFs != null ? layerFs.findResource(CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(this.getLibraryName())) != null : false;
        }

        public DataModel cloneMe(WizardDescriptor wiz) {
            DataModel d = new DataModel(wiz);
            d.setLibrary(this.getLibrary());
            d.setPackageName(this.getPackageName());
            d.setCreatedModifiedFiles(this.getCreatedModifiedFiles());
            d.setLibraryDisplayName(this.getLibraryDisplayName());
            d.setLibraryName(this.getLibraryName());
            return d;
        }
    }
}

