/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Function;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.util.Parameters;

public class MetadataElementHandle<T extends MetadataElement> {
    private static final int CATALOG = 0;
    private static final int SCHEMA = 1;
    private static final int TABLE = 2;
    private static final int VIEW = 2;
    private static final int PROCEDURE = 2;
    private static final int COLUMN = 3;
    private static final int PARAMETER = 3;
    private static final int INDEX = 3;
    private static final int FOREIGN_KEY = 3;
    private static final int FOREIGN_KEY_COLUMN = 4;
    private static final int INDEX_COLUMN = 4;
    private static final int FUNCTION = 2;
    private final String[] names;
    private final Kind[] kinds;

    public static <T extends MetadataElement> MetadataElementHandle<T> create(T element) {
        Parameters.notNull((CharSequence)"element", element);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Kind> kinds = new ArrayList<Kind>();
        for (Object current = element; current != null; current = current.getParent()) {
            names.add(current.getInternalName());
            kinds.add(Kind.of(current));
        }
        Collections.reverse(names);
        Collections.reverse(kinds);
        String[] namesArray = names.toArray(new String[0]);
        Kind[] kindsArray = kinds.toArray(new Kind[0]);
        return new MetadataElementHandle<T>(namesArray, kindsArray);
    }

    static <T extends MetadataElement> MetadataElementHandle<T> create(Class<T> clazz, String[] names, Kind[] kinds) {
        return new MetadataElementHandle<T>(names, kinds);
    }

    private MetadataElementHandle(String[] names, Kind[] kinds) {
        this.names = names;
        this.kinds = kinds;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataElementHandle other = (MetadataElementHandle)obj;
        if (!Arrays.equals((Object[])this.kinds, (Object[])other.kinds)) {
            return false;
        }
        return Arrays.equals(this.names, other.names);
    }

    public int hashCode() {
        int hash = 7;
        for (String string : this.names) {
            if (string != null) {
                hash ^= string.hashCode();
                continue;
            }
            ++hash;
        }
        for (Kind kind : this.kinds) {
            hash ^= kind.hashCode();
        }
        return hash;
    }

    public T resolve(Metadata metadata) {
        int length = this.kinds.length;
        switch (this.kinds[length - 1]) {
            case CATALOG: {
                return (T)this.resolveCatalog(metadata);
            }
            case SCHEMA: {
                return (T)this.resolveSchema(metadata);
            }
            case TABLE: {
                return (T)this.resolveTable(metadata);
            }
            case VIEW: {
                return (T)this.resolveView(metadata);
            }
            case PROCEDURE: {
                return (T)this.resolveProcedure(metadata);
            }
            case COLUMN: {
                return (T)this.resolveColumn(metadata);
            }
            case PRIMARY_KEY: {
                return (T)this.resolvePrimaryKey(metadata);
            }
            case PARAMETER: {
                return (T)this.resolveParameter(metadata);
            }
            case FOREIGN_KEY: {
                return (T)this.resolveForeignKey(metadata);
            }
            case INDEX: {
                return (T)this.resolveIndex(metadata);
            }
            case FOREIGN_KEY_COLUMN: {
                return (T)this.resolveForeignKeyColumn(metadata);
            }
            case INDEX_COLUMN: {
                return (T)this.resolveIndexColumn(metadata);
            }
            case RETURN_VALUE: {
                return (T)this.resolveReturnValue(metadata);
            }
            case FUNCTION: {
                return (T)this.resolveFunction(metadata);
            }
        }
        throw new IllegalStateException("Unhandled kind " + (Object)((Object)this.kinds[this.kinds.length - 1]));
    }

    private Catalog resolveCatalog(Metadata metadata) {
        return metadata.getCatalog(this.names[0]);
    }

    private Schema resolveSchema(Metadata metadata) {
        Catalog catalog = this.resolveCatalog(metadata);
        if (catalog != null) {
            String name = this.names[1];
            if (name != null) {
                return catalog.getSchema(name);
            }
            return catalog.getSyntheticSchema();
        }
        return null;
    }

    private Table resolveTable(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null) {
            return schema.getTable(this.names[2]);
        }
        return null;
    }

    private View resolveView(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null) {
            return schema.getView(this.names[2]);
        }
        return null;
    }

    private Procedure resolveProcedure(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null && this.kinds[2] == Kind.PROCEDURE) {
            return schema.getProcedure(this.names[2]);
        }
        return null;
    }

    private Function resolveFunction(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null && this.kinds[2] == Kind.FUNCTION) {
            return schema.getFunction(this.names[2]);
        }
        return null;
    }

    private Value resolveReturnValue(Metadata metadata) {
        Function proc = this.resolveFunction(metadata);
        if (proc != null) {
            return proc.getReturnValue();
        }
        Procedure proc2 = this.resolveProcedure(metadata);
        if (proc2 != null) {
            return proc2.getReturnValue();
        }
        return null;
    }

    private PrimaryKey resolvePrimaryKey(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getPrimaryKey();
        }
        return null;
    }

    private Column resolveColumn(Metadata metadata) {
        switch (this.kinds[2]) {
            case TABLE: {
                Table table = this.resolveTable(metadata);
                if (table != null) {
                    return table.getColumn(this.names[3]);
                }
                return null;
            }
            case PROCEDURE: {
                Procedure proc = this.resolveProcedure(metadata);
                if (proc != null) {
                    return proc.getColumn(this.names[3]);
                }
                return null;
            }
            case VIEW: {
                View view = this.resolveView(metadata);
                if (view != null) {
                    return view.getColumn(this.names[3]);
                }
                return null;
            }
        }
        throw new IllegalStateException("Unhandled kind " + (Object)((Object)this.kinds[2]));
    }

    private Parameter resolveParameter(Metadata metadata) {
        Procedure proc = this.resolveProcedure(metadata);
        if (proc != null) {
            return proc.getParameter(this.names[3]);
        }
        Function proc2 = this.resolveFunction(metadata);
        if (proc2 != null) {
            return proc2.getParameter(this.names[3]);
        }
        return null;
    }

    private Index resolveIndex(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getIndex(this.names[3]);
        }
        return null;
    }

    private ForeignKey resolveForeignKey(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getForeignKeyByInternalName(this.names[3]);
        }
        return null;
    }

    private ForeignKeyColumn resolveForeignKeyColumn(Metadata metadata) {
        ForeignKey key = this.resolveForeignKey(metadata);
        if (key != null) {
            return key.getColumn(this.names[4]);
        }
        return null;
    }

    private IndexColumn resolveIndexColumn(Metadata metadata) {
        Index index = this.resolveIndex(metadata);
        if (index != null) {
            return index.getColumn(this.names[4]);
        }
        return null;
    }

    static enum Kind {
        CATALOG(Catalog.class),
        SCHEMA(Schema.class),
        TABLE(Table.class),
        VIEW(View.class),
        PROCEDURE(Procedure.class),
        PARAMETER(Parameter.class),
        COLUMN(Column.class),
        PRIMARY_KEY(PrimaryKey.class),
        FOREIGN_KEY(ForeignKey.class),
        INDEX(Index.class),
        FOREIGN_KEY_COLUMN(ForeignKeyColumn.class),
        INDEX_COLUMN(IndexColumn.class),
        RETURN_VALUE(Value.class),
        FUNCTION(Function.class);

        private final Class<? extends MetadataElement> clazz;

        public static Kind of(MetadataElement element) {
            return Kind.of(element.getClass());
        }

        public static Kind of(Class<? extends MetadataElement> clazz) {
            for (Kind kind : Kind.values()) {
                if (!kind.clazz.equals(clazz)) continue;
                return kind;
            }
            throw new IllegalStateException("Unhandled class " + clazz);
        }

        private Kind(Class<? extends MetadataElement> clazz) {
            this.clazz = clazz;
        }
    }
}

