/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.logging.text.StyledTextOutput;

@Contextual
public class TaskConfigurationException
extends GradleException
implements FailureResolutionAware {
    private final String taskPath;

    public TaskConfigurationException(String taskPath, String message, Exception cause) {
        super(message, (Throwable)cause);
        this.taskPath = taskPath;
    }

    @Override
    public void appendResolutions(FailureResolutionAware.Context context) {
        context.appendResolution(output -> {
            output.text((Object)"Run ");
            context.getClientMetaData().describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), "help");
            output.withStyle(StyledTextOutput.Style.UserInput).format(" --task %s", new Object[]{this.taskPath});
            output.text((Object)" to get task usage details.");
        });
    }
}

