/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.CertifiedIdentity;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsX509CertifiedTarget;

public class TlsTrustManager
implements X509TrustManager {
    private static LogAdapter LOGGER = LogFactory.getLogger(TlsTrustManager.class);
    X509TrustManager trustManager;
    private boolean useClientMode;
    private TransportStateReference tmStateReference;
    private CounterSupport tlstmCounters;
    private TlsTmSecurityCallback<X509Certificate> securityCallback;

    public TlsTrustManager(X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference, CounterSupport tlstmCounters, TlsTmSecurityCallback<X509Certificate> securityCallback) {
        this.trustManager = trustManager;
        this.useClientMode = useClientMode;
        this.tmStateReference = tmStateReference;
        this.tlstmCounters = tlstmCounters;
        this.securityCallback = securityCallback;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (TransportStateReference.hasCertifiedIdentity(this.tmStateReference)) {
            OctetString fingerprint = ((CertifiedIdentity)((Object)this.tmStateReference.getTarget())).getClientFingerprint();
            if (this.isMatchingFingerprint(x509Certificates, fingerprint, false)) {
                return;
            }
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            throw new CertificateException("Client certificate validation by fingerprint failed for '" + String.valueOf(x509Certificates[0]) + "' (does not match " + fingerprint.toHexString() + ")");
        }
        TlsTmSecurityCallback<X509Certificate> callback = this.getSecurityCallback();
        try {
            if (!this.useClientMode && callback != null) {
                if (callback.isClientCertificateAccepted(x509Certificates[0])) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Client is trusted with certificate '" + String.valueOf(x509Certificates[0]) + "'");
                    }
                    return;
                }
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
                throw new CertificateException("Client certificate validation by fingerprint failed for '" + String.valueOf(x509Certificates[0]) + "'");
            }
            this.trustManager.checkClientTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            LOGGER.warn((Serializable)((Object)("Client certificate validation failed for '" + String.valueOf(x509Certificates[0]) + "':" + cex.getMessage())));
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        X500Principal x500Principal;
        OctetString fingerprint = null;
        if (TransportStateReference.hasCertifiedIdentity(this.tmStateReference) && this.isMatchingFingerprint(x509Certificates, fingerprint = ((CertifiedIdentity)((Object)this.tmStateReference.getTarget())).getServerFingerprint(), true)) {
            return;
        }
        Object entry = null;
        try {
            entry = TLSTMUtil.getSubjAltName(x509Certificates[0].getSubjectAlternativeNames(), 2);
        }
        catch (CertificateParsingException e) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            LOGGER.warn((Serializable)((Object)("CertificateParsingException while verifying server certificate " + String.valueOf(Arrays.asList(x509Certificates)))));
        }
        if (entry == null && (x500Principal = x509Certificates[0].getSubjectX500Principal()) != null) {
            entry = x500Principal.getName();
        }
        if (entry != null && fingerprint != null && fingerprint.length() == 0 && TransportStateReference.hasCertifiedIdentity(this.tmStateReference) && ((CertifiedIdentity)((Object)this.tmStateReference.getTarget())).getIdentity() != null) {
            String dNSName = ((String)entry).toLowerCase();
            String hostName = ((CertifiedIdentity)((Object)this.tmStateReference.getTarget())).getIdentity().toString();
            if (hostName.length() > 0) {
                if (hostName.charAt(0) == '*') {
                    int pos = dNSName.indexOf(46);
                    if (pos > 0) {
                        dNSName = dNSName.substring(pos);
                    }
                    hostName = hostName.substring(1);
                }
                if (hostName.equalsIgnoreCase(dNSName)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Peer hostname " + hostName + " matches dNSName " + dNSName);
                    }
                    return;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Peer hostname " + hostName + " did not match dNSName " + dNSName)));
            }
        }
        try {
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            LOGGER.warn((Serializable)((Object)("Server certificate validation failed for '" + String.valueOf(x509Certificates[0]) + "'")));
            throw cex;
        }
        TlsTmSecurityCallback<X509Certificate> callback = this.getSecurityCallback();
        if (this.useClientMode && callback != null && !callback.isServerCertificateAccepted(x509Certificates)) {
            LOGGER.info("Server is NOT trusted with certificate '" + String.valueOf(Arrays.asList(x509Certificates)) + "'");
            throw new CertificateException("Server's certificate is not trusted by this application (although it was trusted by the JRE): " + String.valueOf(Arrays.asList(x509Certificates)));
        }
    }

    private boolean isMatchingFingerprint(X509Certificate[] x509Certificates, OctetString fingerprint, boolean useClientMode) throws CertificateException {
        return TLSTMUtil.isMatchingFingerprint(x509Certificates, fingerprint, useClientMode, this.tlstmCounters, LOGGER, this);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return TlsTrustManager.getAcceptedIssuers(this.trustManager, this.getSecurityCallback());
    }

    public static X509Certificate[] getAcceptedIssuers(X509TrustManager trustManager, TlsTmSecurityCallback<X509Certificate> securityCallback) {
        X509Certificate[] accepted = trustManager.getAcceptedIssuers();
        if (accepted != null && securityCallback != null) {
            ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>(accepted.length);
            for (X509Certificate cert : accepted) {
                try {
                    if (!securityCallback.isAcceptedIssuer(cert)) continue;
                    acceptedIssuers.add(cert);
                }
                catch (CertificateException certex) {
                    LOGGER.debug((Serializable)((Object)("Security callback " + String.valueOf(securityCallback) + " rejected " + String.valueOf(cert) + ": " + certex.getMessage())));
                }
            }
            return acceptedIssuers.toArray(new X509Certificate[0]);
        }
        return accepted;
    }

    protected TlsTmSecurityCallback<X509Certificate> getSecurityCallback() {
        TlsX509CertifiedTarget tlsCertifiedTarget;
        if (TransportStateReference.hasCertifiedIdentity(this.tmStateReference) && this.tmStateReference.getTarget() instanceof TlsX509CertifiedTarget && (tlsCertifiedTarget = (TlsX509CertifiedTarget)this.tmStateReference.getTarget()) != null && tlsCertifiedTarget.getTlsTmSecurityCallback() != null) {
            return tlsCertifiedTarget.getTlsTmSecurityCallback();
        }
        return this.securityCallback;
    }
}

