/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public XrVector4f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVector4f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrVector4f.nx(this.address());
    }

    public float y() {
        return XrVector4f.ny(this.address());
    }

    public float z() {
        return XrVector4f.nz(this.address());
    }

    public float w() {
        return XrVector4f.nw(this.address());
    }

    public XrVector4f x(float value) {
        XrVector4f.nx(this.address(), value);
        return this;
    }

    public XrVector4f y(float value) {
        XrVector4f.ny(this.address(), value);
        return this;
    }

    public XrVector4f z(float value) {
        XrVector4f.nz(this.address(), value);
        return this;
    }

    public XrVector4f w(float value) {
        XrVector4f.nw(this.address(), value);
        return this;
    }

    public XrVector4f set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrVector4f set(XrVector4f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVector4f malloc() {
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrVector4f calloc() {
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrVector4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrVector4f create(long address) {
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)address);
    }

    @Nullable
    public static XrVector4f createSafe(long address) {
        return address == 0L ? null : (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrVector4f.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector4f.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrVector4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrVector4f malloc(MemoryStack stack) {
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVector4f calloc(MemoryStack stack) {
        return (XrVector4f)XrVector4f.wrap(XrVector4f.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVector4f.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrVector4f.__struct((Struct.Member[])new Struct.Member[]{XrVector4f.__member((int)4), XrVector4f.__member((int)4), XrVector4f.__member((int)4), XrVector4f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVector4f, Buffer>
    implements NativeResource {
        private static final XrVector4f ELEMENT_FACTORY = XrVector4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrVector4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrVector4f.nx(this.address());
        }

        public float y() {
            return XrVector4f.ny(this.address());
        }

        public float z() {
            return XrVector4f.nz(this.address());
        }

        public float w() {
            return XrVector4f.nw(this.address());
        }

        public Buffer x(float value) {
            XrVector4f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrVector4f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrVector4f.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            XrVector4f.nw(this.address(), value);
            return this;
        }
    }
}

