/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.metaserver;

import net.sf.freecol.common.util.Utils;

public class ServerInfo {
    public static final String TAG = "serverInfo";
    private String name;
    private String address;
    private int port;
    private int currentlyPlaying;
    private int slotsAvailable;
    private boolean isGameStarted;
    private String version;
    private int gameState;
    private long lastUpdated = -1L;

    public ServerInfo(String name, String address, int port, int slotsAvailable, int currentlyPlaying, boolean isGameStarted, String version, int gameState) {
        this.update(name, address, port, slotsAvailable, currentlyPlaying, isGameStarted, version, gameState);
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getCurrentlyPlaying() {
        return this.currentlyPlaying;
    }

    public int getSlotsAvailable() {
        return this.slotsAvailable;
    }

    public boolean getIsGameStarted() {
        return this.isGameStarted;
    }

    public String getVersion() {
        return this.version;
    }

    public int getGameState() {
        return this.gameState;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public final void update(String name, String address, int port, int slotsAvailable, int currentlyPlaying, boolean isGameStarted, String version, int gameState) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.slotsAvailable = slotsAvailable;
        this.currentlyPlaying = currentlyPlaying;
        this.isGameStarted = isGameStarted;
        this.version = version;
        this.gameState = gameState;
        this.lastUpdated = Utils.now();
    }

    public final void update(ServerInfo si) {
        this.update(si.getName(), si.getAddress(), si.getPort(), si.getSlotsAvailable(), si.getCurrentlyPlaying(), si.getIsGameStarted(), si.getVersion(), si.getGameState());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ServerInfo) {
            ServerInfo other = (ServerInfo)o;
            return Utils.equals(this.name, other.name) && Utils.equals(this.address, other.address) && this.port == other.port && this.currentlyPlaying == other.currentlyPlaying && this.slotsAvailable == other.slotsAvailable && this.isGameStarted == other.isGameStarted && Utils.equals(this.version, other.version) && this.gameState == other.gameState;
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.name);
        hash = 31 * hash + Utils.hashCode(this.address);
        hash = 31 * hash + this.port;
        hash = 31 * hash + this.currentlyPlaying;
        hash = 31 * hash + this.slotsAvailable;
        hash = 31 * hash + (this.isGameStarted ? 1 : 0);
        hash = 31 * hash + Utils.hashCode(this.version);
        hash = 31 * hash + this.gameState;
        return hash;
    }

    public String toString() {
        return this.name + " (" + this.address + ":" + this.port + ") " + this.currentlyPlaying + ", " + this.slotsAvailable + ", " + this.isGameStarted + ", " + this.version + ", " + this.gameState + ", " + this.lastUpdated;
    }
}

