/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmNullnessPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;

    public SqmNullnessPredicate(SqmExpression<?> expression, NodeBuilder nodeBuilder) {
        this(expression, false, nodeBuilder);
    }

    public SqmNullnessPredicate(SqmExpression<?> expression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
    }

    @Override
    public SqmNullnessPredicate copy(SqmCopyContext context) {
        SqmNullnessPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNullnessPredicate predicate = context.registerCopy(this, new SqmNullnessPredicate((SqmExpression<?>)this.expression.copy(context), this.isNegated(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitIsNullPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.expression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" is not null");
        } else {
            sb.append(" is null");
        }
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmNullnessPredicate(this.expression, !this.isNegated(), (NodeBuilder)this.nodeBuilder());
    }
}

