/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.context;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.MultiBundleWebContainerContext;
import org.ops4j.pax.web.service.spi.context.DefaultHttpContext;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMultiBundleWebContainerContext
implements MultiBundleWebContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMultiBundleWebContainerContext.class);
    private final DefaultHttpContext delegate;
    private final Queue<Bundle> bundles = new ConcurrentLinkedQueue<Bundle>();

    public DefaultMultiBundleWebContainerContext(DefaultHttpContext delegate) {
        this.delegate = delegate;
    }

    public boolean isShared() {
        return true;
    }

    public Bundle getBundle() {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.delegate.handleSecurity(request, response);
    }

    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
        this.delegate.finishSecurity(request, response);
    }

    public URL getResource(String name) {
        for (Bundle bundle : this.bundles) {
            URL pathUrl = this.delegate.getResource(bundle, name);
            if (pathUrl == null) continue;
            return pathUrl;
        }
        return null;
    }

    public String getMimeType(String name) {
        return this.delegate.getMimeType(name);
    }

    public Set<String> getResourcePaths(String name) {
        for (Bundle bundle : this.bundles) {
            Set<String> paths = this.delegate.getResourcePaths(bundle, name);
            if (paths == null) continue;
            return paths;
        }
        return null;
    }

    public String getContextId() {
        return this.delegate.getContextId();
    }

    public String toString() {
        return "DefaultMultiBundleHttpContext{contextId='" + this.delegate.getContextId() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMultiBundleWebContainerContext that = (DefaultMultiBundleWebContainerContext)o;
        return this.getContextId().equals(that.getContextId());
    }

    public int hashCode() {
        return Objects.hash(this.getContextId());
    }

    public boolean registerBundle(Bundle bundle) {
        if (!this.bundles.contains(bundle)) {
            this.bundles.add(bundle);
            return true;
        }
        return false;
    }

    public boolean deregisterBundle(Bundle bundle) {
        return this.bundles.remove(bundle);
    }
}

