/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.Comparator;
import org.osgi.framework.ServiceReference;

public abstract class RankingComparator
implements Comparator<ServiceReference<?>> {
    public static Comparator<ServiceReference<?>> SRV_RANKING = new RankingComparator(){

        @Override
        public int compare(ServiceReference<?> obj1, ServiceReference<?> obj2) {
            int rank2;
            long id2;
            long id1 = this.getLong(obj1, "service.id");
            if (id1 == (id2 = this.getLong(obj2, "service.id"))) {
                return 0;
            }
            int rank1 = this.getInteger(obj1, "service.ranking");
            if (rank1 == (rank2 = this.getInteger(obj2, "service.ranking"))) {
                return id1 < id2 ? -1 : 1;
            }
            return rank1 > rank2 ? -1 : 1;
        }
    };
    public static Comparator<ServiceReference<?>> CM_RANKING = new RankingComparator(){

        @Override
        public int compare(ServiceReference<?> obj1, ServiceReference<?> obj2) {
            int rank2;
            long id2;
            long id1 = this.getLong(obj1, "service.id");
            if (id1 == (id2 = this.getLong(obj2, "service.id"))) {
                return 0;
            }
            int rank1 = this.getInteger(obj1, "service.cmRanking");
            if (rank1 == (rank2 = this.getInteger(obj2, "service.cmRanking"))) {
                return id1 > id2 ? -1 : 1;
            }
            return rank1 < rank2 ? -1 : 1;
        }
    };

    protected int getInteger(ServiceReference<?> sr, String property) {
        Object rankObj = sr.getProperty(property);
        if (rankObj instanceof Integer) {
            return (Integer)rankObj;
        }
        return 0;
    }

    protected long getLong(ServiceReference<?> sr, String property) {
        Object rankObj = sr.getProperty(property);
        if (rankObj instanceof Long) {
            return (Long)rankObj;
        }
        return 0L;
    }
}

