/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(-20l, -15l, -15l) => -15l
 * clamp(-20l, -15l, 0l) => -15l
 * clamp(-20l, -15l, 15l) => -15l
 * clamp(-20l, 0l, 0l) => 0l
 * clamp(-20l, 0l, 15l) => 0l
 * clamp(-20l, 15l, 15l) => 15l
 * clamp(-6l, -15l, -15l) => -15l
 * clamp(-6l, -15l, 0l) => -6l
 * clamp(-6l, -15l, 15l) => -6l
 * clamp(-6l, 0l, 0l) => 0l
 * clamp(-6l, 0l, 15l) => 0l
 * clamp(-6l, 15l, 15l) => 15l
 * clamp(6l, -15l, -15l) => -15l
 * clamp(6l, -15l, 0l) => 0l
 * clamp(6l, -15l, 15l) => 6l
 * clamp(6l, 0l, 0l) => 0l
 * clamp(6l, 0l, 15l) => 6l
 * clamp(6l, 15l, 15l) => 15l
 * clamp(20l, -15l, -15l) => -15l
 * clamp(20l, -15l, 0l) => 0l
 * clamp(20l, -15l, 15l) => 15l
 * clamp(20l, 0l, 0l) => 0l
 * clamp(20l, 0l, 15l) => 15l
 * clamp(20l, 15l, 15l) => 15l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[clamp(-20l, -15l, -15l) == -15l ? 1 : -1] array0;
  float[clamp(-20l, -15l, 0l) == -15l ? 1 : -1] array1;
  float[clamp(-20l, -15l, 15l) == -15l ? 1 : -1] array2;
  float[clamp(-20l, 0l, 0l) == 0l ? 1 : -1] array3;
  float[clamp(-20l, 0l, 15l) == 0l ? 1 : -1] array4;
  float[clamp(-20l, 15l, 15l) == 15l ? 1 : -1] array5;
  float[clamp(-6l, -15l, -15l) == -15l ? 1 : -1] array6;
  float[clamp(-6l, -15l, 0l) == -6l ? 1 : -1] array7;
  float[clamp(-6l, -15l, 15l) == -6l ? 1 : -1] array8;
  float[clamp(-6l, 0l, 0l) == 0l ? 1 : -1] array9;
  float[clamp(-6l, 0l, 15l) == 0l ? 1 : -1] array10;
  float[clamp(-6l, 15l, 15l) == 15l ? 1 : -1] array11;
  float[clamp(6l, -15l, -15l) == -15l ? 1 : -1] array12;
  float[clamp(6l, -15l, 0l) == 0l ? 1 : -1] array13;
  float[clamp(6l, -15l, 15l) == 6l ? 1 : -1] array14;
  float[clamp(6l, 0l, 0l) == 0l ? 1 : -1] array15;
  float[clamp(6l, 0l, 15l) == 6l ? 1 : -1] array16;
  float[clamp(6l, 15l, 15l) == 15l ? 1 : -1] array17;
  float[clamp(20l, -15l, -15l) == -15l ? 1 : -1] array18;
  float[clamp(20l, -15l, 0l) == 0l ? 1 : -1] array19;
  float[clamp(20l, -15l, 15l) == 15l ? 1 : -1] array20;
  float[clamp(20l, 0l, 0l) == 0l ? 1 : -1] array21;
  float[clamp(20l, 0l, 15l) == 15l ? 1 : -1] array22;
  float[clamp(20l, 15l, 15l) == 15l ? 1 : -1] array23;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
