/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(uvec3(0u, 1u, 2u), 0u) => uvec3(0u, 0u, 0u)
 * min(uvec3(5u, 34u, 0u), 0u) => uvec3(0u, 0u, 0u)
 * min(uvec3(0u, 1u, 2u), 1u) => uvec3(0u, 1u, 1u)
 * min(uvec3(5u, 34u, 0u), 1u) => uvec3(1u, 1u, 0u)
 * min(uvec3(0u, 1u, 2u), 2u) => uvec3(0u, 1u, 2u)
 * min(uvec3(5u, 34u, 0u), 2u) => uvec3(2u, 2u, 0u)
 * min(uvec3(0u, 1u, 2u), 5u) => uvec3(0u, 1u, 2u)
 * min(uvec3(5u, 34u, 0u), 5u) => uvec3(5u, 5u, 0u)
 * min(uvec3(0u, 1u, 2u), 34u) => uvec3(0u, 1u, 2u)
 * min(uvec3(5u, 34u, 0u), 34u) => uvec3(5u, 34u, 0u)
 */
#version 130

void main()
{
  float[all(equal(min(uvec3(0u, 1u, 2u), 0u), uvec3(0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal(min(uvec3(5u, 34u, 0u), 0u), uvec3(0u, 0u, 0u))) ? 1 : -1] array1;
  float[all(equal(min(uvec3(0u, 1u, 2u), 1u), uvec3(0u, 1u, 1u))) ? 1 : -1] array2;
  float[all(equal(min(uvec3(5u, 34u, 0u), 1u), uvec3(1u, 1u, 0u))) ? 1 : -1] array3;
  float[all(equal(min(uvec3(0u, 1u, 2u), 2u), uvec3(0u, 1u, 2u))) ? 1 : -1] array4;
  float[all(equal(min(uvec3(5u, 34u, 0u), 2u), uvec3(2u, 2u, 0u))) ? 1 : -1] array5;
  float[all(equal(min(uvec3(0u, 1u, 2u), 5u), uvec3(0u, 1u, 2u))) ? 1 : -1] array6;
  float[all(equal(min(uvec3(5u, 34u, 0u), 5u), uvec3(5u, 5u, 0u))) ? 1 : -1] array7;
  float[all(equal(min(uvec3(0u, 1u, 2u), 34u), uvec3(0u, 1u, 2u))) ? 1 : -1] array8;
  float[all(equal(min(uvec3(5u, 34u, 0u), 34u), uvec3(5u, 34u, 0u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
