/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.EditorSplitSubModel;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.SplitSubModel;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModesSubModel {
    private final Model parentModel;
    private final Set<ModeImpl> modes = new HashSet<ModeImpl>(10);
    private final EditorSplitSubModel editorSplitSubModel;
    private final HashMap<ModeImpl, String> slidingModes2Sides = new HashMap(5);
    private final HashMap<String, ModeImpl> slidingSides2Modes = new HashMap(5);
    private ModeImpl activeMode;
    private ModeImpl editorMaximizedMode;
    private ModeImpl viewMaximizedMode;
    private final Map<String, Integer> slideInSizes = new HashMap<String, Integer>(15);

    public ModesSubModel(Model model) {
        this.parentModel = model;
        this.editorSplitSubModel = new EditorSplitSubModel(model, new SplitSubModel(model));
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        this.editorSplitSubModel.setEditorNodeConstraints(splitConstraintArray);
    }

    public SplitConstraint[] getModelElementConstraints(ModelElement modelElement) {
        return this.editorSplitSubModel.getModelElementConstraints(modelElement);
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.editorSplitSubModel.getEditorNodeConstraints();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        if (modeImpl.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().getModeConstraints(modeImpl);
        }
        return this.editorSplitSubModel.getModeConstraints(modeImpl);
    }

    public String getSlideSideForMode(ModeImpl modeImpl) {
        return this.editorSplitSubModel.getSlideSideForMode(modeImpl);
    }

    public String getSlidingModeConstraints(ModeImpl modeImpl) {
        return this.slidingModes2Sides.get(modeImpl);
    }

    public ModeImpl getSlidingMode(String string) {
        return this.slidingSides2Modes.get(string);
    }

    public Set<ModeImpl> getSlidingModes() {
        return Collections.unmodifiableSet(this.slidingModes2Sides.keySet());
    }

    public boolean addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 && modeImpl.getState() == 0 ? this.editorSplitSubModel.getEditorArea().addMode(modeImpl, splitConstraintArray) : this.editorSplitSubModel.addMode(modeImpl, splitConstraintArray);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeToSide(ModeImpl modeImpl, ModeImpl modeImpl2, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addModeToSide(modeImpl, modeImpl2, string) : this.editorSplitSubModel.addModeToSide(modeImpl, modeImpl2, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeAround(ModeImpl modeImpl, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? false : this.editorSplitSubModel.addModeAround(modeImpl, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeAroundEditor(ModeImpl modeImpl, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addModeToSideRoot(modeImpl, string) : this.editorSplitSubModel.addModeAroundEditor(modeImpl, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeSliding(ModeImpl modeImpl, String string, Map<String, Integer> map) {
        if (this.modes.contains(modeImpl) || modeImpl.getKind() != 2) {
            return false;
        }
        this.slidingModes2Sides.put(modeImpl, string);
        this.slidingSides2Modes.put(string, modeImpl);
        this.modes.add(modeImpl);
        if (null != map) {
            for (String string2 : map.keySet()) {
                this.slideInSizes.put(string + string2, map.get(string2));
            }
        }
        return true;
    }

    public Map<String, Integer> getSlideInSizes(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(5);
        for (String string2 : this.slideInSizes.keySet()) {
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            Integer n = this.slideInSizes.get(string2);
            hashMap.put(string3, n);
        }
        return hashMap;
    }

    public Map<TopComponent, Integer> getSlideInSizes(ModeImpl modeImpl) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = modeImpl.getTopComponents();
        HashMap<TopComponent, Integer> hashMap = new HashMap<TopComponent, Integer>(topComponentArray.length);
        for (TopComponent topComponent : topComponentArray) {
            String string = windowManagerImpl.findTopComponentID(topComponent);
            Integer n = this.slideInSizes.get(modeImpl.getSide() + string);
            if (null == n) continue;
            hashMap.put(topComponent, n);
        }
        return hashMap;
    }

    public void setSlideInSize(String string, TopComponent topComponent, int n) {
        if (null != topComponent && null != string) {
            String string2 = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
            this.slideInSizes.put(string + string2, new Integer(n));
        }
    }

    public boolean removeMode(ModeImpl modeImpl) {
        int n = modeImpl.getKind();
        if (n == 2) {
            return true;
        }
        this.modes.remove(modeImpl);
        if (modeImpl.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().removeMode(modeImpl);
        }
        return this.editorSplitSubModel.removeMode(modeImpl);
    }

    public boolean setActiveMode(ModeImpl modeImpl) {
        if (modeImpl == null || this.modes.contains(modeImpl)) {
            this.activeMode = modeImpl;
            return true;
        }
        return false;
    }

    public ModeImpl getActiveMode() {
        return this.activeMode;
    }

    public boolean setEditorMaximizedMode(ModeImpl modeImpl) {
        if (modeImpl == null || this.modes.contains(modeImpl)) {
            this.editorMaximizedMode = modeImpl;
            return true;
        }
        return false;
    }

    public ModeImpl getEditorMaximizedMode() {
        return this.editorMaximizedMode;
    }

    public boolean setViewMaximizedMode(ModeImpl modeImpl) {
        if (modeImpl == null || this.modes.contains(modeImpl)) {
            this.viewMaximizedMode = modeImpl;
            return true;
        }
        return false;
    }

    public ModeImpl getViewMaximizedMode() {
        return this.viewMaximizedMode;
    }

    public Set<ModeImpl> getModes() {
        return new HashSet<ModeImpl>(this.modes);
    }

    public void setSplitWeights(ModelElement[] modelElementArray, double[] dArray) {
        this.editorSplitSubModel.setSplitWeights(modelElementArray, dArray);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "\n" + this.editorSplitSubModel;
    }

    public ModeStructureSnapshot.ElementSnapshot createSplitSnapshot() {
        return this.editorSplitSubModel.createSplitSnapshot();
    }

    public Set<ModeStructureSnapshot.ModeSnapshot> createSeparateModeSnapshots() {
        HashSet<ModeStructureSnapshot.ModeSnapshot> hashSet = new HashSet<ModeStructureSnapshot.ModeSnapshot>();
        hashSet.addAll(this.editorSplitSubModel.createSeparateSnapshots());
        return hashSet;
    }

    public Set<ModeStructureSnapshot.SlidingModeSnapshot> createSlidingModeSnapshots() {
        HashSet<ModeStructureSnapshot.SlidingModeSnapshot> hashSet = new HashSet<ModeStructureSnapshot.SlidingModeSnapshot>();
        for (Map.Entry<ModeImpl, String> entry : this.slidingModes2Sides.entrySet()) {
            hashSet.add(new ModeStructureSnapshot.SlidingModeSnapshot(entry.getKey(), entry.getValue(), this.getSlideInSizes(entry.getKey())));
        }
        return hashSet;
    }

    public ModeImpl getModeForOriginator(ModelElement modelElement) {
        ModeImpl modeImpl = this.editorSplitSubModel.getModeForOriginator(modelElement);
        if (this.modes.contains(modeImpl)) {
            return modeImpl;
        }
        return null;
    }
}

