/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css2;

import java.util.ArrayList;
import org.w3c.css.atrules.css.media.Media;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public class AtRuleMedia
extends org.w3c.css.atrules.css.AtRuleMedia {
    static final String[] mediaCSS2 = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv"};

    @Override
    public org.w3c.css.atrules.css.AtRuleMedia addMedia(String restrictor, String medium, ApplContext ac) throws InvalidParamException {
        if (restrictor != null) {
            throw new InvalidParamException("nomediarestrictor", restrictor, ac);
        }
        medium = medium.toLowerCase();
        for (String s : mediaCSS2) {
            if (!medium.equals(s)) continue;
            this.allMedia.add(new Media(s));
            return this;
        }
        throw new InvalidParamException("media", medium, ac);
    }

    @Override
    public void addMediaFeature(MediaFeature feature, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("nomediafeature", feature.toString(), ac);
    }

    @Override
    public boolean canApply(AtRule atRule) {
        try {
            org.w3c.css.atrules.css.AtRuleMedia second = (org.w3c.css.atrules.css.AtRuleMedia)atRule;
            return this.canMatch(second) && second.canMatch(this);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public boolean canMatch(AtRule atRule) {
        try {
            org.w3c.css.atrules.css.AtRuleMedia second = (org.w3c.css.atrules.css.AtRuleMedia)atRule;
            ArrayList<Media> otherMediaList = second.getMediaList();
            for (Media m : otherMediaList) {
                if (this.allMedia.contains(m)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Media m : this.allMedia) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(m.toString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.keyword()).append(' ');
        sb.append(this.getValueString());
        return sb.toString();
    }
}

