/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store.index;

import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.lucene.util.Accountable;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.monitor.jvm.JvmInfo;

public class Caches {
    public static final Setting<ByteSizeValue> LTR_CACHE_MEM_SETTING;
    public static final Setting<TimeValue> LTR_CACHE_EXPIRE_AFTER_WRITE;
    public static final Setting<TimeValue> LTR_CACHE_EXPIRE_AFTER_READ;
    private final Cache<CacheKey, Feature> featureCache;
    private final Cache<CacheKey, FeatureSet> featureSetCache;
    private final Cache<CacheKey, CompiledLtrModel> modelCache;
    private final Map<String, PerStoreStats> perStoreStats = new ConcurrentHashMap<String, PerStoreStats>();
    private final long maxWeight;

    public Caches(TimeValue expAfterWrite, TimeValue expAfterAccess, ByteSizeValue maxWeight) {
        this.featureCache = this.configCache(CacheBuilder.builder(), expAfterWrite, expAfterAccess, maxWeight).weigher(Caches::weigther).removalListener(l -> this.onRemove((CacheKey)l.getKey(), l.getValue())).build();
        this.featureSetCache = this.configCache(CacheBuilder.builder(), expAfterWrite, expAfterAccess, maxWeight).weigher(Caches::weigther).removalListener(l -> this.onRemove((CacheKey)l.getKey(), l.getValue())).build();
        this.modelCache = this.configCache(CacheBuilder.builder(), expAfterWrite, expAfterAccess, maxWeight).weigher((s, w) -> w.ramBytesUsed()).removalListener(l -> this.onRemove((CacheKey)l.getKey(), l.getValue())).build();
        this.maxWeight = maxWeight.getBytes();
    }

    public static long weigther(CacheKey key, Object data) {
        if (data instanceof Accountable) {
            return ((Accountable)data).ramBytesUsed();
        }
        return 1L;
    }

    private <K, V> CacheBuilder<K, V> configCache(CacheBuilder<K, V> builder, TimeValue expireAfterWrite, TimeValue expireAfterAccess, ByteSizeValue maxWeight) {
        if (expireAfterWrite.nanos() > 0L) {
            builder.setExpireAfterWrite(expireAfterWrite);
        }
        if (expireAfterAccess.nanos() > 0L) {
            builder.setExpireAfterAccess(expireAfterAccess);
        }
        builder.setMaximumWeight(maxWeight.getBytes());
        return builder;
    }

    public Caches(Settings settings) {
        this((TimeValue)LTR_CACHE_EXPIRE_AFTER_WRITE.get(settings), (TimeValue)LTR_CACHE_EXPIRE_AFTER_READ.get(settings), (ByteSizeValue)LTR_CACHE_MEM_SETTING.get(settings));
    }

    private void onAdd(CacheKey k, Object acc) {
        this.perStoreStats.compute(k.getStoreName(), (k2, v) -> v != null ? v.add(acc) : new PerStoreStats(acc));
    }

    private void onRemove(CacheKey k, Object acc) {
        this.perStoreStats.compute(k.getStoreName(), (k2, v) -> {
            assert (v != null);
            return v.remove(acc) > 0L ? v : null;
        });
    }

    Feature loadFeature(CacheKey key, CheckedFunction<String, Feature, IOException> loader) throws IOException {
        return this.cacheLoad(key, this.featureCache, loader);
    }

    FeatureSet loadFeatureSet(CacheKey key, CheckedFunction<String, FeatureSet, IOException> loader) throws IOException {
        return this.cacheLoad(key, this.featureSetCache, loader);
    }

    CompiledLtrModel loadModel(CacheKey key, CheckedFunction<String, CompiledLtrModel, IOException> loader) throws IOException {
        return this.cacheLoad(key, this.modelCache, loader);
    }

    private <E> E cacheLoad(CacheKey key, Cache<CacheKey, E> cache, CheckedFunction<String, E, IOException> loader) throws IOException {
        try {
            return (E)cache.computeIfAbsent((Object)key, k -> {
                Object elt = loader.apply((Object)k.getId());
                if (elt != null) {
                    this.onAdd((CacheKey)k, elt);
                }
                return elt;
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    public void evict(String index) {
        this.evict(index, this.featureCache);
        this.evict(index, this.featureSetCache);
        this.evict(index, this.modelCache);
    }

    public void evictFeature(String index, String name) {
        this.featureCache.invalidate((Object)new CacheKey(index, name));
    }

    public void evictFeatureSet(String index, String name) {
        this.featureSetCache.invalidate((Object)new CacheKey(index, name));
    }

    public void evictModel(String index, String name) {
        this.modelCache.invalidate((Object)new CacheKey(index, name));
    }

    private void evict(String index, Cache<CacheKey, ?> cache) {
        Iterator ite = cache.keys().iterator();
        while (ite.hasNext()) {
            if (!((CacheKey)ite.next()).storeName.equals(index)) continue;
            ite.remove();
        }
    }

    public Cache<CacheKey, Feature> featureCache() {
        return this.featureCache;
    }

    public Cache<CacheKey, FeatureSet> featureSetCache() {
        return this.featureSetCache;
    }

    public Cache<CacheKey, CompiledLtrModel> modelCache() {
        return this.modelCache;
    }

    public Set<String> getCachedStoreNames() {
        return this.perStoreStats.keySet();
    }

    public Stream<Map.Entry<String, PerStoreStats>> perStoreStatsStream() {
        return this.perStoreStats.entrySet().stream();
    }

    public PerStoreStats getPerStoreStats(String store) {
        PerStoreStats stats = this.perStoreStats.get(store);
        if (stats != null) {
            return stats;
        }
        return PerStoreStats.EMPTY;
    }

    public long getMaxWeight() {
        return this.maxWeight;
    }

    static {
        LTR_CACHE_EXPIRE_AFTER_WRITE = Setting.timeSetting((String)"ltr.caches.expire_after_write", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.timeValueNanos((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        LTR_CACHE_EXPIRE_AFTER_READ = Setting.timeSetting((String)"ltr.caches.expire_after_read", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.timeValueNanos((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        LTR_CACHE_MEM_SETTING = Setting.memorySizeSetting((String)"ltr.caches.max_mem", s -> new ByteSizeValue(Math.min(0xA00000L, JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 10L)).toString(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    public static class CacheKey {
        private final String storeName;
        private final String id;

        public CacheKey(String storeName, String id) {
            this.storeName = Objects.requireNonNull(storeName);
            this.id = Objects.requireNonNull(id);
        }

        public String getStoreName() {
            return this.storeName;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.storeName.equals(cacheKey.storeName)) {
                return false;
            }
            return this.id.equals(cacheKey.id);
        }

        public int hashCode() {
            int result = this.storeName.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }

    public static class PerStoreStats {
        public static final PerStoreStats EMPTY = new PerStoreStats();
        private final AtomicLong ramAll = new AtomicLong();
        private final AtomicInteger countAll = new AtomicInteger();
        private final AtomicLong featureRam = new AtomicLong();
        private final AtomicInteger featureCount = new AtomicInteger();
        private final AtomicLong featureSetRam = new AtomicLong();
        private final AtomicInteger featureSetCount = new AtomicInteger();
        private final AtomicLong modelRam = new AtomicLong();
        private final AtomicInteger modelCount = new AtomicInteger();

        PerStoreStats() {
        }

        PerStoreStats(Object acc) {
            this.add(Objects.requireNonNull(acc));
        }

        public PerStoreStats add(Object elt) {
            int nb = this.update(true, elt);
            assert (nb > 0);
            return this;
        }

        private long remove(Object elt) {
            return this.update(false, elt);
        }

        private int update(boolean add, Object elt) {
            AtomicLong ram;
            AtomicInteger count;
            int factor;
            Objects.requireNonNull(elt);
            int n = factor = add ? 1 : -1;
            if (elt instanceof Feature) {
                count = this.featureCount;
                ram = this.featureRam;
            } else if (elt instanceof FeatureSet) {
                count = this.featureSetCount;
                ram = this.featureSetRam;
            } else if (elt instanceof CompiledLtrModel) {
                count = this.modelCount;
                ram = this.modelRam;
            } else {
                throw new IllegalArgumentException("Unsupported class " + String.valueOf(elt.getClass()));
            }
            long ramUsed = 1L;
            if (elt instanceof Accountable) {
                ramUsed = ((Accountable)elt).ramBytesUsed();
            }
            ram.addAndGet((long)factor * ramUsed);
            assert (ram.get() >= 0L);
            count.addAndGet(factor);
            assert (count.get() >= 0);
            this.ramAll.addAndGet((long)factor * ramUsed);
            assert (this.ramAll.get() >= 0L);
            return this.countAll.addAndGet(factor);
        }

        public long totalRam() {
            return this.ramAll.get();
        }

        public int totalCount() {
            return this.countAll.get();
        }

        public long featureRam() {
            return this.featureRam.get();
        }

        public int featureCount() {
            return this.featureCount.get();
        }

        public long featureSetRam() {
            return this.featureSetRam.get();
        }

        public int featureSetCount() {
            return this.featureSetCount.get();
        }

        public long modelRam() {
            return this.modelRam.get();
        }

        public int modelCount() {
            return this.modelCount.get();
        }
    }
}

