/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.ADResultWriteRequest;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.transport.ResultBulkResponse;
import org.opensearch.timeseries.transport.handler.IndexMemoryPressureAwareResultHandler;

public class ADIndexMemoryPressureAwareResultHandler
extends IndexMemoryPressureAwareResultHandler<AnomalyResult, ADResultWriteRequest, ADResultBulkRequest, ResultBulkResponse, ADIndex, ADIndexManagement> {
    private static final Logger LOG = LogManager.getLogger(ADIndexMemoryPressureAwareResultHandler.class);

    @Inject
    public ADIndexMemoryPressureAwareResultHandler(Client client, ADIndexManagement anomalyDetectionIndices, ClusterService clusterService) {
        super(client, anomalyDetectionIndices, clusterService);
    }

    @Override
    protected void bulk(ADResultBulkRequest currentBulkRequest, ActionListener<ResultBulkResponse> listener) {
        if (currentBulkRequest.numberOfActions() <= 0) {
            listener.onFailure((Exception)new TimeSeriesException("no result to save"));
            return;
        }
        this.client.execute((ActionType)ADResultBulkAction.INSTANCE, (ActionRequest)currentBulkRequest, ActionListener.wrap(response -> {
            LOG.debug("Result saved successfully.");
            listener.onResponse((Object)response);
        }, exception -> {
            LOG.error("Error in bulking results", (Throwable)exception);
            listener.onFailure(exception);
        }));
    }
}

