/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.RawEcdhStaticConfigurations;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class CreateRawEcdhKeyringInput {
    private final RawEcdhStaticConfigurations KeyAgreementScheme;
    private final ECDHCurveSpec curveSpec;

    protected CreateRawEcdhKeyringInput(BuilderImpl builder) {
        this.KeyAgreementScheme = builder.KeyAgreementScheme();
        this.curveSpec = builder.curveSpec();
    }

    public RawEcdhStaticConfigurations KeyAgreementScheme() {
        return this.KeyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this.curveSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected RawEcdhStaticConfigurations KeyAgreementScheme;
        protected ECDHCurveSpec curveSpec;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateRawEcdhKeyringInput model) {
            this.KeyAgreementScheme = model.KeyAgreementScheme();
            this.curveSpec = model.curveSpec();
        }

        @Override
        public Builder KeyAgreementScheme(RawEcdhStaticConfigurations KeyAgreementScheme2) {
            this.KeyAgreementScheme = KeyAgreementScheme2;
            return this;
        }

        @Override
        public RawEcdhStaticConfigurations KeyAgreementScheme() {
            return this.KeyAgreementScheme;
        }

        @Override
        public Builder curveSpec(ECDHCurveSpec curveSpec) {
            this.curveSpec = curveSpec;
            return this;
        }

        @Override
        public ECDHCurveSpec curveSpec() {
            return this.curveSpec;
        }

        @Override
        public CreateRawEcdhKeyringInput build() {
            if (Objects.isNull(this.KeyAgreementScheme())) {
                throw new IllegalArgumentException("Missing value for required field `KeyAgreementScheme`");
            }
            if (Objects.isNull((Object)this.curveSpec())) {
                throw new IllegalArgumentException("Missing value for required field `curveSpec`");
            }
            return new CreateRawEcdhKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder KeyAgreementScheme(RawEcdhStaticConfigurations var1);

        public RawEcdhStaticConfigurations KeyAgreementScheme();

        public Builder curveSpec(ECDHCurveSpec var1);

        public ECDHCurveSpec curveSpec();

        public CreateRawEcdhKeyringInput build();
    }
}

