/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.memory.Memory;
import org.opensearch.ml.common.spi.memory.Message;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.algorithms.agent.MLAgentRunner;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;
import org.opensearch.ml.engine.memory.ConversationIndexMessage;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;

public class MLConversationalFlowAgentRunner
implements MLAgentRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(MLConversationalFlowAgentRunner.class);
    public static final String CHAT_HISTORY = "chat_history";
    private Client client;
    private Settings settings;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private Map<String, Tool.Factory> toolFactories;
    private Map<String, Memory.Factory> memoryFactoryMap;

    public MLConversationalFlowAgentRunner(Client client, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Map<String, Tool.Factory> toolFactories, Map<String, Memory.Factory> memoryFactoryMap) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
    }

    @Override
    public void run(MLAgent mlAgent, Map<String, String> params, ActionListener<Object> listener) {
        String appType = mlAgent.getAppType();
        String memoryId = params.get("memory_id");
        String parentInteractionId = params.get("parent_interaction_id");
        if (appType == null || mlAgent.getMemory() == null) {
            this.runAgent(mlAgent, params, listener, null, memoryId, parentInteractionId);
            return;
        }
        String memoryType = mlAgent.getMemory().getType();
        String title = params.get("question");
        int messageHistoryLimit = AgentUtils.getMessageHistoryLimit(params);
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memoryType);
        conversationIndexMemoryFactory.create(title, memoryId, appType, (ActionListener<ConversationIndexMemory>)ActionListener.wrap(memory -> memory.getMessages(ActionListener.wrap(r -> {
            ArrayList<ConversationIndexMessage> messageList = new ArrayList<ConversationIndexMessage>();
            for (Interaction next : r) {
                String string = next.getInput();
                String response = next.getResponse();
                if (Strings.isNullOrEmpty((String)response)) continue;
                messageList.add(ConversationIndexMessage.conversationIndexMessageBuilder().sessionId(memory.getConversationId()).question(string).response(response).build());
            }
            StringBuilder chatHistoryBuilder = new StringBuilder();
            if (!messageList.isEmpty()) {
                chatHistoryBuilder.append("Below is Chat History between Human and AI which sorted by time with asc order:\n");
                for (Message message : messageList) {
                    chatHistoryBuilder.append(message.toString()).append("\n");
                }
                params.put(CHAT_HISTORY, chatHistoryBuilder.toString());
            }
            this.runAgent(mlAgent, params, listener, (ConversationIndexMemory)memory, memory.getConversationId(), parentInteractionId);
        }, e -> {
            log.error("Failed to get chat history", (Throwable)e);
            listener.onFailure(e);
        }), messageHistoryLimit), arg_0 -> listener.onFailure(arg_0)));
    }

    private void runAgent(MLAgent mlAgent, Map<String, String> params, ActionListener<Object> listener, ConversationIndexMemory memory, String memoryId, String parentInteractionId) {
        StepListener firstStepListener = null;
        Tool firstTool = null;
        ArrayList<ModelTensor> flowAgentOutput = new ArrayList<ModelTensor>();
        Map<String, String> firstToolExecuteParams = null;
        StepListener previousStepListener = null;
        ConcurrentHashMap additionalInfo = new ConcurrentHashMap();
        List<MLToolSpec> toolSpecs = AgentUtils.getMlToolSpecs(mlAgent, params);
        if (toolSpecs == null || toolSpecs.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no tool configured"));
            return;
        }
        AtomicInteger traceNumber = new AtomicInteger(0);
        if (memory != null) {
            flowAgentOutput.add(ModelTensor.builder().name("memory_id").result(memoryId).build());
            flowAgentOutput.add(ModelTensor.builder().name("parent_message_id").result(parentInteractionId).build());
        }
        MLMemorySpec memorySpec = mlAgent.getMemory();
        for (int i = 0; i <= toolSpecs.size(); ++i) {
            if (i == 0) {
                MLToolSpec toolSpec = toolSpecs.get(i);
                Tool tool = AgentUtils.createTool(this.toolFactories, params, toolSpec, mlAgent.getTenantId());
                previousStepListener = firstStepListener = new StepListener();
                firstTool = tool;
                firstToolExecuteParams = this.getToolExecuteParams(toolSpec, params, mlAgent.getTenantId());
                continue;
            }
            MLToolSpec previousToolSpec = toolSpecs.get(i - 1);
            StepListener nextStepListener = new StepListener();
            int finalI = i;
            previousStepListener.whenComplete(output -> this.processOutput(params, listener, memory, memoryId, parentInteractionId, toolSpecs, flowAgentOutput, additionalInfo, traceNumber, memorySpec, previousToolSpec, finalI, output, mlAgent.getTenantId(), (StepListener<Object>)nextStepListener), e -> {
                log.error("Failed to run flow agent", (Throwable)e);
                listener.onFailure(e);
            });
            previousStepListener = nextStepListener;
        }
        if (toolSpecs.size() == 1) {
            firstTool.run(firstToolExecuteParams, ActionListener.wrap(output -> {
                MLToolSpec toolSpec = (MLToolSpec)toolSpecs.get(0);
                this.processOutput(params, listener, memory, memoryId, parentInteractionId, toolSpecs, flowAgentOutput, additionalInfo, traceNumber, memorySpec, toolSpec, 1, output, mlAgent.getTenantId(), null);
            }, e -> listener.onFailure(e)));
        } else {
            firstTool.run(firstToolExecuteParams, firstStepListener);
        }
    }

    private void processOutput(Map<String, String> params, ActionListener<Object> listener, ConversationIndexMemory memory, String memoryId, String parentInteractionId, List<MLToolSpec> toolSpecs, List<ModelTensor> flowAgentOutput, Map<String, Object> additionalInfo, AtomicInteger traceNumber, MLMemorySpec memorySpec, MLToolSpec previousToolSpec, int finalI, Object output, String tenantId, StepListener<Object> nextStepListener) throws IOException, PrivilegedActionException {
        boolean traceDisabled;
        String toolName = AgentUtils.getToolName(previousToolSpec);
        String outputKey = toolName + ".output";
        String outputResponse = this.parseResponse(output);
        params.put(outputKey, StringEscapeUtils.escapeJson((String)outputResponse));
        boolean bl = traceDisabled = params.containsKey("disable_trace") && Boolean.parseBoolean(params.get("disable_trace"));
        if (previousToolSpec.isIncludeOutputInAgentResponse() || finalI == toolSpecs.size()) {
            if (output instanceof ModelTensorOutput) {
                flowAgentOutput.addAll(((ModelTensors)((ModelTensorOutput)output).getMlModelOutputs().get(0)).getMlModelTensors());
            } else {
                String result = output instanceof String ? (String)output : AccessController.doPrivileged(() -> StringUtils.toJson((Object)output));
                ModelTensor stepOutput = ModelTensor.builder().name(toolName).result(result).build();
                flowAgentOutput.add(stepOutput);
            }
            if (memory == null) {
                additionalInfo.put(outputKey, outputResponse);
            }
        }
        if (finalI == toolSpecs.size()) {
            ActionListener updateListener = ActionListener.wrap(r -> {
                log.info("Updated additional info for interaction {} of flow agent.", (Object)r.getId());
                listener.onResponse((Object)flowAgentOutput);
            }, e -> {
                log.error("Failed to update root interaction", (Throwable)e);
                listener.onResponse((Object)flowAgentOutput);
            });
            if (memory == null) {
                if (memoryId == null || parentInteractionId == null || memorySpec == null || memorySpec.getType() == null) {
                    listener.onResponse(flowAgentOutput);
                } else {
                    this.updateMemoryWithListener(additionalInfo, memorySpec, memoryId, parentInteractionId, updateListener);
                }
            } else {
                this.saveMessage(params, memory, outputResponse, memoryId, parentInteractionId, toolName, traceNumber, traceDisabled, ActionListener.wrap(r -> {
                    log.info("saved last trace for interaction " + parentInteractionId + " of flow agent");
                    Map<String, Object> updateContent = Map.of("response", outputResponse, "additional_info", additionalInfo);
                    memory.update(parentInteractionId, updateContent, (ActionListener<UpdateResponse>)updateListener);
                }, e -> {
                    log.error("Failed to update root interaction ", (Throwable)e);
                    listener.onFailure(e);
                }));
            }
        } else if (memory == null) {
            this.runNextStep(params, toolSpecs, finalI, tenantId, nextStepListener);
        } else {
            this.saveMessage(params, memory, outputResponse, memoryId, parentInteractionId, toolName, traceNumber, traceDisabled, ActionListener.wrap(r -> this.runNextStep(params, toolSpecs, finalI, tenantId, nextStepListener), e -> {
                log.error("Failed to update root interaction ", (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }

    private void runNextStep(Map<String, String> params, List<MLToolSpec> toolSpecs, int finalI, String tenantId, StepListener<Object> nextStepListener) {
        MLToolSpec toolSpec = toolSpecs.get(finalI);
        Tool tool = AgentUtils.createTool(this.toolFactories, params, toolSpec, tenantId);
        if (finalI < toolSpecs.size()) {
            tool.run(this.getToolExecuteParams(toolSpec, params, tenantId), nextStepListener);
        }
    }

    private void saveMessage(Map<String, String> params, ConversationIndexMemory memory, String outputResponse, String memoryId, String parentInteractionId, String toolName, AtomicInteger traceNumber, boolean traceDisabled, ActionListener listener) {
        ConversationIndexMessage finalMessage = ConversationIndexMessage.conversationIndexMessageBuilder().type(memory.getType()).question(params.get("question")).response(outputResponse).finalAnswer(true).sessionId(memoryId).build();
        if (traceDisabled) {
            listener.onResponse((Object)true);
        } else {
            memory.save(finalMessage, parentInteractionId, traceNumber.addAndGet(1), toolName, listener);
        }
    }

    @VisibleForTesting
    void updateMemoryWithListener(Map<String, Object> additionalInfo, MLMemorySpec memorySpec, String memoryId, String interactionId, ActionListener listener) {
        if (memoryId == null || interactionId == null || memorySpec == null || memorySpec.getType() == null) {
            return;
        }
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memorySpec.getType());
        conversationIndexMemoryFactory.create(memoryId, (ActionListener<ConversationIndexMemory>)ActionListener.wrap(memory -> memory.update(interactionId, Map.of("additional_info", additionalInfo), (ActionListener<UpdateResponse>)listener), e -> log.error("Failed create memory from id: " + memoryId, (Throwable)e)));
    }

    @VisibleForTesting
    String parseResponse(Object output) throws IOException {
        if (output instanceof List && !((List)output).isEmpty() && ((List)output).get(0) instanceof ModelTensors) {
            ModelTensors tensors = (ModelTensors)((List)output).get(0);
            return tensors.toXContent(JsonXContent.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensor) {
            return ((ModelTensor)output).toXContent(JsonXContent.contentBuilder(), null).toString();
        }
        if (output instanceof ModelTensorOutput) {
            return ((ModelTensorOutput)output).toXContent(JsonXContent.contentBuilder(), null).toString();
        }
        if (output instanceof String) {
            return (String)output;
        }
        return StringUtils.toJson((Object)output);
    }

    @VisibleForTesting
    Map<String, String> getToolExecuteParams(MLToolSpec toolSpec, Map<String, String> params, String tenantId) {
        HashMap<String, String> executeParams = new HashMap<String, String>();
        if (toolSpec.getParameters() != null) {
            executeParams.putAll(toolSpec.getParameters());
        }
        executeParams.put("tenant_id", tenantId);
        for (String key : params.keySet()) {
            String toBeReplaced = null;
            if (key.startsWith(toolSpec.getType() + ".")) {
                toBeReplaced = toolSpec.getType() + ".";
            }
            if (toolSpec.getName() != null && key.startsWith(toolSpec.getName() + ".")) {
                toBeReplaced = toolSpec.getName() + ".";
            }
            if (toBeReplaced != null) {
                executeParams.put(key.replace(toBeReplaced, ""), params.get(key));
                continue;
            }
            executeParams.put(key, params.get(key));
        }
        if (toolSpec.getConfigMap() != null && !toolSpec.getConfigMap().isEmpty()) {
            executeParams.putAll(toolSpec.getConfigMap());
        }
        if (executeParams.containsKey("input")) {
            String input = (String)executeParams.get("input");
            StringSubstitutor substitutor = new StringSubstitutor(executeParams, "${parameters.", "}");
            input = substitutor.replace(input);
            executeParams.put("input", input);
        }
        return executeParams;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public Map<String, Tool.Factory> getToolFactories() {
        return this.toolFactories;
    }

    @Generated
    public Map<String, Memory.Factory> getMemoryFactoryMap() {
        return this.memoryFactoryMap;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    @Generated
    public void setToolFactories(Map<String, Tool.Factory> toolFactories) {
        this.toolFactories = toolFactories;
    }

    @Generated
    public void setMemoryFactoryMap(Map<String, Memory.Factory> memoryFactoryMap) {
        this.memoryFactoryMap = memoryFactoryMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLConversationalFlowAgentRunner)) {
            return false;
        }
        MLConversationalFlowAgentRunner other = (MLConversationalFlowAgentRunner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        ClusterService this$clusterService = this.getClusterService();
        ClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        NamedXContentRegistry this$xContentRegistry = this.getXContentRegistry();
        NamedXContentRegistry other$xContentRegistry = other.getXContentRegistry();
        if (this$xContentRegistry == null ? other$xContentRegistry != null : !this$xContentRegistry.equals(other$xContentRegistry)) {
            return false;
        }
        Map<String, Tool.Factory> this$toolFactories = this.getToolFactories();
        Map<String, Tool.Factory> other$toolFactories = other.getToolFactories();
        if (this$toolFactories == null ? other$toolFactories != null : !((Object)this$toolFactories).equals(other$toolFactories)) {
            return false;
        }
        Map<String, Memory.Factory> this$memoryFactoryMap = this.getMemoryFactoryMap();
        Map<String, Memory.Factory> other$memoryFactoryMap = other.getMemoryFactoryMap();
        return !(this$memoryFactoryMap == null ? other$memoryFactoryMap != null : !((Object)this$memoryFactoryMap).equals(other$memoryFactoryMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLConversationalFlowAgentRunner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        ClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        NamedXContentRegistry $xContentRegistry = this.getXContentRegistry();
        result = result * 59 + ($xContentRegistry == null ? 43 : $xContentRegistry.hashCode());
        Map<String, Tool.Factory> $toolFactories = this.getToolFactories();
        result = result * 59 + ($toolFactories == null ? 43 : ((Object)$toolFactories).hashCode());
        Map<String, Memory.Factory> $memoryFactoryMap = this.getMemoryFactoryMap();
        result = result * 59 + ($memoryFactoryMap == null ? 43 : ((Object)$memoryFactoryMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLConversationalFlowAgentRunner(client=" + String.valueOf(this.getClient()) + ", settings=" + String.valueOf(this.getSettings()) + ", clusterService=" + String.valueOf(this.getClusterService()) + ", xContentRegistry=" + String.valueOf(this.getXContentRegistry()) + ", toolFactories=" + String.valueOf(this.getToolFactories()) + ", memoryFactoryMap=" + String.valueOf(this.getMemoryFactoryMap()) + ")";
    }

    @Generated
    public MLConversationalFlowAgentRunner() {
    }
}

